/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.hibernate.search.backend.elasticsearch.client.impl.CountingOutputStream;
import org.hibernate.search.backend.elasticsearch.client.impl.HttpAsyncContentProducerInputStream;
import org.hibernate.search.backend.elasticsearch.client.impl.ProgressiveCharBufferWriter;
import org.hibernate.search.util.common.impl.Contracts;

final class GsonHttpEntity
implements HttpEntity,
HttpAsyncContentProducer {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final BasicHeader CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
    private static final int BYTE_BUFFER_PAGE_SIZE = 1024;
    private static final int CHAR_BUFFER_SIZE = 1024;
    private final Gson gson;
    private final List<JsonObject> bodyParts;
    private long contentLength;
    private boolean contentLengthWasProvided = false;
    private int nextBodyToEncodeIndex = 0;
    private ProgressiveCharBufferWriter writer = new ProgressiveCharBufferWriter(CHARSET, 1024, 1024);

    public GsonHttpEntity(Gson gson, List<JsonObject> bodyParts) throws IOException {
        Contracts.assertNotNull((Object)gson, (String)"gson");
        Contracts.assertNotNull(bodyParts, (String)"bodyParts");
        this.gson = gson;
        this.bodyParts = bodyParts;
        this.contentLength = -1L;
        this.attemptOnePassEncoding();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        this.contentLengthWasProvided = true;
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() {
        return new HttpAsyncContentProducerInputStream(this, 1024);
    }

    public void writeTo(OutputStream out) throws IOException {
        CountingOutputStream countingStream = new CountingOutputStream(out);
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)countingStream, CHARSET);
        for (JsonObject bodyPart : this.bodyParts) {
            this.gson.toJson((JsonElement)bodyPart, (Appendable)outWriter);
            outWriter.append('\n');
        }
        ((Writer)outWriter).flush();
        this.hintContentLength(countingStream.getBytesWritten());
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() {
    }

    public void close() {
        this.nextBodyToEncodeIndex = 0;
        this.writer = new ProgressiveCharBufferWriter(CHARSET, 1024, 1024);
    }

    private void attemptOnePassEncoding() throws IOException {
        this.triggerFullWrite();
        if (this.nextBodyToEncodeIndex == this.bodyParts.size()) {
            this.writer.flush();
            this.hintContentLength(this.writer.contentLength());
        }
    }

    private void triggerFullWrite() throws IOException {
        while (this.nextBodyToEncodeIndex < this.bodyParts.size()) {
            JsonObject bodyPart = this.bodyParts.get(this.nextBodyToEncodeIndex++);
            this.gson.toJson((JsonElement)bodyPart, (Appendable)this.writer);
            this.writer.append('\n');
            this.writer.flush();
            if (!this.writer.isFlowControlPushingBack()) continue;
            return;
        }
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        Contracts.assertNotNull((Object)encoder, (String)"encoder");
        this.writer.setOutput(encoder);
        this.writer.resumePendingWrites();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        this.triggerFullWrite();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        this.writer.flushToOutput();
        if (this.writer.isFlowControlPushingBack()) {
            return;
        }
        this.hintContentLength(this.writer.contentLength());
        encoder.complete();
    }

    private void hintContentLength(long contentLength) {
        if (!this.contentLengthWasProvided) {
            this.contentLength = contentLength;
        }
    }
}

