/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.hibernate.search.engine.search.sort.spi.WithParametersSortBuilder;

class ElasticsearchWithParametersSort
extends AbstractElasticsearchSort {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends SortFinalStep> sortCreator;

    ElasticsearchWithParametersSort(Builder builder) {
        super(builder);
        this.scope = builder.scope;
        this.sortCreator = builder.sortCreator;
    }

    @Override
    public void toJsonSorts(ElasticsearchSearchSortCollector collector) {
        SearchSort sort = this.sortCreator.apply((NamedValues)collector.getRootPredicateContext().queryParameters()).toSort();
        ElasticsearchSearchSort.from(this.scope, sort).toJsonSorts(collector);
    }

    static class Builder
    extends AbstractElasticsearchSort.AbstractBuilder
    implements WithParametersSortBuilder {
        private Function<? super NamedValues, ? extends SortFinalStep> sortCreator;

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public void creator(Function<? super NamedValues, ? extends SortFinalStep> sortCreator) {
            this.sortCreator = sortCreator;
        }

        public SearchSort build() {
            return new ElasticsearchWithParametersSort(this);
        }
    }
}

