/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.CustomBackoffConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class CustomBackoffConfigImpl
implements CustomBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final CustomBackoff instance;
    private final boolean onMethod;
    private Class<? extends CustomBackoffStrategy> _value;

    private CustomBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.customBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(CustomBackoff.class);
    }

    public static CustomBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.customBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(CustomBackoff.class, method.method)) {
            return null;
        }
        return new CustomBackoffConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return CustomBackoff.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends CustomBackoffStrategy> value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CustomBackoff.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CustomBackoff.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CustomBackoff.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CustomBackoff.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(CustomBackoff.class, "value");
                oldKey = ConfigUtil.oldKey(CustomBackoff.class, "value");
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }
}

