/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.RetryConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;

public final class RetryConfigImpl
implements RetryConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Retry instance;
    private final boolean onMethod;
    private Integer _maxRetries;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Long _maxDuration;
    private ChronoUnit _durationUnit;
    private Long _jitter;
    private ChronoUnit _jitterDelayUnit;
    private Class<? extends Throwable>[] _retryOn;
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retry;
        this.onMethod = method.annotationsPresentDirectly.contains(Retry.class);
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(Retry.class, method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int maxRetries() {
        if (this._maxRetries == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "maxRetries", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "maxRetries", this.method.declaringClass, this.method.name);
                this._maxRetries = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "maxRetries", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "maxRetries", this.method.declaringClass);
                this._maxRetries = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._maxRetries == null) {
                newKey = ConfigUtil.newKey(Retry.class, "maxRetries");
                oldKey = ConfigUtil.oldKey(Retry.class, "maxRetries");
                this._maxRetries = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._maxRetries == null) {
                this._maxRetries = this.instance.maxRetries();
            }
        }
        return this._maxRetries;
    }

    public long delay() {
        if (this._delay == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "delay", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "delay", this.method.declaringClass, this.method.name);
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "delay", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "delay", this.method.declaringClass);
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._delay == null) {
                newKey = ConfigUtil.newKey(Retry.class, "delay");
                oldKey = ConfigUtil.oldKey(Retry.class, "delay");
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "delayUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "delayUnit", this.method.declaringClass, this.method.name);
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "delayUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "delayUnit", this.method.declaringClass);
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._delayUnit == null) {
                newKey = ConfigUtil.newKey(Retry.class, "delayUnit");
                oldKey = ConfigUtil.oldKey(Retry.class, "delayUnit");
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public long maxDuration() {
        if (this._maxDuration == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "maxDuration", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "maxDuration", this.method.declaringClass, this.method.name);
                this._maxDuration = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "maxDuration", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "maxDuration", this.method.declaringClass);
                this._maxDuration = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDuration == null) {
                newKey = ConfigUtil.newKey(Retry.class, "maxDuration");
                oldKey = ConfigUtil.oldKey(Retry.class, "maxDuration");
                this._maxDuration = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDuration == null) {
                this._maxDuration = this.instance.maxDuration();
            }
        }
        return this._maxDuration;
    }

    public ChronoUnit durationUnit() {
        if (this._durationUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "durationUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "durationUnit", this.method.declaringClass, this.method.name);
                this._durationUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "durationUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "durationUnit", this.method.declaringClass);
                this._durationUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._durationUnit == null) {
                newKey = ConfigUtil.newKey(Retry.class, "durationUnit");
                oldKey = ConfigUtil.oldKey(Retry.class, "durationUnit");
                this._durationUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._durationUnit == null) {
                this._durationUnit = this.instance.durationUnit();
            }
        }
        return this._durationUnit;
    }

    public long jitter() {
        if (this._jitter == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "jitter", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "jitter", this.method.declaringClass, this.method.name);
                this._jitter = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "jitter", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "jitter", this.method.declaringClass);
                this._jitter = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._jitter == null) {
                newKey = ConfigUtil.newKey(Retry.class, "jitter");
                oldKey = ConfigUtil.oldKey(Retry.class, "jitter");
                this._jitter = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._jitter == null) {
                this._jitter = this.instance.jitter();
            }
        }
        return this._jitter;
    }

    public ChronoUnit jitterDelayUnit() {
        if (this._jitterDelayUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "jitterDelayUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "jitterDelayUnit", this.method.declaringClass, this.method.name);
                this._jitterDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "jitterDelayUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "jitterDelayUnit", this.method.declaringClass);
                this._jitterDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                newKey = ConfigUtil.newKey(Retry.class, "jitterDelayUnit");
                oldKey = ConfigUtil.oldKey(Retry.class, "jitterDelayUnit");
                this._jitterDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = this.instance.jitterDelayUnit();
            }
        }
        return this._jitterDelayUnit;
    }

    public Class<? extends Throwable>[] retryOn() {
        if (this._retryOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "retryOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "retryOn", this.method.declaringClass, this.method.name);
                this._retryOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "retryOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "retryOn", this.method.declaringClass);
                this._retryOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._retryOn == null) {
                newKey = ConfigUtil.newKey(Retry.class, "retryOn");
                oldKey = ConfigUtil.oldKey(Retry.class, "retryOn");
                this._retryOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._retryOn == null) {
                this._retryOn = this.instance.retryOn();
            }
        }
        return this._retryOn;
    }

    public Class<? extends Throwable>[] abortOn() {
        if (this._abortOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Retry.class, "abortOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Retry.class, "abortOn", this.method.declaringClass, this.method.name);
                this._abortOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Retry.class, "abortOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Retry.class, "abortOn", this.method.declaringClass);
                this._abortOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._abortOn == null) {
                newKey = ConfigUtil.newKey(Retry.class, "abortOn");
                oldKey = ConfigUtil.oldKey(Retry.class, "abortOn");
                this._abortOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._abortOn == null) {
                this._abortOn = this.instance.abortOn();
            }
        }
        return this._abortOn;
    }

    public void materialize() {
        this.maxRetries();
        this.delay();
        this.delayUnit();
        this.maxDuration();
        this.durationUnit();
        this.jitter();
        this.jitterDelayUnit();
        this.retryOn();
        this.abortOn();
    }
}

