/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(CollectionHelper.getInitialCapacityFromExpectedSize(size));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int size) {
        return new LinkedHashMap(CollectionHelper.getInitialCapacityFromExpectedSize(size));
    }

    public static <T> HashSet<T> newHashSet(int size) {
        return new HashSet(CollectionHelper.getInitialCapacityFromExpectedSize(size));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(int size) {
        return new LinkedHashSet(CollectionHelper.getInitialCapacityFromExpectedSize(size));
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... ts) {
        HashSet set = new HashSet(CollectionHelper.getInitialCapacityFromExpectedSize(ts.length));
        Collections.addAll(set, ts);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asSetIgnoreNull(T ... ts) {
        if (ts.length == 0) {
            return Collections.emptySet();
        }
        if (ts.length == 1) {
            return ts[0] == null ? Collections.emptySet() : Collections.singleton(ts[0]);
        }
        return Arrays.asList(ts).stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Set<T> asLinkedHashSet(T ... ts) {
        LinkedHashSet set = new LinkedHashSet(CollectionHelper.getInitialCapacityFromExpectedSize(ts.length));
        Collections.addAll(set, ts);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asTreeSet(T ... ts) {
        TreeSet set = new TreeSet();
        Collections.addAll(set, ts);
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asImmutableSet(T ... items) {
        switch (items.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(items[0]);
            }
        }
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, items);
        return Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    public static <T> List<T> asList(T firstItem, T ... otherItems) {
        ArrayList<T> list = new ArrayList<T>(otherItems.length + 1);
        list.add(firstItem);
        Collections.addAll(list, otherItems);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> asImmutableList(T ... items) {
        switch (items.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(items[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(items));
    }

    public static <T> List<T> toImmutableList(List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> toImmutableSet(Set<? extends T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> toImmutableMap(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> Set<? extends T> flattenAsSet(Collection<? extends Collection<? extends T>> input) {
        LinkedHashSet<T> flattened = new LinkedHashSet<T>();
        for (Collection<T> collection : input) {
            flattened.addAll(collection);
        }
        return flattened;
    }

    private static int getInitialCapacityFromExpectedSize(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return (int)((float)expectedSize / 0.75f + 1.0f);
    }

    public static <T> boolean isSubset(Set<T> subset, Set<T> superset) {
        if (subset.size() > superset.size()) {
            return false;
        }
        if (subset == superset) {
            return true;
        }
        if (!(subset instanceof SortedSet) || !(superset instanceof SortedSet)) {
            return superset.containsAll(subset);
        }
        Iterator<T> subIterator = subset.iterator();
        Iterator<T> superIterator = superset.iterator();
        Object el = null;
        Object al = null;
        while (subIterator.hasNext()) {
            el = subIterator.next();
            while (superIterator.hasNext() && !el.equals(al = superIterator.next())) {
            }
            if (superIterator.hasNext()) continue;
        }
        return !subIterator.hasNext() && Objects.equals(el, al);
    }

    public static <T> Set<T> notInTheOtherSet(Set<T> subset, Set<T> superset) {
        HashSet<T> difference = new HashSet<T>();
        for (T t : subset) {
            if (superset.contains(t)) continue;
            difference.add(t);
        }
        return difference;
    }
}

