/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeAwareMetric {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int PENDING_FREE = 0;
    private static final int FREE = 1;
    private static final int PENDING_OVER_SIZE = 2;
    private static final int OVER_SIZE = 3;
    private static final int PENDING_OVER_ELEMENTS = 4;
    private static final int OVER_ELEMENTS = 5;
    private static final int NOT_USED = -1;
    private static final AtomicLongFieldUpdater<SizeAwareMetric> elementsUpdater = AtomicLongFieldUpdater.newUpdater(SizeAwareMetric.class, "elements");
    private volatile long elements;
    private static final AtomicLongFieldUpdater<SizeAwareMetric> sizeUpdater = AtomicLongFieldUpdater.newUpdater(SizeAwareMetric.class, "size");
    private volatile long size;
    private static final AtomicIntegerFieldUpdater<SizeAwareMetric> flagUpdater = AtomicIntegerFieldUpdater.newUpdater(SizeAwareMetric.class, "flag");
    private volatile int flag = -1;
    private long maxElements = -1L;
    private long lowerMarkElements;
    private long maxSize = -1L;
    private long lowerMarkSize;
    private AddCallback onSizeCallback;
    private Runnable overCallback;
    private Runnable underCallback;

    public SizeAwareMetric() {
    }

    public SizeAwareMetric(long maxSize, long lowerMarkSize, long maxElements, long lowerMarkElements) {
        if (lowerMarkSize > maxSize) {
            throw new IllegalArgumentException("lowerMark must be <= maxSize");
        }
        if (lowerMarkElements > maxElements) {
            throw new IllegalArgumentException("lowerMarkElements must be <= maxElements");
        }
        this.maxElements = maxElements;
        this.lowerMarkElements = lowerMarkElements;
        this.maxSize = maxSize;
        this.lowerMarkSize = lowerMarkSize;
    }

    public boolean isOver() {
        return this.flag > 1;
    }

    public boolean isOverSize() {
        return this.flag == 3;
    }

    public boolean isOverElements() {
        return this.flag == 5;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isElementsEnabled() {
        return this.maxElements >= 0L;
    }

    public long getElements() {
        return this.elements;
    }

    public boolean isSizeEnabled() {
        return this.maxSize >= 0L;
    }

    public SizeAwareMetric setOnSizeCallback(AddCallback onSize) {
        this.onSizeCallback = onSize;
        return this;
    }

    public SizeAwareMetric setOverCallback(Runnable over) {
        this.overCallback = over;
        return this;
    }

    public SizeAwareMetric setUnderCallback(Runnable under) {
        this.underCallback = under;
        return this;
    }

    protected void over() {
        if (this.overCallback != null) {
            try {
                this.overCallback.run();
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    protected void under() {
        if (this.underCallback != null) {
            try {
                this.underCallback.run();
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    private boolean changeFlag(int expected, int newValue) {
        return flagUpdater.compareAndSet(this, expected, newValue);
    }

    public final long addSize(int delta) {
        return this.addSize(delta, false);
    }

    public final long addSize(int delta, boolean sizeOnly) {
        return this.addSize(delta, sizeOnly, true);
    }

    public final long addSize(int delta, boolean sizeOnly, boolean affectCallbacks) {
        if (delta == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("SizeAwareMetric ignored with size 0", new Exception("trace"));
            }
            return sizeUpdater.get(this);
        }
        this.changeFlag(-1, 1);
        if (this.onSizeCallback != null && affectCallbacks) {
            try {
                this.onSizeCallback.add(delta, sizeOnly);
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
        long currentSize = sizeUpdater.addAndGet(this, delta);
        long currentElements = sizeOnly ? elementsUpdater.get(this) : (delta > 0 ? elementsUpdater.incrementAndGet(this) : elementsUpdater.decrementAndGet(this));
        if (delta > 0) {
            this.checkOver(currentElements, currentSize);
        } else {
            this.checkUnder(currentElements, currentSize);
        }
        return currentSize;
    }

    public void setMax(long maxSize, long lowerMarkSize, long maxElements, long lowerMarkElements) {
        this.maxSize = maxSize;
        this.lowerMarkSize = lowerMarkSize;
        this.maxElements = maxElements;
        this.lowerMarkElements = lowerMarkElements;
        long currentSize = sizeUpdater.get(this);
        long currentElements = elementsUpdater.get(this);
        this.checkOver(currentElements, currentSize);
        this.checkUnder(currentElements, currentSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnder(long currentElements, long currentSize) {
        if (this.isUnderSize(currentSize) && this.changeFlag(3, 0)) {
            if (this.isOverElements(currentElements) && this.changeFlag(0, 5)) {
                logger.debug("Switch from OVER_SIZE to OVER_ELEMENTS [currentSize={}, currentElements={}, lowerMarkSize={}, maxElements={}]", currentSize, currentElements, this.lowerMarkSize, this.maxElements);
                return;
            }
            try {
                logger.debug("UnderSize [currentSize={}, lowerMarkSize={}]", (Object)currentSize, (Object)this.lowerMarkSize);
                this.under();
            }
            finally {
                this.changeFlag(0, 1);
            }
        }
        if (this.isUnderElements(currentElements) && this.changeFlag(5, 0)) {
            if (this.isOverSize(currentSize) && this.changeFlag(0, 3)) {
                logger.debug("Switch from OVER_ELEMENTS to OVER_SIZE [currentElements={}, currentSize={}, lowerMarkElements={}, maxSize={}]", currentElements, currentSize, this.lowerMarkElements, this.maxSize);
                return;
            }
            try {
                logger.debug("UnderElements [currentElements={}, lowerMarkElements={}]", (Object)currentElements, (Object)this.lowerMarkElements);
                this.under();
            }
            finally {
                this.changeFlag(0, 1);
            }
        }
    }

    private boolean isUnderSize(long currentSize) {
        return this.isSizeEnabled() && currentSize < this.lowerMarkSize;
    }

    private boolean isOverSize(long currentSize) {
        return this.isSizeEnabled() && currentSize >= this.maxSize;
    }

    private boolean isUnderElements(long currentElements) {
        return this.isElementsEnabled() && currentElements < this.lowerMarkElements;
    }

    private boolean isOverElements(long currentElements) {
        return this.isElementsEnabled() && currentElements >= 0L && currentElements >= this.maxElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOver(long currentElements, long currentSize) {
        if (this.isOverSize(currentSize) && this.changeFlag(1, 2)) {
            try {
                logger.debug("OverSize [currentSize={}, maxSize={}]", (Object)currentSize, (Object)this.maxSize);
                this.over();
            }
            finally {
                this.changeFlag(2, 3);
            }
        }
        if (this.isOverElements(currentElements) && this.changeFlag(1, 4)) {
            try {
                logger.debug("currentElements [currentSize={}, maxElements={}]", (Object)currentElements, (Object)this.maxElements);
                this.over();
            }
            finally {
                this.changeFlag(4, 5);
            }
        }
    }

    public String toString() {
        return "SizeAwareMetric{elements=" + this.elements + ", size=" + this.size + "}";
    }

    public static interface AddCallback {
        public void add(int var1, boolean var2);
    }
}

