/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BinaryOperator;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMassIndexingLoggingMonitor
implements MassIndexingMonitor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final AtomicReference<StatusMessageInfo> lastMessageInfo = new AtomicReference();
    private final LongAdder totalCounter = new LongAdder();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;

    public PojoMassIndexingLoggingMonitor() {
        this(50);
    }

    public PojoMassIndexingLoggingMonitor(int logAfterNumberOfDocuments) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentsAdded(long increment) {
        if (this.startTime == 0L) {
            PojoMassIndexingLoggingMonitor pojoMassIndexingLoggingMonitor = this;
            synchronized (pojoMassIndexingLoggingMonitor) {
                if (this.startTime == 0L) {
                    long theStartTime = System.nanoTime();
                    this.lastMessageInfo.set(new StatusMessageInfo(this.startTime, 0L));
                    this.startTime = theStartTime;
                }
            }
        }
        long previous = this.documentsDoneCounter.getAndAdd(increment);
        long current = previous + increment;
        int period = this.getStatusMessagePeriod();
        if (previous / (long)period < current / (long)period) {
            long currentTime = System.nanoTime();
            this.printStatusMessage(this.startTime, currentTime, this.totalCounter.longValue(), current);
        }
    }

    @Override
    public void documentsBuilt(long number) {
    }

    @Override
    public void entitiesLoaded(long size) {
    }

    @Override
    public void addToTotalCount(long count) {
        this.totalCounter.add(count);
        log.indexingEntities(count);
    }

    @Override
    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.totalCounter.longValue());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long currentTime, long totalTodoCount, long doneCount) {
        StatusMessageInfo currentStatusMessageInfo = new StatusMessageInfo(currentTime, doneCount);
        StatusMessageInfo previousStatusMessageInfo = this.lastMessageInfo.getAndAccumulate(currentStatusMessageInfo, StatusMessageInfo.UPDATE_IF_MORE_UP_TO_DATE_FUNCTION);
        if (!currentStatusMessageInfo.isMoreUpToDateThan(previousStatusMessageInfo)) {
            return;
        }
        long elapsedNano = currentTime - startTime;
        long intervalBetweenLogsNano = currentStatusMessageInfo.currentTime - previousStatusMessageInfo.currentTime;
        log.indexingProgressRaw(doneCount, TimeUnit.NANOSECONDS.toMillis(elapsedNano));
        float estimateSpeed = (float)doneCount * 1.0E9f / (float)elapsedNano;
        float currentSpeed = (float)(currentStatusMessageInfo.documentsDone - previousStatusMessageInfo.documentsDone) * 1.0E9f / (float)intervalBetweenLogsNano;
        float estimatePercentileComplete = (float)doneCount * 100.0f / (float)totalTodoCount;
        log.indexingProgressStats(currentSpeed, estimateSpeed, estimatePercentileComplete);
    }

    private static class StatusMessageInfo {
        public static final BinaryOperator<StatusMessageInfo> UPDATE_IF_MORE_UP_TO_DATE_FUNCTION = (storedVal, newVal) -> newVal.isMoreUpToDateThan((StatusMessageInfo)storedVal) ? newVal : storedVal;
        public final long currentTime;
        public final long documentsDone;

        public StatusMessageInfo(long currentTime, long documentsDone) {
            this.currentTime = currentTime;
            this.documentsDone = documentsDone;
        }

        public boolean isMoreUpToDateThan(StatusMessageInfo other) {
            return this.documentsDone > other.documentsDone || this.documentsDone == other.documentsDone && this.currentTime > other.currentTime;
        }
    }
}

