/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.management.impl.ManagementRemotingConnection;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager4;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityStoreImpl
implements SecurityStore,
HierarchicalRepositoryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final ActiveMQSecurityManager securityManager;
    private final Cache<String, ConcurrentHashSet<SimpleString>> authorizationCache;
    private final Cache<String, Pair<Boolean, Subject>> authenticationCache;
    private boolean securityEnabled;
    private final String managementClusterUser;
    private final String managementClusterPassword;
    private final NotificationService notificationService;
    private static final AtomicLongFieldUpdater<SecurityStoreImpl> AUTHENTICATION_SUCCESS_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(SecurityStoreImpl.class, "authenticationSuccessCount");
    private volatile long authenticationSuccessCount;
    private static final AtomicLongFieldUpdater<SecurityStoreImpl> AUTHENTICATION_FAILURE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(SecurityStoreImpl.class, "authenticationFailureCount");
    private volatile long authenticationFailureCount;
    private static final AtomicLongFieldUpdater<SecurityStoreImpl> AUTHORIZATION_SUCCESS_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(SecurityStoreImpl.class, "authorizationSuccessCount");
    private volatile long authorizationSuccessCount;
    private static final AtomicLongFieldUpdater<SecurityStoreImpl> AUTHORIZATION_FAILURE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(SecurityStoreImpl.class, "authorizationFailureCount");
    private volatile long authorizationFailureCount;

    public SecurityStoreImpl(HierarchicalRepository<Set<Role>> securityRepository, ActiveMQSecurityManager securityManager, long invalidationInterval, boolean securityEnabled, String managementClusterUser, String managementClusterPassword, NotificationService notificationService, long authenticationCacheSize, long authorizationCacheSize) throws NoSuchAlgorithmException {
        this.securityRepository = securityRepository;
        this.securityManager = securityManager;
        this.securityEnabled = securityEnabled;
        this.managementClusterUser = managementClusterUser;
        this.managementClusterPassword = managementClusterPassword;
        this.notificationService = notificationService;
        if (securityEnabled) {
            if (authenticationCacheSize == 0L) {
                this.authenticationCache = null;
            } else {
                this.authenticationCache = Caffeine.newBuilder().maximumSize(authenticationCacheSize).expireAfterWrite(invalidationInterval, TimeUnit.MILLISECONDS).recordStats().build();
                logger.trace("Created authn cache: {}; maxSize: {}; invalidationInterval: {}", new Object[]{this.authenticationCache, authenticationCacheSize, invalidationInterval});
            }
            if (authorizationCacheSize == 0L) {
                this.authorizationCache = null;
            } else {
                this.authorizationCache = Caffeine.newBuilder().maximumSize(authorizationCacheSize).expireAfterWrite(invalidationInterval, TimeUnit.MILLISECONDS).recordStats().build();
                logger.trace("Created authz cache: {}; maxSize: {}; invalidationInterval: {}", new Object[]{this.authorizationCache, authorizationCacheSize, invalidationInterval});
            }
            this.securityRepository.registerListener(this);
        } else {
            this.authenticationCache = null;
            this.authorizationCache = null;
        }
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    @Override
    public void stop() {
        this.securityRepository.unRegisterListener(this);
    }

    @Override
    public String authenticate(String user, String password, RemotingConnection connection) throws Exception {
        return this.authenticate(user, password, connection, null);
    }

    @Override
    public String authenticate(String user, String password, RemotingConnection connection, String securityDomain) throws Exception {
        if (this.securityEnabled) {
            AccessControlContext accessControlContext;
            if (this.managementClusterUser.equals(user)) {
                logger.trace("Authenticating cluster admin user");
                if (!this.managementClusterPassword.equals(password)) {
                    AUTHENTICATION_FAILURE_COUNT_UPDATER.incrementAndGet(this);
                    throw ActiveMQMessageBundle.BUNDLE.unableToValidateClusterUser(user);
                }
                AUTHENTICATION_SUCCESS_COUNT_UPDATER.incrementAndGet(this);
                return this.managementClusterUser;
            }
            String validatedUser = null;
            boolean userIsValid = false;
            boolean check = true;
            Subject subject = null;
            String authnCacheKey = this.createAuthenticationCacheKey(user, password, connection);
            Pair<Boolean, Subject> cacheEntry = this.getAuthenticationCacheEntry(authnCacheKey);
            if (cacheEntry != null) {
                if (!((Boolean)cacheEntry.getA()).booleanValue()) {
                    check = false;
                } else {
                    check = false;
                    userIsValid = true;
                    subject = (Subject)cacheEntry.getB();
                    validatedUser = this.getUserFromSubject(subject);
                }
            } else if (user == null && password == null && connection instanceof ManagementRemotingConnection && (accessControlContext = AccessController.getContext()) != null) {
                check = false;
                userIsValid = true;
                subject = Subject.getSubject(accessControlContext);
                validatedUser = this.getUserFromSubject(subject);
            }
            if (check) {
                if (this.securityManager instanceof ActiveMQSecurityManager5) {
                    try {
                        subject = ((ActiveMQSecurityManager5)this.securityManager).authenticate(user, password, connection, securityDomain);
                        this.putAuthenticationCacheEntry(authnCacheKey, subject);
                        validatedUser = this.getUserFromSubject(subject);
                    }
                    catch (NoCacheLoginException e) {
                        this.handleNoCacheLoginException(e);
                    }
                } else if (this.securityManager instanceof ActiveMQSecurityManager4) {
                    validatedUser = ((ActiveMQSecurityManager4)this.securityManager).validateUser(user, password, connection, securityDomain);
                } else if (this.securityManager instanceof ActiveMQSecurityManager3) {
                    validatedUser = ((ActiveMQSecurityManager3)this.securityManager).validateUser(user, password, connection);
                } else {
                    userIsValid = this.securityManager instanceof ActiveMQSecurityManager2 ? ((ActiveMQSecurityManager2)this.securityManager).validateUser(user, password, CertificateUtil.getCertsFromConnection((RemotingConnection)connection)) : this.securityManager.validateUser(user, password);
                }
            }
            if (!userIsValid && validatedUser == null) {
                this.authenticationFailed(user, connection);
            }
            if (connection != null) {
                connection.setSubject(subject);
            }
            if (AuditLogger.isResourceLoggingEnabled()) {
                if (connection != null) {
                    AuditLogger.userSuccesfullyAuthenticatedInAudit((Subject)subject, (String)connection.getRemoteAddress(), (String)connection.getID().toString());
                } else {
                    AuditLogger.userSuccesfullyAuthenticatedInAudit((Subject)subject, null, null);
                }
            }
            AUTHENTICATION_SUCCESS_COUNT_UPDATER.incrementAndGet(this);
            return validatedUser;
        }
        return null;
    }

    @Override
    public void check(SimpleString address, CheckType checkType, SecurityAuth session) throws Exception {
        this.check(address, null, checkType, session);
    }

    @Override
    public void check(SimpleString address, SimpleString queue, CheckType checkType, SecurityAuth session) throws Exception {
        if (this.securityEnabled) {
            ConcurrentHashSet set;
            Boolean validated;
            SimpleString bareAddress = CompositeAddress.extractAddressName((SimpleString)address);
            SimpleString bareQueue = CompositeAddress.extractQueueName((SimpleString)queue);
            logger.trace("checking access permissions to {}", (Object)bareAddress);
            String user = session.getUsername();
            if (this.managementClusterUser.equals(user) && session.getPassword().equals(this.managementClusterPassword)) {
                AUTHORIZATION_SUCCESS_COUNT_UPDATER.incrementAndGet(this);
                return;
            }
            Set<Role> roles = this.securityRepository.getMatch(bareAddress.toString());
            SimpleString fqqn = null;
            if (bareQueue != null && this.securityRepository.containsExactMatch((fqqn = CompositeAddress.toFullyQualified((SimpleString)bareAddress, (SimpleString)bareQueue)).toString())) {
                roles = this.securityRepository.getMatch(fqqn.toString());
            }
            if (this.checkAuthorizationCache(fqqn != null ? fqqn : bareAddress, user, checkType)) {
                AUTHORIZATION_SUCCESS_COUNT_UPDATER.incrementAndGet(this);
                return;
            }
            if (this.securityManager instanceof ActiveMQSecurityManager5) {
                Subject subject = this.getSubjectForAuthorization(session, (ActiveMQSecurityManager5)this.securityManager);
                if (subject == null) {
                    this.authenticationFailed(user, session.getRemotingConnection());
                }
                validated = ((ActiveMQSecurityManager5)this.securityManager).authorize(subject, roles, checkType, fqqn != null ? fqqn.toString() : bareAddress.toString());
            } else {
                validated = this.securityManager instanceof ActiveMQSecurityManager4 ? Boolean.valueOf(((ActiveMQSecurityManager4)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection(), session.getSecurityDomain()) != null) : (this.securityManager instanceof ActiveMQSecurityManager3 ? Boolean.valueOf(((ActiveMQSecurityManager3)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection()) != null) : (this.securityManager instanceof ActiveMQSecurityManager2 ? Boolean.valueOf(((ActiveMQSecurityManager2)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection())) : Boolean.valueOf(this.securityManager.validateUserAndRole(user, session.getPassword(), roles, checkType))));
            }
            if (!validated.booleanValue()) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, bareAddress);
                    props.putSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE, SimpleString.of((String)checkType.toString()));
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.of((String)this.getCaller(user, session.getRemotingConnection().getSubject())));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_PERMISSION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                ActiveMQSecurityException ex = bareQueue == null ? ActiveMQMessageBundle.BUNDLE.userNoPermissions(this.getCaller(user, session.getRemotingConnection().getSubject()), checkType, bareAddress) : ActiveMQMessageBundle.BUNDLE.userNoPermissionsQueue(this.getCaller(user, session.getRemotingConnection().getSubject()), checkType, bareQueue, bareAddress);
                AuditLogger.securityFailure((Subject)session.getRemotingConnection().getSubject(), (String)session.getRemotingConnection().getRemoteAddress(), (String)ex.getMessage(), (Exception)((Object)ex));
                AUTHORIZATION_FAILURE_COUNT_UPDATER.incrementAndGet(this);
                throw ex;
            }
            AUTHORIZATION_SUCCESS_COUNT_UPDATER.incrementAndGet(this);
            if (user == null) {
                return;
            }
            String key = this.createAuthorizationCacheKey(user, checkType);
            ConcurrentHashSet act = this.getAuthorizationCacheEntry(key);
            if (act != null) {
                set = act;
            } else {
                set = new ConcurrentHashSet();
                this.putAuthorizationCacheEntry((ConcurrentHashSet<SimpleString>)set, key);
            }
            set.add((Object)(fqqn != null ? fqqn : bareAddress));
        }
    }

    @Override
    public void onChange() {
        this.invalidateAuthorizationCache();
    }

    public String getUserFromSubject(Subject subject) {
        return this.securityManager.getUserFromSubject(subject);
    }

    public String getCaller(String user, Subject subject) {
        if (user != null) {
            return user;
        }
        return this.getUserFromSubject(subject);
    }

    @Override
    public Subject getSessionSubject(SecurityAuth session) {
        if (this.securityManager instanceof ActiveMQSecurityManager5) {
            return this.getSubjectForAuthorization(session, (ActiveMQSecurityManager5)this.securityManager);
        }
        return null;
    }

    private void authenticationFailed(String user, RemotingConnection connection) throws Exception {
        String certSubjectDN = CertificateUtil.getCertSubjectDN((RemotingConnection)connection);
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.of((String)user));
            props.putSimpleStringProperty(ManagementHelper.HDR_CERT_SUBJECT_DN, SimpleString.of((String)certSubjectDN));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.of((String)(connection == null ? "null" : connection.getRemoteAddress())));
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION, props);
            this.notificationService.sendNotification(notification);
        }
        ActiveMQSecurityException e = ActiveMQMessageBundle.BUNDLE.unableToValidateUser(connection == null ? "null" : connection.getRemoteAddress(), user, certSubjectDN);
        ActiveMQServerLogger.LOGGER.securityProblemWhileAuthenticating(e.getMessage());
        if (AuditLogger.isResourceLoggingEnabled()) {
            AuditLogger.userFailedAuthenticationInAudit(null, (String)e.getMessage(), (String)(connection == null ? "null" : connection.getID().toString()));
        }
        AUTHENTICATION_FAILURE_COUNT_UPDATER.incrementAndGet(this);
        throw e;
    }

    private Subject getSubjectForAuthorization(SecurityAuth auth, ActiveMQSecurityManager5 securityManager) {
        AccessControlContext accessControlContext;
        String authnCacheKey = this.createAuthenticationCacheKey(auth.getUsername(), auth.getPassword(), auth.getRemotingConnection());
        Pair cached = this.getAuthenticationCacheEntry(authnCacheKey);
        if (cached == null && auth.getUsername() == null && auth.getPassword() == null && auth.getRemotingConnection() instanceof ManagementRemotingConnection && (accessControlContext = AccessController.getContext()) != null) {
            cached = new Pair((Object)true, (Object)Subject.getSubject(accessControlContext));
        }
        if (cached == null) {
            try {
                Subject subject = securityManager.authenticate(auth.getUsername(), auth.getPassword(), auth.getRemotingConnection(), auth.getSecurityDomain());
                this.putAuthenticationCacheEntry(authnCacheKey, subject);
                return subject;
            }
            catch (NoCacheLoginException e) {
                this.handleNoCacheLoginException(e);
                return null;
            }
        }
        return (Subject)cached.getB();
    }

    private void handleNoCacheLoginException(NoCacheLoginException e) {
        logger.debug("Skipping authentication cache due to exception: {}", (Object)e.getMessage());
    }

    private void putAuthenticationCacheEntry(String key, Subject subject) {
        if (this.authenticationCache != null) {
            Pair value = new Pair((Object)(subject != null ? 1 : 0), (Object)subject);
            this.authenticationCache.put((Object)key, (Object)value);
            logger.trace("Put into authn cache; key: {}; value: {}", (Object)key, (Object)value);
        }
    }

    private Pair<Boolean, Subject> getAuthenticationCacheEntry(String key) {
        if (this.authenticationCache == null) {
            return null;
        }
        Pair value = (Pair)this.authenticationCache.getIfPresent((Object)key);
        logger.trace("Get from authn cache; key: {}; value: {}", (Object)key, (Object)value);
        return value;
    }

    private void putAuthorizationCacheEntry(ConcurrentHashSet<SimpleString> value, String key) {
        if (this.authorizationCache != null) {
            this.authorizationCache.put((Object)key, value);
            logger.trace("Put into authz cache; key: {}; value: {}", (Object)key, value);
        }
    }

    private ConcurrentHashSet<SimpleString> getAuthorizationCacheEntry(String key) {
        if (this.authorizationCache == null) {
            return null;
        }
        ConcurrentHashSet value = (ConcurrentHashSet)this.authorizationCache.getIfPresent((Object)key);
        logger.trace("Get from authz cache; key: {}; value: {}", (Object)key, (Object)value);
        return value;
    }

    public void invalidateAuthorizationCache() {
        if (this.authorizationCache != null) {
            this.authorizationCache.invalidateAll();
            logger.trace("Invalidated authz cache");
        }
    }

    public void invalidateAuthenticationCache() {
        if (this.authenticationCache != null) {
            this.authenticationCache.invalidateAll();
            logger.trace("Invalidated authn cache");
        }
    }

    public long getAuthenticationCacheSize() {
        if (this.authenticationCache == null) {
            return 0L;
        }
        return this.authenticationCache.estimatedSize();
    }

    public long getAuthorizationCacheSize() {
        if (this.authorizationCache == null) {
            return 0L;
        }
        return this.authorizationCache.estimatedSize();
    }

    private boolean checkAuthorizationCache(SimpleString dest, String user, CheckType checkType) {
        boolean granted = false;
        ConcurrentHashSet<SimpleString> act = this.getAuthorizationCacheEntry(this.createAuthorizationCacheKey(user, checkType));
        if (act != null) {
            granted = act.contains((Object)dest);
        }
        return granted;
    }

    private String createAuthenticationCacheKey(String username, String password, RemotingConnection connection) {
        try {
            return ByteUtil.bytesToHex((byte[])MessageDigest.getInstance("SHA-256").digest((username + password + CertificateUtil.getCertSubjectDN((RemotingConnection)connection)).getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String createAuthorizationCacheKey(String user, CheckType checkType) {
        return user + "." + checkType.name();
    }

    public Cache<String, Pair<Boolean, Subject>> getAuthenticationCache() {
        return this.authenticationCache;
    }

    public Cache<String, ConcurrentHashSet<SimpleString>> getAuthorizationCache() {
        return this.authorizationCache;
    }

    @Override
    public long getAuthenticationSuccessCount() {
        return this.authenticationSuccessCount;
    }

    @Override
    public long getAuthenticationFailureCount() {
        return this.authenticationFailureCount;
    }

    @Override
    public long getAuthorizationSuccessCount() {
        return this.authorizationSuccessCount;
    }

    @Override
    public long getAuthorizationFailureCount() {
        return this.authorizationFailureCount;
    }
}

