/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.protonj2.test.driver.ProtonTestClient;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPProtocolErrorHandlingTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=30L)
    public void testBrokerHandlesOutOfOrderDeliveryIdInTransfer() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient receivingPeer = new ProtonTestClient();){
            receivingPeer.queueClientSaslAnonymousConnect();
            receivingPeer.connect("localhost", 5672);
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            receivingPeer.expectOpen();
            receivingPeer.expectBegin();
            receivingPeer.expectAttach().ofSender();
            receivingPeer.expectAttach().ofReceiver();
            receivingPeer.expectFlow();
            receivingPeer.remoteOpen().withContainerId("test-sender").now();
            receivingPeer.remoteBegin().withNextOutgoingId(100).now();
            receivingPeer.remoteAttach().ofReceiver().withName("transfer-test").withSource().withAddress("test").withCapabilities(new String[]{"queue"}).also().withTarget().and().now();
            receivingPeer.remoteFlow().withLinkCredit(10L).now();
            receivingPeer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName("transfer-test").withTarget().withAddress("test").withCapabilities(new String[]{"queue"}).also().withSource().and().now();
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists(), (long)5000L, (long)100L);
            Wait.assertEquals((int)1, () -> this.server.locateQueue(SimpleString.of((String)"test")).getConsumerCount(), (long)5000L, (long)100L);
            receivingPeer.expectTransfer();
            receivingPeer.expectDisposition().withSettled(true).withState().accepted();
            receivingPeer.remoteTransfer().withDeliveryId(100).withBody().withValue("test").also().withMessageAnnotations().withAnnotation("x-opt-jms-dest", (Object)0).also().now();
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            receivingPeer.expectClose().withError(AmqpError.INTERNAL_ERROR.toString()).respond();
            logger.info("Sent transfer with delivery ID:100, now sending incorrect delivery ID:99");
            Wait.assertEquals((int)1, () -> this.server.locateQueue(SimpleString.of((String)"test")).getDeliveringCount(), (long)5000L, (long)100L);
            receivingPeer.remoteTransfer().withDeliveryId(99).withBody().withValue("test").also().withMessageAnnotations().withAnnotation("x-opt-jms-dest", (Object)0).also().now();
            Wait.assertEquals((int)0, () -> this.server.locateQueue(SimpleString.of((String)"test")).getConsumerCount(), (long)5000L, (long)100L);
            Wait.assertEquals((int)0, () -> this.server.locateQueue(SimpleString.of((String)"test")).getDeliveringCount(), (long)5000L, (long)100L);
            receivingPeer.waitForScriptToComplete();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testBrokerHandlesNewTransferSentBeforeLastTransferCompleted() throws Exception {
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.ANYCAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
        try (ProtonTestClient receivingPeer = new ProtonTestClient();){
            receivingPeer.queueClientSaslAnonymousConnect();
            receivingPeer.connect("localhost", 5672);
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            receivingPeer.expectOpen();
            receivingPeer.expectBegin();
            receivingPeer.expectAttach().ofSender();
            receivingPeer.expectAttach().ofReceiver();
            receivingPeer.expectFlow();
            receivingPeer.remoteOpen().withContainerId("test-sender").now();
            receivingPeer.remoteBegin().withNextOutgoingId(100).now();
            receivingPeer.remoteAttach().ofReceiver().withName("transfer-test").withSource().withAddress("test").withCapabilities(new String[]{"queue"}).also().withTarget().and().now();
            receivingPeer.remoteFlow().withLinkCredit(10L).now();
            receivingPeer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName("transfer-test").withTarget().withAddress("test").withCapabilities(new String[]{"queue"}).also().withSource().and().now();
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists(), (long)5000L, (long)100L);
            Wait.assertEquals((int)1, () -> this.server.locateQueue(SimpleString.of((String)"test")).getConsumerCount(), (long)5000L, (long)100L);
            receivingPeer.remoteTransfer().withDeliveryId(100).withBody().withValue("test").also().withMessageAnnotations().withAnnotation("x-opt-jms-dest", (Object)0).also().withMore(true).now();
            receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            receivingPeer.expectClose().withError(AmqpError.INTERNAL_ERROR.toString()).respond();
            logger.info("Sent transfer with delivery ID:100, now sending incorrect delivery ID:101");
            receivingPeer.remoteTransfer().withDeliveryId(101).withBody().withValue("test").also().withMessageAnnotations().withAnnotation("x-opt-jms-dest", (Object)0).also().now();
            Wait.assertEquals((int)0, () -> this.server.locateQueue(SimpleString.of((String)"test")).getConsumerCount(), (long)5000L, (long)100L);
            Wait.assertEquals((int)0, () -> this.server.locateQueue(SimpleString.of((String)"test")).getDeliveringCount(), (long)5000L, (long)100L);
            receivingPeer.waitForScriptToComplete();
        }
    }
}

