/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PagedMirrorTest
extends ActiveMQTestBase {
    ActiveMQServer server1;
    ActiveMQServer server2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server1 = this.createServer(true, this.createDefaultConfig(0, true), 1024, 10240L, -1, -1);
        this.server1.getConfiguration().getAcceptorConfigurations().clear();
        this.server1.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61616");
        AMQPBrokerConnectConfiguration brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61617").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(false));
        this.server1.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server2 = this.createServer(true, this.createDefaultConfig(1, true), 1024, 10240L, -1, -1);
        this.server2.getConfiguration().getAcceptorConfigurations().clear();
        this.server2.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61617");
        brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61616").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(false));
        this.server2.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server1.start();
        this.server2.start();
    }

    @Test
    public void testPaged() throws Throwable {
        TextMessage message;
        int i;
        jakarta.jms.Queue jmsQueue;
        String sendURI = "tcp://localhost:61616";
        String consumeURI = "tcp://localhost:61616";
        String secondConsumeURI = "tcp://localhost:61617";
        Wait.waitFor(() -> this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Wait.waitFor(() -> this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other") != null);
        Queue snf1 = this.server2.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assertions.assertNotNull((Object)snf1);
        Queue snf2 = this.server1.locateQueue("$ACTIVEMQ_ARTEMIS_MIRROR_other");
        Assertions.assertNotNull((Object)snf2);
        File countJournalLocation = this.server2.getConfiguration().getJournalLocation();
        Assertions.assertTrue((countJournalLocation.exists() && countJournalLocation.isDirectory() ? 1 : 0) != 0);
        String protocol = "amqp";
        ConnectionFactory sendCF = CFUtil.createConnectionFactory(protocol, sendURI);
        ConnectionFactory consumeCF = CFUtil.createConnectionFactory(protocol, consumeURI);
        ConnectionFactory secondConsumeCF = CFUtil.createConnectionFactory(protocol, secondConsumeURI);
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < 1024; ++i2) {
            buffer.append("*");
        }
        String bodyBuffer = buffer.toString();
        int NUMBER_OF_MESSAGES = 200;
        int ACK_I = 77;
        try (Connection sendConnecton = sendCF.createConnection();){
            Session sendSession = sendConnecton.createSession(true, 0);
            jmsQueue = sendSession.createQueue("someQueue");
            MessageProducer producer = sendSession.createProducer((Destination)jmsQueue);
            for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                message = sendSession.createTextMessage(bodyBuffer);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            sendSession.commit();
        }
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        try (Connection consumeConnection = consumeCF.createConnection();){
            Session consumeSession = consumeConnection.createSession(false, 101);
            jmsQueue = consumeSession.createQueue("someQueue");
            MessageConsumer consumer = consumeSession.createConsumer((Destination)jmsQueue);
            consumeConnection.start();
            for (i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                message = (TextMessage)consumer.receive(6000L);
                if (message.getIntProperty("i") != ACK_I) continue;
                message.acknowledge();
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        Queue queueServer1 = this.server1.locateQueue("someQueue");
        Queue queueServer2 = this.server1.locateQueue("someQueue");
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES - 1), () -> ((Queue)queueServer2).getMessageCount(), (long)5000L);
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES - 1), () -> ((Queue)queueServer1).getMessageCount(), (long)5000L);
        Wait.assertEquals((int)1, () -> this.acksCount(countJournalLocation), (long)5000L, (long)1000L);
        HashSet<Integer> receivedIDs = new HashSet<Integer>();
        try (Connection consumeConnection = secondConsumeCF.createConnection();){
            int i3;
            Session consumeSession = consumeConnection.createSession(true, 0);
            jakarta.jms.Queue jmsQueue2 = consumeSession.createQueue("someQueue");
            MessageConsumer consumer = consumeSession.createConsumer((Destination)jmsQueue2);
            consumeConnection.start();
            for (i3 = 0; i3 < NUMBER_OF_MESSAGES - 1; ++i3) {
                TextMessage message2 = (TextMessage)consumer.receive(6000L);
                Assertions.assertNotNull((Object)message2);
                Assertions.assertNotEquals((int)ACK_I, (int)message2.getIntProperty("i"));
                receivedIDs.add(message2.getIntProperty("i"));
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
            Assertions.assertEquals((int)(NUMBER_OF_MESSAGES - 1), (int)receivedIDs.size());
            for (i3 = 0; i3 < NUMBER_OF_MESSAGES; ++i3) {
                if (i3 == ACK_I) continue;
                Assertions.assertTrue((boolean)receivedIDs.contains(i3));
            }
        }
    }

    private int acksCount(File countJournalLocation) throws Exception {
        HashMap<Integer, AtomicInteger> countJournal = this.countJournal(countJournalLocation, 0xA00000, 2, 2);
        AtomicInteger acksCount = countJournal.get(39);
        return acksCount != null ? acksCount.get() : 0;
    }
}

