/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AddressPauseTest
extends JMSTestBase {
    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Test
    public void testPauseAddress() throws Exception {
        try (Connection connection = this.cf.createConnection();){
            connection.setClientID("myClientID");
            connection.start();
            try (Session session = connection.createSession(true, 1);){
                TextMessage m;
                int i;
                int i2;
                Topic topic = session.createTopic("jms.topic.MyTopic");
                TopicSubscriber subscriber1 = session.createDurableSubscriber(topic, "my-subscription1");
                AddressControl addressControl = (AddressControl)this.server.getManagementService().getResource("address.jms.topic.MyTopic");
                MessageProducer producer = session.createProducer((Destination)topic);
                int numMessages = 100;
                for (i2 = 0; i2 < 100; ++i2) {
                    TextMessage mess = session.createTextMessage("msg" + i2);
                    producer.send((Message)mess);
                }
                session.commit();
                for (i2 = 0; i2 < 100; ++i2) {
                    TextMessage m2 = (TextMessage)subscriber1.receive(5000L);
                    Assertions.assertNotNull((Object)m2);
                }
                session.commit();
                addressControl.pause();
                Assertions.assertTrue((boolean)addressControl.isPaused());
                TopicSubscriber subscriber2 = session.createDurableSubscriber(topic, "my-subscription2");
                for (int i3 = 0; i3 < 100; ++i3) {
                    TextMessage mess = session.createTextMessage("msg" + i3);
                    producer.send((Message)mess);
                }
                session.commit();
                TextMessage message = (TextMessage)subscriber1.receiveNoWait();
                Assertions.assertNull((Object)message);
                message = (TextMessage)subscriber2.receiveNoWait();
                Assertions.assertNull((Object)message);
                addressControl.resume();
                for (i = 0; i < 100; ++i) {
                    m = (TextMessage)subscriber1.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                }
                session.commit();
                for (i = 0; i < 100; ++i) {
                    m = (TextMessage)subscriber2.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                }
                session.commit();
            }
        }
    }

    @Test
    public void testPauseAddressServerRestart() throws Exception {
        MessageProducer producer;
        AddressControl addressControl;
        TopicSubscriber subscriber1;
        Topic topic;
        Session session;
        int numMessages = 100;
        try (Connection connection = this.cf.createConnection();){
            connection.setClientID("myClientID");
            connection.start();
            session = connection.createSession(true, 1);
            try {
                int i;
                topic = session.createTopic("jms.topic.MyTopic");
                subscriber1 = session.createDurableSubscriber(topic, "my-subscription1");
                addressControl = (AddressControl)this.server.getManagementService().getResource("address.jms.topic.MyTopic");
                producer = session.createProducer((Destination)topic);
                for (i = 0; i < 100; ++i) {
                    TextMessage mess = session.createTextMessage("msg" + i);
                    producer.send((Message)mess);
                }
                session.commit();
                for (i = 0; i < 100; ++i) {
                    TextMessage m = (TextMessage)subscriber1.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                }
                session.commit();
                addressControl.pause(true);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        this.server.stop();
        this.server.start();
        connection = this.cf.createConnection();
        try {
            connection.setClientID("myClientID");
            connection.start();
            session = connection.createSession(true, 1);
            try {
                TextMessage m;
                int i;
                topic = session.createTopic("jms.topic.MyTopic");
                subscriber1 = session.createDurableSubscriber(topic, "my-subscription1");
                addressControl = (AddressControl)this.server.getManagementService().getResource("address.jms.topic.MyTopic");
                producer = session.createProducer((Destination)topic);
                Assertions.assertTrue((boolean)addressControl.isPaused());
                TopicSubscriber subscriber2 = session.createDurableSubscriber(topic, "my-subscription2");
                for (int i2 = 0; i2 < 100; ++i2) {
                    TextMessage mess = session.createTextMessage("msg" + i2);
                    producer.send((Message)mess);
                }
                session.commit();
                TextMessage message = (TextMessage)subscriber1.receiveNoWait();
                Assertions.assertNull((Object)message);
                message = (TextMessage)subscriber2.receiveNoWait();
                Assertions.assertNull((Object)message);
                addressControl.resume();
                for (i = 0; i < 100; ++i) {
                    m = (TextMessage)subscriber1.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                }
                session.commit();
                for (i = 0; i < 100; ++i) {
                    m = (TextMessage)subscriber2.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                }
                session.commit();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

