/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionFactoryTest
extends ActiveMQTestBase {
    private final DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(SessionFactoryTest.getUDPDiscoveryAddress()).setGroupPort(SessionFactoryTest.getUDPDiscoveryPort()));
    private ActiveMQServer liveService;
    private TransportConfiguration liveTC;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    @Test
    public void testCloseUnusedClientSessionFactoryWithoutGlobalPools() throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        ClientSessionFactory csf = this.createSessionFactory(locator);
        csf.close();
    }

    @Test
    public void testDiscoveryConstructor() throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)this.groupConfiguration);
        this.assertFactoryParams(locator, null, this.groupConfiguration, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        Assertions.assertNotNull((Object)session);
        session.close();
        this.testSettersThrowException(cf);
        cf.close();
        locator.close();
    }

    @Test
    public void testStaticConnectorListConstructor() throws Exception {
        TransportConfiguration[] tc = new TransportConfiguration[]{this.liveTC};
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tc);
        this.assertFactoryParams(locator, tc, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        Assertions.assertNotNull((Object)session);
        session.close();
        this.testSettersThrowException(cf);
        cf.close();
    }

    @Test
    public void testGettersAndSetters() throws Exception {
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int ackBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        TransportConfiguration[] tc = new TransportConfiguration[]{this.liveTC};
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tc).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setCallTimeout(callTimeout).setMinLargeMessageSize(minLargeMessageSize).setConsumerWindowSize(consumerWindowSize).setConsumerMaxRate(consumerMaxRate).setConfirmationWindowSize(confirmationWindowSize).setProducerMaxRate(producerMaxRate).setBlockOnAcknowledge(blockOnAcknowledge).setBlockOnDurableSend(blockOnDurableSend).setBlockOnNonDurableSend(blockOnNonDurableSend).setAutoGroup(autoGroup).setPreAcknowledge(preAcknowledge).setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName).setAckBatchSize(ackBatchSize).setUseGlobalPools(useGlobalPools).setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize).setThreadPoolMaxSize(threadPoolMaxSize).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setReconnectAttempts(reconnectAttempts);
        SessionFactoryTest.assertEqualsTransportConfigurations(tc, locator.getStaticTransportConfigurations());
        Assertions.assertEquals((long)clientFailureCheckPeriod, (long)locator.getClientFailureCheckPeriod());
        Assertions.assertEquals((long)connectionTTL, (long)locator.getConnectionTTL());
        Assertions.assertEquals((long)callTimeout, (long)locator.getCallTimeout());
        Assertions.assertEquals((int)minLargeMessageSize, (int)locator.getMinLargeMessageSize());
        Assertions.assertEquals((int)consumerWindowSize, (int)locator.getConsumerWindowSize());
        Assertions.assertEquals((int)consumerMaxRate, (int)locator.getConsumerMaxRate());
        Assertions.assertEquals((int)confirmationWindowSize, (int)locator.getConfirmationWindowSize());
        Assertions.assertEquals((int)producerMaxRate, (int)locator.getProducerMaxRate());
        Assertions.assertEquals((Object)blockOnAcknowledge, (Object)locator.isBlockOnAcknowledge());
        Assertions.assertEquals((Object)blockOnDurableSend, (Object)locator.isBlockOnDurableSend());
        Assertions.assertEquals((Object)blockOnNonDurableSend, (Object)locator.isBlockOnNonDurableSend());
        Assertions.assertEquals((Object)autoGroup, (Object)locator.isAutoGroup());
        Assertions.assertEquals((Object)preAcknowledge, (Object)locator.isPreAcknowledge());
        Assertions.assertEquals((Object)loadBalancingPolicyClassName, (Object)locator.getConnectionLoadBalancingPolicyClassName());
        Assertions.assertEquals((int)ackBatchSize, (int)locator.getAckBatchSize());
        Assertions.assertEquals((Object)useGlobalPools, (Object)locator.isUseGlobalPools());
        Assertions.assertEquals((int)scheduledThreadPoolMaxSize, (int)locator.getScheduledThreadPoolMaxSize());
        Assertions.assertEquals((int)threadPoolMaxSize, (int)locator.getThreadPoolMaxSize());
        Assertions.assertEquals((long)retryInterval, (long)locator.getRetryInterval());
        Assertions.assertEquals((double)retryIntervalMultiplier, (double)locator.getRetryIntervalMultiplier(), (double)1.0E-6);
        Assertions.assertEquals((int)reconnectAttempts, (int)locator.getReconnectAttempts());
    }

    private void testSettersThrowException(ClientSessionFactory cf) {
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int ackBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        try {
            cf.getServerLocator().setClientFailureCheckPeriod(clientFailureCheckPeriod);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConnectionTTL(connectionTTL);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setCallTimeout(callTimeout);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setMinLargeMessageSize(minLargeMessageSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConsumerWindowSize(consumerWindowSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConsumerMaxRate(consumerMaxRate);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConfirmationWindowSize(confirmationWindowSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setProducerMaxRate(producerMaxRate);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnAcknowledge(blockOnAcknowledge);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnDurableSend(blockOnDurableSend);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnNonDurableSend(blockOnNonDurableSend);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setAutoGroup(autoGroup);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setPreAcknowledge(preAcknowledge);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setAckBatchSize(ackBatchSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setUseGlobalPools(useGlobalPools);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setThreadPoolMaxSize(threadPoolMaxSize);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setRetryInterval(retryInterval);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setRetryIntervalMultiplier(retryIntervalMultiplier);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setReconnectAttempts(reconnectAttempts);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        cf.getServerLocator().getStaticTransportConfigurations();
        cf.getServerLocator().getClientFailureCheckPeriod();
        cf.getServerLocator().getConnectionTTL();
        cf.getServerLocator().getCallTimeout();
        cf.getServerLocator().getMinLargeMessageSize();
        cf.getServerLocator().getConsumerWindowSize();
        cf.getServerLocator().getConsumerMaxRate();
        cf.getServerLocator().getConfirmationWindowSize();
        cf.getServerLocator().getProducerMaxRate();
        cf.getServerLocator().isBlockOnAcknowledge();
        cf.getServerLocator().isBlockOnDurableSend();
        cf.getServerLocator().isBlockOnNonDurableSend();
        cf.getServerLocator().isAutoGroup();
        cf.getServerLocator().isPreAcknowledge();
        cf.getServerLocator().getConnectionLoadBalancingPolicyClassName();
        cf.getServerLocator().getAckBatchSize();
        cf.getServerLocator().isUseGlobalPools();
        cf.getServerLocator().getScheduledThreadPoolMaxSize();
        cf.getServerLocator().getThreadPoolMaxSize();
        cf.getServerLocator().getRetryInterval();
        cf.getServerLocator().getRetryIntervalMultiplier();
        cf.getServerLocator().getReconnectAttempts();
    }

    private void assertFactoryParams(ServerLocator locator, TransportConfiguration[] staticConnectors, DiscoveryGroupConfiguration discoveryGroupConfiguration, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int ackBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts) {
        if (staticConnectors == null) {
            Assertions.assertTrue((boolean)Arrays.equals(new String[0], locator.getStaticTransportConfigurations()), (String)"no static connectors");
        } else {
            SessionFactoryTest.assertEqualsTransportConfigurations(staticConnectors, locator.getStaticTransportConfigurations());
        }
        Assertions.assertEquals((Object)locator.getDiscoveryGroupConfiguration(), (Object)discoveryGroupConfiguration);
        Assertions.assertEquals((long)locator.getClientFailureCheckPeriod(), (long)clientFailureCheckPeriod);
        Assertions.assertEquals((long)locator.getConnectionTTL(), (long)connectionTTL);
        Assertions.assertEquals((long)locator.getCallTimeout(), (long)callTimeout);
        Assertions.assertEquals((int)locator.getMinLargeMessageSize(), (int)minLargeMessageSize);
        Assertions.assertEquals((int)locator.getConsumerWindowSize(), (int)consumerWindowSize);
        Assertions.assertEquals((int)locator.getConsumerMaxRate(), (int)consumerMaxRate);
        Assertions.assertEquals((int)locator.getConfirmationWindowSize(), (int)confirmationWindowSize);
        Assertions.assertEquals((int)locator.getProducerMaxRate(), (int)producerMaxRate);
        Assertions.assertEquals((Object)locator.isBlockOnAcknowledge(), (Object)blockOnAcknowledge);
        Assertions.assertEquals((Object)locator.isBlockOnDurableSend(), (Object)blockOnDurableSend);
        Assertions.assertEquals((Object)locator.isBlockOnNonDurableSend(), (Object)blockOnNonDurableSend);
        Assertions.assertEquals((Object)locator.isAutoGroup(), (Object)autoGroup);
        Assertions.assertEquals((Object)locator.isPreAcknowledge(), (Object)preAcknowledge);
        Assertions.assertEquals((Object)locator.getConnectionLoadBalancingPolicyClassName(), (Object)loadBalancingPolicyClassName);
        Assertions.assertEquals((int)locator.getAckBatchSize(), (int)ackBatchSize);
        Assertions.assertEquals((Object)locator.isUseGlobalPools(), (Object)useGlobalPools);
        Assertions.assertEquals((int)locator.getScheduledThreadPoolMaxSize(), (int)scheduledThreadPoolMaxSize);
        Assertions.assertEquals((int)locator.getThreadPoolMaxSize(), (int)threadPoolMaxSize);
        Assertions.assertEquals((long)locator.getRetryInterval(), (long)retryInterval);
        Assertions.assertEquals((double)locator.getRetryIntervalMultiplier(), (double)retryIntervalMultiplier, (double)1.0E-6);
        Assertions.assertEquals((int)locator.getReconnectAttempts(), (int)reconnectAttempts);
    }

    private void startServer() throws Exception {
        this.liveTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration broadcastGroupConfiguration = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(Arrays.asList(this.liveTC.getName())).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(SessionFactoryTest.getUDPDiscoveryAddress()).setGroupPort(SessionFactoryTest.getUDPDiscoveryPort()).setLocalBindPort(5432));
        Configuration primaryConf = this.createDefaultInVMConfig().addConnectorConfiguration(this.liveTC.getName(), this.liveTC).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addBroadcastGroupConfiguration(broadcastGroupConfiguration);
        this.liveService = this.createServer(false, primaryConf);
        this.liveService.start();
    }
}

