/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricClusterTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testStopAllStartAll() throws Throwable {
        try {
            this.setupCluster();
            this.startServers();
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.setupSessionFactory(2, this.isNetty());
            this.setupSessionFactory(3, this.isNetty());
            this.setupSessionFactory(4, this.isNetty());
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.createQueue(2, "queues.testaddress", "queue0", null, false);
            this.createQueue(3, "queues.testaddress", "queue0", null, false);
            this.createQueue(4, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.addConsumer(1, 1, "queue0", null);
            this.addConsumer(2, 2, "queue0", null);
            this.addConsumer(3, 3, "queue0", null);
            this.addConsumer(4, 4, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 1, true);
            this.waitForBindings(2, "queues.testaddress", 1, 1, true);
            this.waitForBindings(3, "queues.testaddress", 1, 1, true);
            this.waitForBindings(4, "queues.testaddress", 1, 1, true);
            this.waitForBindings(0, "queues.testaddress", 4, 4, false);
            this.waitForBindings(1, "queues.testaddress", 4, 4, false);
            this.waitForBindings(2, "queues.testaddress", 4, 4, false);
            this.waitForBindings(3, "queues.testaddress", 4, 4, false);
            this.waitForBindings(4, "queues.testaddress", 4, 4, false);
            this.send(0, "queues.testaddress", 10, false, null);
            this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
            this.verifyNotReceive(0, 1, 2, 3, 4);
            this.removeConsumer(0);
            this.removeConsumer(1);
            this.removeConsumer(2);
            this.removeConsumer(3);
            this.removeConsumer(4);
            this.closeAllSessionFactories();
            this.closeAllServerLocatorsFactories();
            this.stopServers(0, 1, 2, 3, 4);
            this.startServers();
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.setupSessionFactory(2, this.isNetty());
            this.setupSessionFactory(3, this.isNetty());
            this.setupSessionFactory(4, this.isNetty());
            this.createQueue(0, "queues.testaddress", "queue0", null, false);
            this.createQueue(1, "queues.testaddress", "queue0", null, false);
            this.createQueue(2, "queues.testaddress", "queue0", null, false);
            this.createQueue(3, "queues.testaddress", "queue0", null, false);
            this.createQueue(4, "queues.testaddress", "queue0", null, false);
            this.addConsumer(0, 0, "queue0", null);
            this.addConsumer(1, 1, "queue0", null);
            this.addConsumer(2, 2, "queue0", null);
            this.addConsumer(3, 3, "queue0", null);
            this.addConsumer(4, 4, "queue0", null);
            this.waitForBindings(0, "queues.testaddress", 1, 1, true);
            this.waitForBindings(1, "queues.testaddress", 1, 1, true);
            this.waitForBindings(2, "queues.testaddress", 1, 1, true);
            this.waitForBindings(3, "queues.testaddress", 1, 1, true);
            this.waitForBindings(4, "queues.testaddress", 1, 1, true);
            this.waitForBindings(0, "queues.testaddress", 4, 4, false);
            this.waitForBindings(1, "queues.testaddress", 4, 4, false);
            this.waitForBindings(2, "queues.testaddress", 4, 4, false);
            this.waitForBindings(3, "queues.testaddress", 4, 4, false);
            this.waitForBindings(4, "queues.testaddress", 4, 4, false);
            this.send(0, "queues.testaddress", 10, false, null);
            this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
            this.verifyNotReceive(0, 1, 2, 3, 4);
        }
        catch (Throwable e) {
            System.out.println(ActiveMQTestBase.threadDump("SymmetricClusterTest::testStopAllStartAll"));
            throw e;
        }
    }

    @Test
    public void testBasicRoundRobin() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4);
    }

    @Test
    public void testBasicRoundRobinManyMessages() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.send(0, "queues.testaddress", 1000, true, null);
        this.verifyReceiveRoundRobinInSomeOrder(1000, 0, 1, 2, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4);
    }

    @Test
    public void testBasicRoundRobinManyMessagesNoAddressAutoCreate() throws Exception {
        int i;
        this.setupCluster();
        this.startServers();
        for (i = 0; i < 5; ++i) {
            this.servers[i].getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        }
        for (i = 0; i < 5; ++i) {
            this.setupSessionFactory(i, this.isNetty());
        }
        for (i = 0; i < 5; ++i) {
            this.servers[i].addAddressInfo(new AddressInfo(SimpleString.of((String)"queues.testaddress"), RoutingType.MULTICAST));
            this.createQueue(i, "queues.testaddress", "queue0", null, false);
        }
        for (i = 0; i < 5; ++i) {
            this.addConsumer(i, i, "queue0", null);
        }
        for (i = 0; i < 5; ++i) {
            this.waitForBindings(i, "queues.testaddress", 1, 1, true);
        }
        for (i = 0; i < 5; ++i) {
            this.waitForBindings(i, "queues.testaddress", 4, 4, false);
        }
        this.send(0, "queues.testaddress", 1000, true, null);
        this.verifyReceiveRoundRobinInSomeOrder(1000, 0, 1, 2, 3, 4);
        this.verifyNotReceive(0, 1, 2, 3, 4);
    }

    @Test
    public void testRoundRobinMultipleQueues() throws Exception {
        logger.debug("starting");
        this.setupCluster();
        logger.debug("setup cluster");
        this.startServers();
        logger.debug("started servers");
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        logger.debug("Set up session factories");
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue1", null, false);
        this.createQueue(3, "queues.testaddress", "queue1", null, false);
        this.createQueue(4, "queues.testaddress", "queue1", null, false);
        this.createQueue(0, "queues.testaddress", "queue2", null, false);
        this.createQueue(1, "queues.testaddress", "queue2", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue2", null, false);
        this.createQueue(4, "queues.testaddress", "queue2", null, false);
        logger.debug("created queues");
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.addConsumer(5, 0, "queue1", null);
        this.addConsumer(6, 1, "queue1", null);
        this.addConsumer(7, 2, "queue1", null);
        this.addConsumer(8, 3, "queue1", null);
        this.addConsumer(9, 4, "queue1", null);
        this.addConsumer(10, 0, "queue2", null);
        this.addConsumer(11, 1, "queue2", null);
        this.addConsumer(12, 2, "queue2", null);
        this.addConsumer(13, 3, "queue2", null);
        this.addConsumer(14, 4, "queue2", null);
        logger.debug("added consumers");
        this.waitForBindings(0, "queues.testaddress", 3, 3, true);
        this.waitForBindings(1, "queues.testaddress", 3, 3, true);
        this.waitForBindings(2, "queues.testaddress", 3, 3, true);
        this.waitForBindings(3, "queues.testaddress", 3, 3, true);
        this.waitForBindings(4, "queues.testaddress", 3, 3, true);
        this.waitForBindings(0, "queues.testaddress", 12, 12, false);
        this.waitForBindings(1, "queues.testaddress", 12, 12, false);
        this.waitForBindings(2, "queues.testaddress", 12, 12, false);
        this.waitForBindings(3, "queues.testaddress", 12, 12, false);
        this.waitForBindings(4, "queues.testaddress", 12, 12, false);
        logger.debug("waited for bindings");
        this.send(0, "queues.testaddress", 10, false, null);
        logger.debug("sent messages");
        this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
        logger.debug("verified 1");
        this.verifyReceiveRoundRobinInSomeOrder(10, 5, 6, 7, 8, 9);
        logger.debug("verified 2");
        this.verifyReceiveRoundRobinInSomeOrder(10, 10, 11, 12, 13, 14);
        logger.debug("verified 3");
    }

    @Test
    public void testMultipleNonLoadBalancedQueues() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.waitForBindings(0, "queues.testaddress", 3, 3, true);
        this.waitForBindings(1, "queues.testaddress", 3, 3, true);
        this.waitForBindings(2, "queues.testaddress", 3, 3, true);
        this.waitForBindings(3, "queues.testaddress", 3, 3, true);
        this.waitForBindings(4, "queues.testaddress", 3, 3, true);
        this.waitForBindings(0, "queues.testaddress", 12, 12, false);
        this.waitForBindings(1, "queues.testaddress", 12, 12, false);
        this.waitForBindings(2, "queues.testaddress", 12, 12, false);
        this.waitForBindings(3, "queues.testaddress", 12, 12, false);
        this.waitForBindings(4, "queues.testaddress", 12, 12, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueues() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesRemoveSomeQueuesAndConsumers() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.removeConsumer(16);
        this.removeConsumer(18);
        this.removeConsumer(21);
        this.removeConsumer(22);
        this.removeConsumer(26);
        this.deleteQueue(1, "queue15");
        this.deleteQueue(3, "queue15");
        this.deleteQueue(3, "queue16");
        this.deleteQueue(4, "queue16");
        this.deleteQueue(3, "queue18");
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 4, 4, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 3, 3, true);
        this.waitForBindings(4, "queues.testaddress", 6, 6, true);
        this.waitForBindings(0, "queues.testaddress", 18, 18, false);
        this.waitForBindings(1, "queues.testaddress", 19, 19, false);
        this.waitForBindings(2, "queues.testaddress", 18, 18, false);
        this.waitForBindings(3, "queues.testaddress", 20, 20, false);
        this.waitForBindings(4, "queues.testaddress", 17, 17, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 20, 27);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 17, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesAddQueuesAndConsumersBeforeAllServersAreStarted() throws Exception {
        this.setupCluster();
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(5, 0, "queue5", null);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(16, 1, "queue15", null);
        this.startServers(2);
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(17, 2, "queue15", null);
        this.startServers(3);
        this.setupSessionFactory(3, this.isNetty());
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(18, 3, "queue15", null);
        this.startServers(4);
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesWithFilters() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        String filter1 = "haggis";
        String filter2 = "scotch-egg";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", filter1, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", filter2, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", filter2, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", filter2, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", filter1, false);
        this.createQueue(0, "queues.testaddress", "queue15", filter1, false);
        this.createQueue(1, "queues.testaddress", "queue15", filter1, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", filter2, false);
        this.createQueue(4, "queues.testaddress", "queue15", filter2, false);
        this.createQueue(2, "queues.testaddress", "queue16", filter1, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", filter2, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveAll(10, 0, 1, 2, 4, 5, 6, 8, 9, 10, 12, 13, 14, 27);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveAll(10, 0, 2, 3, 4, 6, 7, 8, 10, 11, 12, 13);
        this.verifyReceiveRoundRobinInSomeOrder(10, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 2, 4, 6, 8, 10, 12, 13, 17, 27);
        this.verifyReceiveRoundRobinInSomeOrder(10, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
    }

    @Test
    public void testMixtureLoadBalancedAndNonLoadBalancedQueuesWithConsumersWithFilters() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        String filter1 = "haggis";
        String filter2 = "scotch-egg";
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", filter2, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", filter1);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", filter2);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", filter1);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", filter2);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", filter1);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", filter2);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", filter1);
        this.addConsumer(15, 0, "queue15", filter1);
        this.addConsumer(16, 1, "queue15", filter1);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", filter2);
        this.addConsumer(19, 4, "queue15", filter2);
        this.addConsumer(20, 2, "queue16", filter1);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", filter2);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, filter1);
        this.verifyReceiveAll(10, 0, 1, 2, 4, 5, 6, 8, 9, 10, 12, 13, 14, 27);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.send(0, "queues.testaddress", 10, false, filter2);
        this.verifyReceiveAll(10, 0, 2, 3, 4, 6, 7, 8, 10, 11, 12, 13);
        this.verifyReceiveRoundRobinInSomeOrder(10, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 2, 4, 6, 8, 10, 12, 13, 17, 27);
        this.verifyReceiveRoundRobinInSomeOrder(10, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
    }

    @Test
    public void testRouteWhenNoConsumersTrueLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(3, "queues.testaddress", 1, 0, true);
        this.waitForBindings(4, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 4, 0, false);
        this.waitForBindings(1, "queues.testaddress", 4, 0, false);
        this.waitForBindings(2, "queues.testaddress", 4, 0, false);
        this.waitForBindings(3, "queues.testaddress", 4, 0, false);
        this.waitForBindings(4, "queues.testaddress", 4, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.verifyReceiveRoundRobinInSomeOrder(10, 0, 1, 2, 3, 4);
    }

    @Test
    public void testRouteWhenNoConsumersFalseLocalConsumerLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(3, "queues.testaddress", 1, 0, true);
        this.waitForBindings(4, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 4, 0, false);
        this.waitForBindings(1, "queues.testaddress", 4, 1, false);
        this.waitForBindings(2, "queues.testaddress", 4, 1, false);
        this.waitForBindings(3, "queues.testaddress", 4, 1, false);
        this.waitForBindings(4, "queues.testaddress", 4, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testRouteWhenNoConsumersFalseNonLoadBalancedQueues2() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(3, "queues.testaddress", 1, 0, true);
        this.waitForBindings(4, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 4, 0, false);
        this.waitForBindings(1, "queues.testaddress", 4, 0, false);
        this.waitForBindings(2, "queues.testaddress", 4, 0, false);
        this.waitForBindings(3, "queues.testaddress", 4, 0, false);
        this.waitForBindings(4, "queues.testaddress", 4, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 3, "queue0", null);
        this.addConsumer(4, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testRouteWhenNoConsumersFalseNonLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(3, "queues.testaddress", 1, 0, true);
        this.waitForBindings(4, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 4, 0, false);
        this.waitForBindings(1, "queues.testaddress", 4, 0, false);
        this.waitForBindings(2, "queues.testaddress", 4, 0, false);
        this.waitForBindings(3, "queues.testaddress", 4, 0, false);
        this.waitForBindings(4, "queues.testaddress", 4, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4);
    }

    @Test
    public void testRouteWhenNoConsumersTrueNonLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(3, "queues.testaddress", 1, 0, true);
        this.waitForBindings(4, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 4, 0, false);
        this.waitForBindings(1, "queues.testaddress", 4, 0, false);
        this.waitForBindings(2, "queues.testaddress", 4, 0, false);
        this.waitForBindings(3, "queues.testaddress", 4, 0, false);
        this.waitForBindings(4, "queues.testaddress", 4, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.waitForBindings(3, "queues.testaddress", 4, 4, false);
        this.waitForBindings(4, "queues.testaddress", 4, 4, false);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4);
    }

    @Test
    public void testNoLocalQueueNonLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 3, 3, false);
        this.waitForBindings(2, "queues.testaddress", 3, 3, false);
        this.waitForBindings(3, "queues.testaddress", 3, 3, false);
        this.waitForBindings(4, "queues.testaddress", 3, 3, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 1, 2, 3, 4);
    }

    @Test
    public void testNoLocalQueueLoadBalancedQueues() throws Exception {
        this.setupCluster(MessageLoadBalancingType.STRICT);
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue1", null, false);
        this.createQueue(3, "queues.testaddress", "queue1", null, false);
        this.createQueue(4, "queues.testaddress", "queue1", null, false);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue1", null);
        this.addConsumer(3, 3, "queue1", null);
        this.addConsumer(4, 4, "queue1", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        this.waitForBindings(4, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 3, 3, false);
        this.waitForBindings(2, "queues.testaddress", 3, 3, false);
        this.waitForBindings(3, "queues.testaddress", 3, 3, false);
        this.waitForBindings(4, "queues.testaddress", 3, 3, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(10, 1, 2, 3, 4);
    }

    @Test
    public void testStartStopServers() throws Exception {
        this.doTestStartStopServers(1L, 3000L);
    }

    public void doTestStartStopServers(long pauseBeforeServerRestarts, long pauseAfterServerRestarts) throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.removeConsumer(0);
        this.removeConsumer(5);
        this.removeConsumer(10);
        this.removeConsumer(15);
        this.removeConsumer(23);
        this.removeConsumer(3);
        this.removeConsumer(8);
        this.removeConsumer(13);
        this.removeConsumer(18);
        this.removeConsumer(21);
        this.removeConsumer(26);
        this.closeSessionFactory(0);
        this.closeSessionFactory(3);
        this.stopServers(0, 3);
        Thread.sleep(pauseBeforeServerRestarts);
        this.startServers(3, 0);
        Thread.sleep(pauseAfterServerRestarts);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
    }

    @Test
    public void testStopSuccessiveServers() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue2", null, false);
        this.createQueue(3, "queues.testaddress", "queue3", null, false);
        this.createQueue(4, "queues.testaddress", "queue4", null, false);
        this.createQueue(0, "queues.testaddress", "queue5", null, false);
        this.createQueue(1, "queues.testaddress", "queue6", null, false);
        this.createQueue(2, "queues.testaddress", "queue7", null, false);
        this.createQueue(3, "queues.testaddress", "queue8", null, false);
        this.createQueue(4, "queues.testaddress", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, false);
        this.createQueue(1, "queues.testaddress", "queue11", null, false);
        this.createQueue(2, "queues.testaddress", "queue12", null, false);
        this.createQueue(3, "queues.testaddress", "queue13", null, false);
        this.createQueue(4, "queues.testaddress", "queue14", null, false);
        this.createQueue(0, "queues.testaddress", "queue15", null, false);
        this.createQueue(1, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue15", null, false);
        this.createQueue(3, "queues.testaddress", "queue15", null, false);
        this.createQueue(4, "queues.testaddress", "queue15", null, false);
        this.createQueue(2, "queues.testaddress", "queue16", null, false);
        this.createQueue(3, "queues.testaddress", "queue16", null, false);
        this.createQueue(4, "queues.testaddress", "queue16", null, false);
        this.createQueue(0, "queues.testaddress", "queue17", null, false);
        this.createQueue(1, "queues.testaddress", "queue17", null, false);
        this.createQueue(4, "queues.testaddress", "queue17", null, false);
        this.createQueue(3, "queues.testaddress", "queue18", null, false);
        this.createQueue(4, "queues.testaddress", "queue18", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue1", null);
        this.addConsumer(2, 2, "queue2", null);
        this.addConsumer(3, 3, "queue3", null);
        this.addConsumer(4, 4, "queue4", null);
        this.addConsumer(5, 0, "queue5", null);
        this.addConsumer(6, 1, "queue6", null);
        this.addConsumer(7, 2, "queue7", null);
        this.addConsumer(8, 3, "queue8", null);
        this.addConsumer(9, 4, "queue9", null);
        this.addConsumer(10, 0, "queue10", null);
        this.addConsumer(11, 1, "queue11", null);
        this.addConsumer(12, 2, "queue12", null);
        this.addConsumer(13, 3, "queue13", null);
        this.addConsumer(14, 4, "queue14", null);
        this.addConsumer(15, 0, "queue15", null);
        this.addConsumer(16, 1, "queue15", null);
        this.addConsumer(17, 2, "queue15", null);
        this.addConsumer(18, 3, "queue15", null);
        this.addConsumer(19, 4, "queue15", null);
        this.addConsumer(20, 2, "queue16", null);
        this.addConsumer(21, 3, "queue16", null);
        this.addConsumer(22, 4, "queue16", null);
        this.addConsumer(23, 0, "queue17", null);
        this.addConsumer(24, 1, "queue17", null);
        this.addConsumer(25, 4, "queue17", null);
        this.addConsumer(26, 3, "queue18", null);
        this.addConsumer(27, 4, "queue18", null);
        this.waitForBindings(0, "queues.testaddress", 5, 5, true);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(0, "queues.testaddress", 23, 23, false);
        this.waitForBindings(1, "queues.testaddress", 23, 23, false);
        this.waitForBindings(2, "queues.testaddress", 23, 23, false);
        this.waitForBindings(3, "queues.testaddress", 22, 22, false);
        this.waitForBindings(4, "queues.testaddress", 21, 21, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
        this.verifyReceiveRoundRobinInSomeOrder(10, 15, 16, 17, 18, 19);
        this.verifyReceiveRoundRobinInSomeOrder(10, 20, 21, 22);
        this.verifyReceiveRoundRobinInSomeOrder(10, 23, 24, 25);
        this.verifyReceiveRoundRobinInSomeOrder(10, 26, 27);
        this.removeConsumer(0);
        this.removeConsumer(5);
        this.removeConsumer(10);
        this.removeConsumer(15);
        this.removeConsumer(23);
        this.closeSessionFactory(0);
        this.stopServers(0);
        this.waitForBindings(1, "queues.testaddress", 5, 5, true);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(1, "queues.testaddress", 18, 18, false);
        this.waitForBindings(2, "queues.testaddress", 18, 18, false);
        this.waitForBindings(3, "queues.testaddress", 17, 17, false);
        this.waitForBindings(4, "queues.testaddress", 16, 16, false);
        this.removeConsumer(1);
        this.removeConsumer(6);
        this.removeConsumer(11);
        this.removeConsumer(16);
        this.removeConsumer(24);
        this.closeSessionFactory(1);
        this.stopServers(1);
        this.waitForBindings(2, "queues.testaddress", 5, 5, true);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(2, "queues.testaddress", 13, 13, false);
        this.waitForBindings(3, "queues.testaddress", 12, 12, false);
        this.waitForBindings(4, "queues.testaddress", 11, 11, false);
        this.removeConsumer(2);
        this.removeConsumer(7);
        this.removeConsumer(12);
        this.removeConsumer(17);
        this.removeConsumer(20);
        this.closeSessionFactory(2);
        this.stopServers(2);
        this.waitForBindings(3, "queues.testaddress", 6, 6, true);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(3, "queues.testaddress", 7, 7, false);
        this.waitForBindings(4, "queues.testaddress", 6, 6, false);
        this.removeConsumer(3);
        this.removeConsumer(8);
        this.removeConsumer(13);
        this.removeConsumer(18);
        this.removeConsumer(21);
        this.removeConsumer(26);
        this.closeSessionFactory(3);
        this.stopServers(3);
        this.waitForBindings(4, "queues.testaddress", 7, 7, true);
        this.waitForBindings(4, "queues.testaddress", 0, 0, false);
    }

    @Test
    public void testClusterAddressCreatesBindingsForSimpleStringAddressFilters() throws Exception {
        this.setupCluster("test", "test", "test", "test", "test");
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "test.1", "queue0", null, false);
        this.createQueue(1, "test.1", "queue0", null, false);
        this.createQueue(2, "test.1", "queue0", null, false);
        this.createQueue(3, "test.1", "queue0", null, false);
        this.createQueue(4, "test.1", "queue0", null, false);
        this.createQueue(0, "foo.queues.test.1", "queue1", null, false);
        this.createQueue(1, "foo.queues.test.1", "queue1", null, false);
        this.createQueue(2, "foo.queues.test.1", "queue1", null, false);
        this.createQueue(3, "foo.queues.test.1", "queue1", null, false);
        this.createQueue(4, "foo.queues.test.1", "queue1", null, false);
        this.waitForBindings(0, "test.1", 4, 0, false);
        this.waitForBindings(1, "test.1", 4, 0, false);
        this.waitForBindings(2, "test.1", 4, 0, false);
        this.waitForBindings(3, "test.1", 4, 0, false);
        this.waitForBindings(4, "test.1", 4, 0, false);
        this.waitForBindings(0, "foo.queues.test.1", 0, 0, false);
        this.waitForBindings(1, "foo.queues.test.1", 0, 0, false);
        this.waitForBindings(2, "foo.queues.test.1", 0, 0, false);
        this.waitForBindings(3, "foo.queues.test.1", 0, 0, false);
        this.waitForBindings(4, "foo.queues.test.1", 0, 0, false);
    }

    @Test
    public void testClusterAddressDoesNotCreatesBindingsForStringExcludesAddressFilters() throws Exception {
        this.setupCluster("jms.eu.de,!jms.eu.uk", "jms.eu.de,!jms.eu.uk", "jms.eu.de,!jms.eu.uk", "jms.eu.de,!jms.eu.uk", "jms.eu.de,!jms.eu.uk");
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "jms.eu.uk", "queue0", null, false);
        this.createQueue(1, "jms.eu.uk", "queue0", null, false);
        this.createQueue(2, "jms.eu.uk", "queue0", null, false);
        this.createQueue(3, "jms.eu.uk", "queue0", null, false);
        this.createQueue(4, "jms.eu.uk", "queue0", null, false);
        this.createQueue(0, "jms.eu.de", "queue1", null, false);
        this.createQueue(1, "jms.eu.de", "queue1", null, false);
        this.createQueue(2, "jms.eu.de", "queue1", null, false);
        this.createQueue(3, "jms.eu.de", "queue1", null, false);
        this.createQueue(4, "jms.eu.de", "queue1", null, false);
        this.waitForBindings(0, "jms.eu.de", 4, 0, false);
        this.waitForBindings(1, "jms.eu.de", 4, 0, false);
        this.waitForBindings(2, "jms.eu.de", 4, 0, false);
        this.waitForBindings(3, "jms.eu.de", 4, 0, false);
        this.waitForBindings(4, "jms.eu.de", 4, 0, false);
        this.waitForBindings(0, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(1, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(2, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(3, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(4, "jms.eu.uk", 0, 0, false);
    }

    @Test
    public void testClusterAddressFiltersExcludesAndIncludesAddressesInList() throws Exception {
        this.setupCluster("jms.eu,!jms.eu.uk,jms.us,!jms.us.bos", "jms.eu,!jms.eu.uk,jms.us,!jms.us.bos", "jms.eu,!jms.eu.uk,jms.us,!jms.us.bos", "jms.eu,!jms.eu.uk,jms.us,!jms.us.bos", "jms.eu,!jms.eu.uk,jms.us,!jms.us.bos");
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.setupSessionFactory(3, this.isNetty());
        this.setupSessionFactory(4, this.isNetty());
        this.createQueue(0, "jms.eu.uk", "queue0", null, false);
        this.createQueue(1, "jms.eu.uk", "queue0", null, false);
        this.createQueue(2, "jms.eu.uk", "queue0", null, false);
        this.createQueue(3, "jms.eu.uk", "queue0", null, false);
        this.createQueue(4, "jms.eu.uk", "queue0", null, false);
        this.createQueue(0, "jms.eu.de", "queue1", null, false);
        this.createQueue(1, "jms.eu.de", "queue1", null, false);
        this.createQueue(2, "jms.eu.de", "queue1", null, false);
        this.createQueue(3, "jms.eu.de", "queue1", null, false);
        this.createQueue(4, "jms.eu.de", "queue1", null, false);
        this.createQueue(0, "jms.eu.fr", "queue2", null, false);
        this.createQueue(1, "jms.eu.fr", "queue2", null, false);
        this.createQueue(2, "jms.eu.fr", "queue2", null, false);
        this.createQueue(3, "jms.eu.fr", "queue2", null, false);
        this.createQueue(4, "jms.eu.fr", "queue2", null, false);
        this.createQueue(0, "jms.us.ca", "queue4", null, false);
        this.createQueue(1, "jms.us.ca", "queue4", null, false);
        this.createQueue(2, "jms.us.ca", "queue4", null, false);
        this.createQueue(3, "jms.us.ca", "queue4", null, false);
        this.createQueue(4, "jms.us.ca", "queue4", null, false);
        this.createQueue(0, "jms.us.se", "queue5", null, false);
        this.createQueue(1, "jms.us.se", "queue5", null, false);
        this.createQueue(2, "jms.us.se", "queue5", null, false);
        this.createQueue(3, "jms.us.se", "queue5", null, false);
        this.createQueue(4, "jms.us.se", "queue5", null, false);
        this.createQueue(0, "jms.us.ny", "queue6", null, false);
        this.createQueue(1, "jms.us.ny", "queue6", null, false);
        this.createQueue(2, "jms.us.ny", "queue6", null, false);
        this.createQueue(3, "jms.us.ny", "queue6", null, false);
        this.createQueue(4, "jms.us.ny", "queue6", null, false);
        this.waitForBindings(0, "jms.eu.de", 4, 0, false);
        this.waitForBindings(1, "jms.eu.de", 4, 0, false);
        this.waitForBindings(2, "jms.eu.de", 4, 0, false);
        this.waitForBindings(3, "jms.eu.de", 4, 0, false);
        this.waitForBindings(4, "jms.eu.de", 4, 0, false);
        this.waitForBindings(0, "jms.eu.fr", 4, 0, false);
        this.waitForBindings(1, "jms.eu.fr", 4, 0, false);
        this.waitForBindings(2, "jms.eu.fr", 4, 0, false);
        this.waitForBindings(3, "jms.eu.fr", 4, 0, false);
        this.waitForBindings(4, "jms.eu.fr", 4, 0, false);
        this.waitForBindings(0, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(1, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(2, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(3, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(4, "jms.eu.uk", 0, 0, false);
        this.waitForBindings(0, "jms.us.ca", 4, 0, false);
        this.waitForBindings(1, "jms.us.ca", 4, 0, false);
        this.waitForBindings(2, "jms.us.ca", 4, 0, false);
        this.waitForBindings(3, "jms.us.ca", 4, 0, false);
        this.waitForBindings(4, "jms.us.ca", 4, 0, false);
        this.waitForBindings(0, "jms.us.ny", 4, 0, false);
        this.waitForBindings(1, "jms.us.ny", 4, 0, false);
        this.waitForBindings(2, "jms.us.ny", 4, 0, false);
        this.waitForBindings(3, "jms.us.ny", 4, 0, false);
        this.waitForBindings(4, "jms.us.ny", 4, 0, false);
        this.waitForBindings(0, "jms.us.bos", 0, 0, false);
        this.waitForBindings(1, "jms.us.bos", 0, 0, false);
        this.waitForBindings(2, "jms.us.bos", 0, 0, false);
        this.waitForBindings(3, "jms.us.bos", 0, 0, false);
        this.waitForBindings(4, "jms.us.bos", 0, 0, false);
    }

    protected void setupCluster(String addr1, String addr2, String addr3, String addr4, String addr5) throws Exception {
        this.setupClusterConnection("cluster0", addr1, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", addr2, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", addr3, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", addr4, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", addr5, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 4, 0, 1, 2, 3);
    }

    protected void setupCluster() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, 0, 1, 2, 3);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupServer(3, this.isFileStorage(), this.isNetty());
        this.setupServer(4, this.isFileStorage(), this.isNetty());
    }

    protected void startServers() throws Exception {
        this.startServers(0, 1, 2, 3, 4);
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1, 2, 3, 4);
    }

    @Override
    protected boolean isFileStorage() {
        return false;
    }
}

