/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreBackupPolicy;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailBackAutoTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NUM_MESSAGES = 100;
    private ServerLocatorInternal locator;
    private ClientSessionFactoryInternal sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    @Test
    public void testAutoFailback() throws Exception {
        ((SharedStoreBackupPolicy)this.backupServer.getServer().getHAPolicy()).setRestartBackup(false);
        this.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(latch, session);
        session.addFailureListener((SessionFailureListener)listener);
        this.primaryServer.crash(new ClientSession[0]);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        logger.debug("backup (now primary) topology = {}", (Object)this.backupServer.getServer().getClusterManager().getDefaultConnection(null).getTopology().describe());
        logger.debug("Server Crash!!!");
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        this.verifyMessageOnServer(1, 1);
        session.removeFailureListener((SessionFailureListener)listener);
        CountDownLatch latch2 = new CountDownLatch(1);
        listener = new CountDownSessionFailureListener(latch2, session);
        session.addFailureListener((SessionFailureListener)listener);
        logger.debug("******* starting primary server back");
        this.primaryServer.start();
        Thread.sleep(1000L);
        logger.debug("After failback: {}", (Object)this.locator.getTopology().describe());
        Assertions.assertTrue((boolean)latch2.await(5L, TimeUnit.SECONDS));
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.close();
        this.verifyMessageOnServer(0, 1);
        this.wrapUpSessionFactory();
    }

    private void verifyMessageOnServer(int server, int numberOfMessages) throws Exception {
        ServerLocator backupLocator = this.createInVMLocator(server);
        ClientSessionFactory factorybkp = this.addSessionFactory(this.createSessionFactory(backupLocator));
        ClientSession sessionbkp = factorybkp.createSession(false, false);
        sessionbkp.start();
        ClientConsumer consumerbkp = sessionbkp.createConsumer(ADDRESS);
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = consumerbkp.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            sessionbkp.commit();
        }
        sessionbkp.close();
        factorybkp.close();
        backupLocator.close();
    }

    @Test
    public void testAutoFailbackThenFailover() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        logger.debug("Crashing primary server...");
        this.primaryServer.crash(session);
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.removeFailureListener((SessionFailureListener)listener);
        listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        logger.debug("restarting primary node now");
        this.primaryServer.start();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS), (String)"expected a session failure 1");
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.removeFailureListener((SessionFailureListener)listener);
        listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.waitForBackup(this.sf, 10);
        logger.debug("Crashing primary server again...");
        this.primaryServer.crash(new ClientSession[0]);
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS), (String)"expected a session failure 2");
        session.close();
        this.wrapUpSessionFactory();
    }

    @Test
    public void testFailBack() throws Exception {
        ((SharedStoreBackupPolicy)this.backupServer.getServer().getHAPolicy()).setRestartBackup(false);
        this.createSessionFactory();
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 100);
        session.commit();
        this.crash(session);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        this.receiveMessages(consumer, 0, 100, true);
        producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 200);
        session.commit();
        Assertions.assertFalse((boolean)this.primaryServer.getServer().getHAPolicy().isBackup(), (String)"must NOT be a backup");
        this.adaptPrimaryConfigForReplicatedFailBack(this.primaryServer);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(session);
        session.addFailureListener((SessionFailureListener)listener);
        this.primaryServer.start();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.primaryServer.getServer().waitForActivation(15L, TimeUnit.SECONDS), (String)"primary initialized after restart");
        session.start();
        this.receiveMessages(consumer, 0, 100, true);
    }

    private void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
    }

    private void wrapUpSessionFactory() {
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions());
        Assertions.assertEquals((int)0, (int)this.sf.numConnections());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setRestartBackup(true)).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailBackAutoTest.basicClusterConnectionConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(FailBackAutoTest.basicClusterConnectionConfig(primaryConnector.getName(), backupConnector.getName())).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMAcceptor(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMConnector(primary);
    }

    private ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assertions.assertEquals((Object)i, (Object)message2.getObjectProperty(SimpleString.of((String)"count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        consumer.close();
        Assertions.assertNull((Object)message3);
        return session;
    }
}

