/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.MultipleBackupsFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePrimaryMultipleBackupsFailoverTest
extends MultipleBackupsFailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Map<Integer, TestableServer> servers = new HashMap<Integer, TestableServer>();
    protected ServerLocatorImpl locator;
    private NodeManager nodeManager;
    final boolean sharedStore = true;

    @Test
    public void testMultipleFailovers() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        this.createPrimaryConfig(0);
        this.createBackupConfig(0, 1, 0, 2, 3, 4, 5);
        this.createBackupConfig(0, 2, 0, 1, 3, 4, 5);
        this.createBackupConfig(0, 3, 0, 1, 2, 4, 5);
        this.createBackupConfig(0, 4, 0, 1, 2, 3, 5);
        this.createBackupConfig(0, 5, 0, 1, 2, 3, 4);
        this.servers.get(0).start();
        this.waitForServerToStart(this.servers.get(0).getServer());
        this.servers.get(1).start();
        this.waitForServerToStart(this.servers.get(1).getServer());
        this.servers.get(2).start();
        this.servers.get(3).start();
        this.servers.get(4).start();
        this.servers.get(5).start();
        this.locator = (ServerLocatorImpl)this.getServerLocator(0);
        Topology topology = this.locator.getTopology();
        topology.setOwner((Object)"testMultipleFailovers");
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)sf, true);
        logger.debug("failing node 0");
        this.servers.get(0).crash(session);
        session.close();
        int backupNode = this.waitForNewPrimary(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        logger.debug("failing node {}", (Object)backupNode);
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewPrimary(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        logger.debug("failing node {}", (Object)backupNode);
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewPrimary(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        logger.debug("failing node {}", (Object)backupNode);
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewPrimary(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        logger.debug("failing node {}", (Object)backupNode);
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewPrimary(5L, false, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        session.close();
        this.servers.get(backupNode).stop();
        this.locator.close();
    }

    protected void createBackupConfig(int primaryNode, int nodeid, int ... nodes) throws Exception {
        TransportConfiguration backupConnector = SinglePrimaryMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, SinglePrimaryMultipleBackupsFailoverTest.generateParams(nodeid, this.isNetty()));
        Configuration config1 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(SinglePrimaryMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), true, SinglePrimaryMultipleBackupsFailoverTest.generateParams(nodeid, this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(backupConnector.getName(), backupConnector).setBindingsDirectory(this.getBindingsDir() + "_" + primaryNode).setJournalDirectory(this.getJournalDir() + "_" + primaryNode).setPagingDirectory(this.getPageDir() + "_" + primaryNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + primaryNode);
        String[] staticConnectors = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            TransportConfiguration primaryConnector = SinglePrimaryMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, SinglePrimaryMultipleBackupsFailoverTest.generateParams(nodes[i], this.isNetty()));
            config1.addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
            staticConnectors[i] = primaryConnector.getName();
        }
        config1.addClusterConfiguration(SinglePrimaryMultipleBackupsFailoverTest.basicClusterConnectionConfig(backupConnector.getName(), staticConnectors));
        this.servers.put(nodeid, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config1, this.nodeManager, nodeid)));
    }

    protected void createPrimaryConfig(int primaryNode) throws Exception {
        TransportConfiguration primaryConnector = SinglePrimaryMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, SinglePrimaryMultipleBackupsFailoverTest.generateParams(primaryNode, this.isNetty()));
        Configuration config0 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(SinglePrimaryMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), true, SinglePrimaryMultipleBackupsFailoverTest.generateParams(primaryNode, this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(SinglePrimaryMultipleBackupsFailoverTest.basicClusterConnectionConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).setBindingsDirectory(this.getBindingsDir() + "_" + primaryNode).setJournalDirectory(this.getJournalDir() + "_" + primaryNode).setPagingDirectory(this.getPageDir() + "_" + primaryNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + primaryNode);
        SameProcessActiveMQServer server = new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config0, this.nodeManager, primaryNode));
        this.addActiveMQComponent(server);
        this.servers.put(primaryNode, server);
    }

    @Override
    protected boolean isNetty() {
        return false;
    }
}

