/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.critical;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CriticalSimpleTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleShutdown() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        configuration.setCriticalAnalyzerCheckPeriod(10L).setCriticalAnalyzerPolicy(CriticalAnalyzerPolicy.SHUTDOWN);
        ActiveMQServer server = this.createServer(false, configuration, 0xA00000, -1L);
        server.start();
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            server.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

                public void criticalFailure(CriticalComponent components) throws ActiveMQException {
                    latch.countDown();
                }
            });
            server.getCriticalAnalyzer().add(new CriticalComponent(){

                public CriticalAnalyzer getCriticalAnalyzer() {
                    return null;
                }

                public CriticalCloseable measureCritical(int path) {
                    return null;
                }

                public boolean checkExpiration(long timeout, boolean reset) {
                    return true;
                }
            });
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Wait.waitFor(() -> !server.isStarted());
            Assertions.assertFalse((boolean)server.isStarted());
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testCriticalOff() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        configuration.setCriticalAnalyzerCheckPeriod(10L).setCriticalAnalyzer(false);
        ActiveMQServer server = this.createServer(false, configuration, 0xA00000, -1L);
        server.start();
        try {
            server.getCriticalAnalyzer().add(new CriticalComponent(){

                public CriticalAnalyzer getCriticalAnalyzer() {
                    return null;
                }

                public CriticalCloseable measureCritical(int path) {
                    return null;
                }

                public boolean checkExpiration(long timeout, boolean reset) {
                    return true;
                }
            });
            Wait.waitFor(() -> !server.isStarted(), (long)500L, (long)10L);
            Assertions.assertTrue((boolean)server.isStarted());
        }
        finally {
            server.stop();
        }
    }
}

