/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQTimeoutException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.AddressSettingsInfo;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.RoleInfo;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.brokerConnectivity.BrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionField;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.management.impl.view.ProducerField;
import org.apache.activemq.artemis.core.management.impl.view.SessionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.ServerLegacyProducersImpl;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.marker.WebServerComponentMarker;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.unit.core.config.impl.fakes.FakeConnectorServiceFactory;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ActiveMQServerControlTest
extends ManagementTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean legacyCreateQueue;
    protected int extraProducers = 0;
    private ActiveMQServer server;
    private Configuration conf;
    private TransportConfiguration connectorConfig;

    @Parameters(name="legacyCreateQueue={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public ActiveMQServerControlTest(boolean legacyCreateQueue) {
        this.legacyCreateQueue = legacyCreateQueue;
    }

    private static boolean contains(String name, String[] strings) {
        boolean found = false;
        for (String str : strings) {
            if (!name.equals(str)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean usingCore() {
        return false;
    }

    @TestTemplate
    public void testGetAttributes() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((Object)this.server.getConfiguration().getName(), (Object)serverControl.getName());
        Assertions.assertEquals((Object)this.server.getVersion().getFullVersion(), (Object)serverControl.getVersion());
        Assertions.assertEquals((Object)this.conf.isClustered(), (Object)serverControl.isClustered());
        Assertions.assertEquals((Object)this.conf.isPersistDeliveryCountBeforeDelivery(), (Object)serverControl.isPersistDeliveryCountBeforeDelivery());
        Assertions.assertEquals((int)this.conf.getScheduledThreadPoolMaxSize(), (int)serverControl.getScheduledThreadPoolMaxSize());
        Assertions.assertEquals((int)this.conf.getThreadPoolMaxSize(), (int)serverControl.getThreadPoolMaxSize());
        Assertions.assertEquals((long)this.conf.getSecurityInvalidationInterval(), (long)serverControl.getSecurityInvalidationInterval());
        Assertions.assertEquals((Object)this.conf.isSecurityEnabled(), (Object)serverControl.isSecurityEnabled());
        Assertions.assertEquals((Object)this.conf.isAsyncConnectionExecutionEnabled(), (Object)serverControl.isAsyncConnectionExecutionEnabled());
        Assertions.assertEquals((int)this.conf.getIncomingInterceptorClassNames().size(), (int)serverControl.getIncomingInterceptorClassNames().length);
        Assertions.assertEquals((int)this.conf.getIncomingInterceptorClassNames().size(), (int)serverControl.getIncomingInterceptorClassNames().length);
        Assertions.assertEquals((int)this.conf.getOutgoingInterceptorClassNames().size(), (int)serverControl.getOutgoingInterceptorClassNames().length);
        Assertions.assertEquals((long)this.conf.getConnectionTTLOverride(), (long)serverControl.getConnectionTTLOverride());
        Assertions.assertEquals((Object)this.conf.getManagementAddress().toString(), (Object)serverControl.getManagementAddress());
        Assertions.assertEquals((Object)this.conf.getManagementNotificationAddress().toString(), (Object)serverControl.getManagementNotificationAddress());
        Assertions.assertEquals((int)this.conf.getIDCacheSize(), (int)serverControl.getIDCacheSize());
        Assertions.assertEquals((Object)this.conf.isPersistIDCache(), (Object)serverControl.isPersistIDCache());
        Assertions.assertEquals((Object)this.conf.getBindingsDirectory(), (Object)serverControl.getBindingsDirectory());
        Assertions.assertEquals((Object)this.conf.getJournalDirectory(), (Object)serverControl.getJournalDirectory());
        Assertions.assertEquals((Object)this.conf.getJournalType().toString(), (Object)serverControl.getJournalType());
        Assertions.assertEquals((Object)this.conf.isJournalSyncTransactional(), (Object)serverControl.isJournalSyncTransactional());
        Assertions.assertEquals((Object)this.conf.isJournalSyncNonTransactional(), (Object)serverControl.isJournalSyncNonTransactional());
        Assertions.assertEquals((int)this.conf.getJournalFileSize(), (int)serverControl.getJournalFileSize());
        Assertions.assertEquals((int)this.conf.getJournalMinFiles(), (int)serverControl.getJournalMinFiles());
        if (LibaioContext.isLoaded()) {
            Assertions.assertEquals((int)this.conf.getJournalMaxIO_AIO(), (int)serverControl.getJournalMaxIO());
            Assertions.assertEquals((int)this.conf.getJournalBufferSize_AIO(), (int)serverControl.getJournalBufferSize());
            Assertions.assertEquals((int)this.conf.getJournalBufferTimeout_AIO(), (int)serverControl.getJournalBufferTimeout());
        }
        Assertions.assertEquals((Object)this.conf.isCreateBindingsDir(), (Object)serverControl.isCreateBindingsDir());
        Assertions.assertEquals((Object)this.conf.isCreateJournalDir(), (Object)serverControl.isCreateJournalDir());
        Assertions.assertEquals((Object)this.conf.getPagingDirectory(), (Object)serverControl.getPagingDirectory());
        Assertions.assertEquals((Object)this.conf.getLargeMessagesDirectory(), (Object)serverControl.getLargeMessagesDirectory());
        Assertions.assertEquals((Object)this.conf.isWildcardRoutingEnabled(), (Object)serverControl.isWildcardRoutingEnabled());
        Assertions.assertEquals((long)this.conf.getTransactionTimeout(), (long)serverControl.getTransactionTimeout());
        Assertions.assertEquals((Object)this.conf.isMessageCounterEnabled(), (Object)serverControl.isMessageCounterEnabled());
        Assertions.assertEquals((long)this.conf.getTransactionTimeoutScanPeriod(), (long)serverControl.getTransactionTimeoutScanPeriod());
        Assertions.assertEquals((long)this.conf.getMessageExpiryScanPeriod(), (long)serverControl.getMessageExpiryScanPeriod());
        Assertions.assertEquals((int)this.conf.getJournalCompactMinFiles(), (int)serverControl.getJournalCompactMinFiles());
        Assertions.assertEquals((int)this.conf.getJournalCompactPercentage(), (int)serverControl.getJournalCompactPercentage());
        Assertions.assertEquals((Object)this.conf.isPersistenceEnabled(), (Object)serverControl.isPersistenceEnabled());
        Assertions.assertEquals((int)this.conf.getJournalPoolFiles(), (int)serverControl.getJournalPoolFiles());
        Assertions.assertTrue((boolean)serverControl.isActive());
    }

    @TestTemplate
    public void testBrokerPluginClassNames() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.conf.registerBrokerPlugin((ActiveMQServerBasePlugin)new TestBrokerPlugin());
        this.conf.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void registered(ActiveMQServer server) {
            }
        });
        Assertions.assertEquals((int)2, (int)this.conf.getBrokerPlugins().size());
        Assertions.assertEquals((int)2, (int)serverControl.getBrokerPluginClassNames().length);
        Assertions.assertEquals((Object)"org.apache.activemq.artemis.tests.integration.management.ActiveMQServerControlTest.TestBrokerPlugin", (Object)serverControl.getBrokerPluginClassNames()[0]);
        Assertions.assertTrue((boolean)Pattern.matches("org.apache.activemq.artemis.tests.integration.management.ActiveMQServerControlTest\\$\\d+$", serverControl.getBrokerPluginClassNames()[1]));
    }

    @TestTemplate
    public void testSecurityCacheSizes() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Wait.assertEquals((long)(this.usingCore() ? 1L : 0L), () -> ((ActiveMQServerControl)serverControl).getAuthenticationCacheSize());
        Wait.assertEquals((long)0L, () -> ((ActiveMQServerControl)serverControl).getAuthorizationCacheSize());
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession session = csf.createSession("myUser", "myPass", false, true, false, false, 0);
        session.start();
        String address = "ADDRESS";
        serverControl.createAddress("ADDRESS", "MULTICAST");
        ClientProducer producer = session.createProducer("ADDRESS");
        ClientMessage m = session.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        Assertions.assertEquals((long)(this.usingCore() ? 2L : 1L), (long)serverControl.getAuthenticationCacheSize());
        Wait.assertEquals((long)1L, () -> serverControl.getAuthorizationCacheSize());
    }

    @TestTemplate
    public void testCurrentTime() throws Exception {
        long time = System.currentTimeMillis();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertTrue((serverControl.getCurrentTimeMillis() >= time ? (byte)1 : 0) != 0, (String)"serverControl returned an invalid time.");
    }

    @TestTemplate
    public void testClearingSecurityCaches() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession session = csf.createSession("myUser", "myPass", false, true, false, false, 0);
        session.start();
        String address = "ADDRESS";
        serverControl.createAddress("ADDRESS", "MULTICAST");
        ClientProducer producer = session.createProducer("ADDRESS");
        ClientMessage m = session.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        Assertions.assertTrue((serverControl.getAuthenticationCacheSize() > 0L ? (byte)1 : 0) != 0);
        Wait.assertTrue(() -> serverControl.getAuthorizationCacheSize() > 0L);
        serverControl.clearAuthenticationCache();
        serverControl.clearAuthorizationCache();
        Assertions.assertEquals((long)(this.usingCore() ? 1L : 0L), (long)serverControl.getAuthenticationCacheSize());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthorizationCacheSize());
    }

    @TestTemplate
    public void testAuthCounts() throws Exception {
        Assumptions.assumeFalse((boolean)this.usingCore());
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthenticationSuccessCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthenticationFailureCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthorizationSuccessCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthorizationFailureCount());
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession successSession = csf.createSession("myUser", "myPass", false, true, false, false, 0);
        successSession.start();
        String address = "ADDRESS";
        serverControl.createAddress("ADDRESS", "MULTICAST");
        ClientProducer producer = successSession.createProducer("ADDRESS");
        ClientMessage m = successSession.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthenticationSuccessCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthenticationFailureCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthorizationSuccessCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthorizationFailureCount());
        String queue = "QUEUE";
        this.server.createQueue(QueueConfiguration.of((String)"QUEUE").setAddress("ADDRESS").setRoutingType(RoutingType.MULTICAST));
        ClientSession failedAuthzSession = csf.createSession("none", "none", false, true, false, false, 0);
        try {
            failedAuthzSession.createConsumer("QUEUE");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
            // empty catch block
        }
        Assertions.assertEquals((long)2L, (long)serverControl.getAuthenticationSuccessCount());
        Assertions.assertEquals((long)0L, (long)serverControl.getAuthenticationFailureCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthorizationSuccessCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthorizationFailureCount());
        try {
            csf.createSession("none", "badpassword", false, true, false, false, 0);
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
            // empty catch block
        }
        Assertions.assertEquals((long)2L, (long)serverControl.getAuthenticationSuccessCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthenticationFailureCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthorizationSuccessCount());
        Assertions.assertEquals((long)1L, (long)serverControl.getAuthorizationFailureCount());
    }

    @TestTemplate
    public void testGetConnectors() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Object[] connectorData = serverControl.getConnectors();
        Assertions.assertNotNull((Object)connectorData);
        Assertions.assertEquals((int)1, (int)connectorData.length);
        Object[] config = (Object[])connectorData[0];
        Assertions.assertEquals((Object)this.connectorConfig.getName(), (Object)config[0]);
    }

    @TestTemplate
    public void testGetAcceptors() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Object[] acceptors = serverControl.getAcceptors();
        Assertions.assertNotNull((Object)acceptors);
        Assertions.assertEquals((int)2, (int)acceptors.length);
        for (int i = 0; i < acceptors.length; ++i) {
            Object[] acceptor = (Object[])acceptors[i];
            String name = (String)acceptor[0];
            Assertions.assertTrue((name.equals("netty") || name.equals("invm") ? (byte)1 : 0) != 0);
        }
    }

    @TestTemplate
    public void testIsReplicaSync() throws Exception {
        Assertions.assertFalse((boolean)this.createManagementControl().isReplicaSync());
    }

    @TestTemplate
    public void testGetConnectorsAsJSON() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String jsonString = serverControl.getConnectorsAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        JsonObject data = array.getJsonObject(0);
        Assertions.assertEquals((Object)this.connectorConfig.getName(), (Object)data.getString("name"));
        Assertions.assertEquals((Object)this.connectorConfig.getFactoryClassName(), (Object)data.getString("factoryClassName"));
        Assertions.assertEquals((int)this.connectorConfig.getParams().size(), (int)data.getJsonObject("params").size());
    }

    @TestTemplate
    public void testGetAcceptorsAsJSON() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String jsonString = serverControl.getAcceptorsAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)2, (int)array.size());
        for (int i = 0; i < array.size(); ++i) {
            String name = ((JsonObject)array.get(i)).getString("name");
            Assertions.assertTrue((name.equals("netty") || name.equals("invm") ? (byte)1 : 0) != 0);
        }
    }

    @TestTemplate
    public void testCreateAndDestroyQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertTrue((boolean)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateQueueWithNullAddress() throws Exception {
        SimpleString address;
        SimpleString name = address = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(null, name.toString(), "ANYCAST");
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(name, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertTrue((boolean)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndDestroyQueue_2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = "color = 'green'";
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertEquals((Object)filter, (Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndDestroyQueue_3() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndDestroyQueue_4() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        boolean purgeOnNoConsumers = RandomUtil.randomBoolean();
        boolean autoCreateAddress = true;
        int maxConsumers = RandomUtil.randomInt();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), name.toString(), null, durable, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setAutoCreateAddress(Boolean.valueOf(autoCreateAddress)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertEquals((Object)purgeOnNoConsumers, (Object)queueControl.isPurgeOnNoConsumers());
        Assertions.assertEquals((int)maxConsumers, (int)queueControl.getMaxConsumers());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        this.checkResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        serverControl.destroyQueue(name.toString(), true, true);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
    }

    @TestTemplate
    public void testCreateAndDestroyQueue_5() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = RandomUtil.randomBoolean();
        int maxConsumers = RandomUtil.randomInt();
        boolean purgeOnNoConsumers = RandomUtil.randomBoolean();
        boolean exclusive = RandomUtil.randomBoolean();
        boolean groupRebalance = RandomUtil.randomBoolean();
        int groupBuckets = 1;
        String groupFirstKey = RandomUtil.randomSimpleString().toString();
        boolean lastValue = false;
        String lastValueKey = null;
        boolean nonDestructive = RandomUtil.randomBoolean();
        int consumersBeforeDispatch = RandomUtil.randomInt();
        long delayBeforeDispatch = RandomUtil.randomLong();
        boolean autoDelete = RandomUtil.randomBoolean();
        long autoDeleteDelay = RandomUtil.randomLong();
        long autoDeleteMessageCount = RandomUtil.randomLong();
        boolean autoCreateAddress = true;
        long ringSize = RandomUtil.randomLong();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), name.toString(), null, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, ringSize);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setExclusive(Boolean.valueOf(exclusive)).setGroupRebalance(Boolean.valueOf(groupRebalance)).setGroupBuckets(Integer.valueOf(groupBuckets)).setGroupFirstKey(groupFirstKey).setLastValue(Boolean.valueOf(lastValue)).setLastValueKey(lastValueKey).setNonDestructive(Boolean.valueOf(nonDestructive)).setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(autoDelete)).setAutoDeleteDelay(Long.valueOf(autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(autoDeleteMessageCount)).setRingSize(Long.valueOf(ringSize)).setAutoCreateAddress(Boolean.valueOf(autoCreateAddress)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertEquals((int)maxConsumers, (int)queueControl.getMaxConsumers());
        Assertions.assertEquals((Object)purgeOnNoConsumers, (Object)queueControl.isPurgeOnNoConsumers());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        Assertions.assertEquals((Object)exclusive, (Object)queueControl.isExclusive());
        Assertions.assertEquals((Object)groupRebalance, (Object)queueControl.isGroupRebalance());
        Assertions.assertEquals((int)groupBuckets, (int)queueControl.getGroupBuckets());
        Assertions.assertEquals((Object)groupFirstKey, (Object)queueControl.getGroupFirstKey());
        Assertions.assertEquals((Object)lastValue, (Object)queueControl.isLastValue());
        Assertions.assertEquals((long)ringSize, (long)queueControl.getRingSize());
        this.checkResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
        AddressControl addressControl = ManagementControlHelper.createAddressControl(address, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        serverControl.destroyQueue(name.toString(), true, true);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
    }

    @TestTemplate
    public void testCreateAndDestroyQueueWithAutoDeleteAddress() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(false)));
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertTrue((boolean)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString(), false, true);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getAddressObjectName(address));
    }

    @TestTemplate
    public void testRemoveQueueFilter() throws Exception {
        String address = RandomUtil.randomString();
        QueueConfiguration queue1 = QueueConfiguration.of((String)"q1").setAddress(address).setFilterString("hello='world'");
        QueueConfiguration queue2 = QueueConfiguration.of((String)"q2").setAddress(address).setFilterString("hello='darling'");
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.createAddress(address, "MULTICAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address, queue1.getName().toString(), queue1.getFilterString().toString(), queue1.isDurable().booleanValue());
            serverControl.createQueue(address, queue2.getName().toString(), queue2.getFilterString().toString(), queue2.isDurable().booleanValue());
        } else {
            serverControl.createQueue(queue1.toJSON());
            serverControl.createQueue(queue2.toJSON());
        }
        ServerLocator loc = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(loc);
        ClientSession session = csf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(address);
        ClientConsumer consumer1 = session.createConsumer("q1");
        ClientConsumer consumer2 = session.createConsumer("q2");
        ClientMessage m = session.createMessage(true);
        m.putStringProperty("hello", "world");
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        Assertions.assertNotNull((Object)consumer1.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        serverControl.updateQueue(queue2.setFilterString((String)null).toJSON());
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        Assertions.assertNotNull((Object)consumer1.receive(1000L));
        Assertions.assertNotNull((Object)consumer2.receive(1000L));
    }

    @TestTemplate
    public void testCreateAndDestroyQueueClosingConsumers() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer consumer = receiveClientSession.createConsumer(name);
        Assertions.assertFalse((boolean)consumer.isClosed());
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.destroyQueue(name.toString(), true);
        Wait.waitFor(() -> consumer.isClosed(), (long)1000L, (long)100L);
        Assertions.assertTrue((boolean)consumer.isClosed());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndDestroyQueueWithNullFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = null;
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndDestroyQueueWithEmptyStringForFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        String filter = "";
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), filter, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        this.checkResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((Object)durable, (Object)queueControl.isDurable());
        Assertions.assertFalse((boolean)queueControl.isTemporary());
        serverControl.destroyQueue(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testCreateAndUpdateQueueWithoutFilter() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)).setFilterString((String)null).toJSON());
        serverControl.updateQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).toJSON());
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertNull((Object)queueControl.getFilter());
        Assertions.assertEquals((int)1, (int)queueControl.getMaxConsumers());
        serverControl.destroyQueue(name.toString());
    }

    @TestTemplate
    public void testCreateAndLegacyUpdateQueueRingSize() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)).toJSON());
        serverControl.updateQueue(name.toString(), RoutingType.ANYCAST.toString(), null, null, null, null, null, null, null, null, null, null, null, Long.valueOf(101L));
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, name, RoutingType.ANYCAST, this.mbeanServer);
        Assertions.assertEquals((Object)address.toString(), (Object)queueControl.getAddress());
        Assertions.assertEquals((Object)name.toString(), (Object)queueControl.getName());
        Assertions.assertEquals((long)101L, (long)queueControl.getRingSize());
        serverControl.destroyQueue(name.toString());
    }

    @TestTemplate
    public void testGetQueueCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        int countBeforeCreate = serverControl.getQueueCount();
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        Assertions.assertTrue((countBeforeCreate < serverControl.getQueueCount() ? (byte)1 : 0) != 0);
        serverControl.destroyQueue(name.toString());
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
    }

    @TestTemplate
    public void testGetQueueNames() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
        serverControl.destroyQueue(name.toString());
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(name.toString(), serverControl.getQueueNames()));
    }

    @TestTemplate
    public void testGetQueueNamesWithRoutingType() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString anycastName = RandomUtil.randomSimpleString();
        SimpleString multicastName = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames()));
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames()));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.ANYCAST.toString(), anycastName.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)anycastName).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames(RoutingType.ANYCAST.toString())));
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames(RoutingType.MULTICAST.toString())));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), RoutingType.MULTICAST.toString(), multicastName.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)multicastName).setAddress(address).setRoutingType(RoutingType.MULTICAST).toJSON());
        }
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames(RoutingType.MULTICAST.toString())));
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames(RoutingType.ANYCAST.toString())));
        serverControl.destroyQueue(anycastName.toString());
        serverControl.destroyQueue(multicastName.toString());
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(anycastName.toString(), serverControl.getQueueNames()));
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(multicastName.toString(), serverControl.getQueueNames()));
    }

    @TestTemplate
    public void testGetClusterConnectionNames() throws Exception {
        String clusterConnection1 = RandomUtil.randomString();
        String clusterConnection2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(clusterConnection1, serverControl.getClusterConnectionNames()));
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(clusterConnection2, serverControl.getClusterConnectionNames()));
        this.server.stop();
        this.server.getConfiguration().addClusterConfiguration(new ClusterConnectionConfiguration().setName(clusterConnection1).setConnectorName(this.connectorConfig.getName())).addClusterConfiguration(new ClusterConnectionConfiguration().setName(clusterConnection2).setConnectorName(this.connectorConfig.getName()));
        this.server.start();
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(clusterConnection1, serverControl.getClusterConnectionNames()));
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(clusterConnection2, serverControl.getClusterConnectionNames()));
    }

    @TestTemplate
    public void testGetAddressCount() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        int countBeforeCreate = serverControl.getAddressCount();
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assertions.assertTrue((countBeforeCreate < serverControl.getAddressCount() ? (byte)1 : 0) != 0);
        serverControl.destroyQueue(name.toString(), true, true);
        Wait.assertFalse(() -> ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @TestTemplate
    public void testGetAddressNames() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, true, -1, false, true);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).toJSON());
        }
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        serverControl.destroyQueue(name.toString(), true, true);
        Wait.assertFalse(() -> ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @TestTemplate
    public void testGetAddressDeletedFromJournal() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        serverControl.createAddress(address.toString(), "ANYCAST");
        Assertions.assertTrue((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
        this.restartServer();
        serverControl.deleteAddress(address.toString());
        this.restartServer();
        Assertions.assertFalse((boolean)ActiveMQServerControlTest.contains(address.toString(), serverControl.getAddressNames()));
    }

    @TestTemplate
    public void testMessageCounterMaxDayCount() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((int)MessageCounterManagerImpl.DEFAULT_MAX_DAY_COUNT, (int)serverControl.getMessageCounterMaxDayCount());
        int newCount = 100;
        serverControl.setMessageCounterMaxDayCount(newCount);
        Assertions.assertEquals((int)newCount, (int)serverControl.getMessageCounterMaxDayCount());
        try {
            serverControl.setMessageCounterMaxDayCount(-1);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverControl.setMessageCounterMaxDayCount(0);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((int)newCount, (int)serverControl.getMessageCounterMaxDayCount());
    }

    @TestTemplate
    public void testGetMessageCounterSamplePeriod() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((long)MessageCounterManagerImpl.DEFAULT_SAMPLE_PERIOD, (long)serverControl.getMessageCounterSamplePeriod());
        long newSample = 20000L;
        serverControl.setMessageCounterSamplePeriod(newSample);
        Assertions.assertEquals((long)newSample, (long)serverControl.getMessageCounterSamplePeriod());
        try {
            serverControl.setMessageCounterSamplePeriod(-1L);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serverControl.setMessageCounterSamplePeriod(0L);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serverControl.setMessageCounterSamplePeriod(999L);
        Assertions.assertEquals((long)999L, (long)serverControl.getMessageCounterSamplePeriod());
    }

    protected void restartServer() throws Exception {
        this.server.stop();
        this.server.start();
    }

    @TestTemplate
    public void testSecuritySettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addressMatch = "test.#";
        String exactAddress = "test.whatever";
        Assertions.assertEquals((int)2, (int)serverControl.getRoles(addressMatch).length);
        serverControl.addSecuritySettings(addressMatch, "foo", "foo, bar", null, "bar", "foo, bar", "", "", "bar", "foo", "foo", "", "");
        this.restartServer();
        serverControl = this.createManagementControl();
        String rolesAsJSON = serverControl.getRolesAsJSON(exactAddress);
        RoleInfo[] roleInfos = RoleInfo.from((String)rolesAsJSON);
        Assertions.assertEquals((int)2, (int)roleInfos.length);
        RoleInfo fooRoleInfo = null;
        RoleInfo barRoleInfo = null;
        if ("foo".equals(roleInfos[0].getName())) {
            fooRoleInfo = roleInfos[0];
            barRoleInfo = roleInfos[1];
        } else {
            fooRoleInfo = roleInfos[1];
            barRoleInfo = roleInfos[0];
        }
        Assertions.assertTrue((boolean)fooRoleInfo.isSend());
        Assertions.assertTrue((boolean)fooRoleInfo.isConsume());
        Assertions.assertFalse((boolean)fooRoleInfo.isCreateDurableQueue());
        Assertions.assertFalse((boolean)fooRoleInfo.isDeleteDurableQueue());
        Assertions.assertTrue((boolean)fooRoleInfo.isCreateNonDurableQueue());
        Assertions.assertFalse((boolean)fooRoleInfo.isDeleteNonDurableQueue());
        Assertions.assertFalse((boolean)fooRoleInfo.isManage());
        Assertions.assertFalse((boolean)fooRoleInfo.isBrowse());
        Assertions.assertTrue((boolean)fooRoleInfo.isCreateAddress());
        Assertions.assertTrue((boolean)fooRoleInfo.isDeleteAddress());
        Assertions.assertFalse((boolean)barRoleInfo.isSend());
        Assertions.assertTrue((boolean)barRoleInfo.isConsume());
        Assertions.assertFalse((boolean)barRoleInfo.isCreateDurableQueue());
        Assertions.assertTrue((boolean)barRoleInfo.isDeleteDurableQueue());
        Assertions.assertTrue((boolean)barRoleInfo.isCreateNonDurableQueue());
        Assertions.assertFalse((boolean)barRoleInfo.isDeleteNonDurableQueue());
        Assertions.assertFalse((boolean)barRoleInfo.isManage());
        Assertions.assertTrue((boolean)barRoleInfo.isBrowse());
        Assertions.assertFalse((boolean)barRoleInfo.isCreateAddress());
        Assertions.assertFalse((boolean)barRoleInfo.isDeleteAddress());
        Object[] roles = serverControl.getRoles(exactAddress);
        Assertions.assertEquals((int)2, (int)roles.length);
        Object[] fooRole = null;
        Object[] barRole = null;
        if ("foo".equals(((Object[])roles[0])[0])) {
            fooRole = (Object[])roles[0];
            barRole = (Object[])roles[1];
        } else {
            fooRole = (Object[])roles[1];
            barRole = (Object[])roles[0];
        }
        Assertions.assertEquals((int)(CheckType.values().length + 1), (int)fooRole.length);
        Assertions.assertEquals((int)(CheckType.values().length + 1), (int)barRole.length);
        Assertions.assertTrue((boolean)((Boolean)fooRole[1]));
        Assertions.assertTrue((boolean)((Boolean)fooRole[2]));
        Assertions.assertFalse((boolean)((Boolean)fooRole[3]));
        Assertions.assertFalse((boolean)((Boolean)fooRole[4]));
        Assertions.assertTrue((boolean)((Boolean)fooRole[5]));
        Assertions.assertFalse((boolean)((Boolean)fooRole[6]));
        Assertions.assertFalse((boolean)((Boolean)fooRole[7]));
        Assertions.assertFalse((boolean)((Boolean)fooRole[8]));
        Assertions.assertTrue((boolean)((Boolean)fooRole[9]));
        Assertions.assertTrue((boolean)((Boolean)fooRole[10]));
        Assertions.assertFalse((boolean)((Boolean)barRole[1]));
        Assertions.assertTrue((boolean)((Boolean)barRole[2]));
        Assertions.assertFalse((boolean)((Boolean)barRole[3]));
        Assertions.assertTrue((boolean)((Boolean)barRole[4]));
        Assertions.assertTrue((boolean)((Boolean)barRole[5]));
        Assertions.assertFalse((boolean)((Boolean)barRole[6]));
        Assertions.assertFalse((boolean)((Boolean)barRole[7]));
        Assertions.assertTrue((boolean)((Boolean)barRole[8]));
        Assertions.assertFalse((boolean)((Boolean)barRole[9]));
        Assertions.assertFalse((boolean)((Boolean)barRole[10]));
        serverControl.removeSecuritySettings(addressMatch);
        Assertions.assertEquals((int)2, (int)serverControl.getRoles(exactAddress).length);
    }

    @TestTemplate
    public void mergeAddressSettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(SimpleString.of((String)"DLA"));
        String returnedSettings = serverControl.addAddressSettings("foo", addressSettings.toJSON());
        AddressSettings info = AddressSettings.fromJSON((String)returnedSettings);
        Assertions.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)info.getDeadLetterAddress());
        Assertions.assertNull((Object)info.getExpiryAddress());
        Assertions.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)0L);
        addressSettings.setExpiryAddress(SimpleString.of((String)"EA"));
        returnedSettings = serverControl.addAddressSettings("foo", addressSettings.toJSON());
        info = AddressSettings.fromJSON((String)returnedSettings);
        Assertions.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)info.getExpiryAddress());
        addressSettings.setRedeliveryDelay(1000L);
        returnedSettings = serverControl.addAddressSettings("foo", addressSettings.toJSON());
        info = AddressSettings.fromJSON((String)returnedSettings);
        Assertions.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)info.getExpiryAddress());
        Assertions.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)info.getRedeliveryDelay());
        addressSettings.setInitialQueueBufferSize(64);
        returnedSettings = serverControl.addAddressSettings("foo", addressSettings.toJSON());
        info = AddressSettings.fromJSON((String)returnedSettings);
        Assertions.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)info.getExpiryAddress());
        Assertions.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)info.getRedeliveryDelay());
        Assertions.assertEquals((Integer)addressSettings.getInitialQueueBufferSize(), (Integer)info.getInitialQueueBufferSize());
    }

    @TestTemplate
    public void emptyAddressSettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        AddressSettings addressSettings = new AddressSettings();
        String returnedSettings = serverControl.addAddressSettings("foo", addressSettings.toJSON());
        AddressSettings info = AddressSettings.fromJSON((String)returnedSettings);
        Assertions.assertEquals((Object)addressSettings.getDeadLetterAddress(), (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)addressSettings.getExpiryAddress(), (Object)info.getExpiryAddress());
        Assertions.assertEquals((Long)addressSettings.getExpiryDelay(), (Long)info.getExpiryDelay());
        Assertions.assertEquals((Long)addressSettings.getMinExpiryDelay(), (Long)info.getMinExpiryDelay());
        Assertions.assertEquals((Long)addressSettings.getMaxExpiryDelay(), (Long)info.getMaxExpiryDelay());
        Assertions.assertEquals((Object)addressSettings.isDefaultLastValueQueue(), (Object)info.isDefaultLastValueQueue());
        Assertions.assertEquals((int)addressSettings.getMaxDeliveryAttempts(), (int)info.getMaxDeliveryAttempts());
        Assertions.assertEquals((long)addressSettings.getMaxSizeBytes(), (long)info.getMaxSizeBytes());
        Assertions.assertEquals((int)addressSettings.getPageCacheMaxSize(), (int)info.getPageCacheMaxSize());
        Assertions.assertEquals((int)addressSettings.getPageSizeBytes(), (int)info.getPageSizeBytes());
        Assertions.assertEquals((long)addressSettings.getRedeliveryDelay(), (long)info.getRedeliveryDelay());
        Assertions.assertEquals((double)addressSettings.getRedeliveryMultiplier(), (double)info.getRedeliveryMultiplier(), (double)1.0E-6);
        Assertions.assertEquals((long)addressSettings.getMaxRedeliveryDelay(), (long)info.getMaxRedeliveryDelay());
        Assertions.assertEquals((long)addressSettings.getRedistributionDelay(), (long)info.getRedistributionDelay());
        Assertions.assertEquals((Object)addressSettings.isSendToDLAOnNoRoute(), (Object)info.isSendToDLAOnNoRoute());
        Assertions.assertEquals((Object)addressSettings.getAddressFullMessagePolicy(), (Object)info.getAddressFullMessagePolicy());
        Assertions.assertEquals((long)addressSettings.getSlowConsumerThreshold(), (long)info.getSlowConsumerThreshold());
        Assertions.assertEquals((long)addressSettings.getSlowConsumerCheckPeriod(), (long)info.getSlowConsumerCheckPeriod());
        Assertions.assertEquals((Object)addressSettings.getSlowConsumerPolicy(), (Object)info.getSlowConsumerPolicy());
        Assertions.assertEquals((Object)addressSettings.isAutoCreateQueues(), (Object)info.isAutoCreateQueues());
        Assertions.assertEquals((Object)addressSettings.isAutoDeleteQueues(), (Object)info.isAutoDeleteQueues());
        Assertions.assertEquals((Object)addressSettings.isAutoCreateAddresses(), (Object)info.isAutoCreateAddresses());
        Assertions.assertEquals((Object)addressSettings.isAutoDeleteAddresses(), (Object)info.isAutoDeleteAddresses());
        Assertions.assertEquals((Object)addressSettings.getConfigDeleteQueues(), (Object)info.getConfigDeleteQueues());
        Assertions.assertEquals((Object)addressSettings.getConfigDeleteAddresses(), (Object)info.getConfigDeleteAddresses());
        Assertions.assertEquals((long)addressSettings.getMaxSizeBytesRejectThreshold(), (long)info.getMaxSizeBytesRejectThreshold());
        Assertions.assertEquals((Object)addressSettings.getDefaultLastValueKey(), (Object)info.getDefaultLastValueKey());
        Assertions.assertEquals((Object)addressSettings.isDefaultNonDestructive(), (Object)info.isDefaultNonDestructive());
        Assertions.assertEquals((Object)addressSettings.isDefaultExclusiveQueue(), (Object)info.isDefaultExclusiveQueue());
        Assertions.assertEquals((Object)addressSettings.isDefaultGroupRebalance(), (Object)info.isDefaultGroupRebalance());
        Assertions.assertEquals((int)addressSettings.getDefaultGroupBuckets(), (int)info.getDefaultGroupBuckets());
        Assertions.assertEquals((Object)addressSettings.getDefaultGroupFirstKey(), (Object)info.getDefaultGroupFirstKey());
        Assertions.assertEquals((Integer)addressSettings.getDefaultMaxConsumers(), (Integer)info.getDefaultMaxConsumers());
        Assertions.assertEquals((Object)addressSettings.isDefaultPurgeOnNoConsumers(), (Object)info.isDefaultPurgeOnNoConsumers());
        Assertions.assertEquals((Integer)addressSettings.getDefaultConsumersBeforeDispatch(), (Integer)info.getDefaultConsumersBeforeDispatch());
        Assertions.assertEquals((Long)addressSettings.getDefaultDelayBeforeDispatch(), (Long)info.getDefaultDelayBeforeDispatch());
        Assertions.assertEquals((Object)addressSettings.getDefaultQueueRoutingType(), (Object)info.getDefaultQueueRoutingType());
        Assertions.assertEquals((Object)addressSettings.getDefaultAddressRoutingType(), (Object)info.getDefaultAddressRoutingType());
        Assertions.assertEquals((int)addressSettings.getDefaultConsumerWindowSize(), (int)info.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)addressSettings.getDefaultRingSize(), (long)info.getDefaultRingSize());
        Assertions.assertEquals((Object)addressSettings.isAutoDeleteCreatedQueues(), (Object)info.isAutoDeleteCreatedQueues());
        Assertions.assertEquals((long)addressSettings.getAutoDeleteQueuesDelay(), (long)info.getAutoDeleteQueuesDelay());
        Assertions.assertEquals((long)addressSettings.getAutoDeleteQueuesMessageCount(), (long)info.getAutoDeleteQueuesMessageCount());
        Assertions.assertEquals((long)addressSettings.getAutoDeleteAddressesDelay(), (long)info.getAutoDeleteAddressesDelay());
        Assertions.assertEquals((double)addressSettings.getRedeliveryCollisionAvoidanceFactor(), (double)info.getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        Assertions.assertEquals((long)addressSettings.getRetroactiveMessageCount(), (long)info.getRetroactiveMessageCount());
        Assertions.assertEquals((Object)addressSettings.isAutoCreateDeadLetterResources(), (Object)info.isAutoCreateDeadLetterResources());
        Assertions.assertEquals((Object)addressSettings.getDeadLetterQueuePrefix(), (Object)info.getDeadLetterQueuePrefix());
        Assertions.assertEquals((Object)addressSettings.getDeadLetterQueueSuffix(), (Object)info.getDeadLetterQueueSuffix());
        Assertions.assertEquals((Object)addressSettings.isAutoCreateExpiryResources(), (Object)info.isAutoCreateExpiryResources());
        Assertions.assertEquals((Object)addressSettings.getExpiryQueuePrefix(), (Object)info.getExpiryQueuePrefix());
        Assertions.assertEquals((Object)addressSettings.getExpiryQueueSuffix(), (Object)info.getExpiryQueueSuffix());
        Assertions.assertEquals((Object)addressSettings.isEnableMetrics(), (Object)info.isEnableMetrics());
        Assertions.assertEquals((Integer)addressSettings.getInitialQueueBufferSize(), (Integer)info.getInitialQueueBufferSize());
    }

    @TestTemplate
    public void testAddressSettings() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addressMatch = "test.#";
        String exactAddress = "test.whatever";
        String DLA = "someDLA";
        String expiryAddress = "someExpiry";
        long expiryDelay = RandomUtil.randomPositiveLong();
        long minExpiryDelay = RandomUtil.randomPositiveLong();
        long maxExpiryDelay = RandomUtil.randomPositiveLong();
        boolean lastValueQueue = true;
        int deliveryAttempts = 1;
        long maxSizeBytes = 20L;
        int pageSizeBytes = 10;
        int pageMaxCacheSize = 7;
        long redeliveryDelay = 4L;
        double redeliveryMultiplier = 1.0;
        long maxRedeliveryDelay = 1000L;
        long redistributionDelay = 5L;
        boolean sendToDLAOnNoRoute = true;
        String addressFullMessagePolicy = "PAGE";
        long slowConsumerThreshold = 5L;
        long slowConsumerCheckPeriod = 10L;
        String slowConsumerPolicy = SlowConsumerPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        boolean autoCreateQueues = RandomUtil.randomBoolean();
        boolean autoDeleteQueues = RandomUtil.randomBoolean();
        boolean autoCreateAddresses = RandomUtil.randomBoolean();
        boolean autoDeleteAddresses = RandomUtil.randomBoolean();
        String configDeleteQueues = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        String configDeleteAddresses = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        long maxSizeBytesRejectThreshold = RandomUtil.randomPositiveLong();
        String defaultLastValueKey = RandomUtil.randomString();
        boolean defaultNonDestructive = RandomUtil.randomBoolean();
        boolean defaultExclusiveQueue = RandomUtil.randomBoolean();
        boolean defaultGroupRebalance = RandomUtil.randomBoolean();
        int defaultGroupBuckets = RandomUtil.randomPositiveInt();
        String defaultGroupFirstKey = RandomUtil.randomString();
        int defaultMaxConsumers = RandomUtil.randomPositiveInt();
        boolean defaultPurgeOnNoConsumers = RandomUtil.randomBoolean();
        int defaultConsumersBeforeDispatch = RandomUtil.randomPositiveInt();
        long defaultDelayBeforeDispatch = RandomUtil.randomPositiveLong();
        String defaultQueueRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        String defaultAddressRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        int defaultConsumerWindowSize = RandomUtil.randomPositiveInt();
        long defaultRingSize = RandomUtil.randomPositiveLong();
        boolean autoDeleteCreatedQueues = RandomUtil.randomBoolean();
        long autoDeleteQueuesDelay = RandomUtil.randomPositiveLong();
        long autoDeleteQueuesMessageCount = RandomUtil.randomPositiveLong();
        long autoDeleteAddressesDelay = RandomUtil.randomPositiveLong();
        double redeliveryCollisionAvoidanceFactor = RandomUtil.randomDouble();
        long retroactiveMessageCount = RandomUtil.randomPositiveLong();
        boolean autoCreateDeadLetterResources = RandomUtil.randomBoolean();
        String deadLetterQueuePrefix = RandomUtil.randomString();
        String deadLetterQueueSuffix = RandomUtil.randomString();
        boolean autoCreateExpiryResources = RandomUtil.randomBoolean();
        String expiryQueuePrefix = RandomUtil.randomString();
        String expiryQueueSuffix = RandomUtil.randomString();
        boolean enableMetrics = RandomUtil.randomBoolean();
        int initialQueueBufferSize = (int)Math.pow(2.0, 14.0);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(SimpleString.of((String)DLA)).setExpiryAddress(SimpleString.of((String)expiryAddress)).setExpiryDelay(Long.valueOf(expiryDelay)).setDefaultLastValueQueue(lastValueQueue).setMaxDeliveryAttempts(deliveryAttempts).setMaxSizeBytes(maxSizeBytes).setPageSizeBytes(pageSizeBytes).setPageCacheMaxSize(pageMaxCacheSize).setRedeliveryDelay(redeliveryDelay).setRedeliveryMultiplier(redeliveryMultiplier).setMaxRedeliveryDelay(maxRedeliveryDelay).setRedistributionDelay(redistributionDelay).setSendToDLAOnNoRoute(sendToDLAOnNoRoute).setAddressFullMessagePolicy(AddressFullMessagePolicy.valueOf((String)addressFullMessagePolicy)).setSlowConsumerThreshold(slowConsumerThreshold).setSlowConsumerCheckPeriod(slowConsumerCheckPeriod).setSlowConsumerPolicy(SlowConsumerPolicy.valueOf((String)slowConsumerPolicy)).setAutoCreateQueues(Boolean.valueOf(autoCreateQueues)).setAutoDeleteQueues(Boolean.valueOf(autoDeleteQueues)).setAutoCreateAddresses(Boolean.valueOf(autoCreateAddresses)).setAutoDeleteAddresses(Boolean.valueOf(autoDeleteAddresses)).setConfigDeleteQueues(DeletionPolicy.valueOf((String)configDeleteQueues)).setConfigDeleteAddresses(DeletionPolicy.valueOf((String)configDeleteAddresses)).setMaxSizeBytesRejectThreshold(maxSizeBytesRejectThreshold).setDefaultLastValueKey(SimpleString.of((String)defaultLastValueKey)).setDefaultNonDestructive(defaultNonDestructive).setDefaultExclusiveQueue(Boolean.valueOf(defaultExclusiveQueue)).setDefaultGroupRebalance(defaultGroupRebalance).setDefaultGroupBuckets(defaultGroupBuckets).setDefaultGroupFirstKey(SimpleString.of((String)defaultGroupFirstKey)).setDefaultMaxConsumers(Integer.valueOf(defaultMaxConsumers)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(defaultPurgeOnNoConsumers)).setDefaultConsumersBeforeDispatch(Integer.valueOf(defaultConsumersBeforeDispatch)).setDefaultDelayBeforeDispatch(Long.valueOf(defaultDelayBeforeDispatch)).setDefaultQueueRoutingType(RoutingType.valueOf((String)defaultQueueRoutingType)).setDefaultAddressRoutingType(RoutingType.valueOf((String)defaultAddressRoutingType)).setDefaultConsumerWindowSize(defaultConsumerWindowSize).setDefaultRingSize(defaultRingSize).setAutoDeleteCreatedQueues(Boolean.valueOf(autoDeleteCreatedQueues)).setAutoDeleteQueuesDelay(autoDeleteQueuesDelay).setAutoDeleteQueuesMessageCount(autoDeleteQueuesMessageCount).setAutoDeleteAddressesDelay(autoDeleteAddressesDelay).setRedeliveryCollisionAvoidanceFactor(redeliveryCollisionAvoidanceFactor).setRetroactiveMessageCount(retroactiveMessageCount).setAutoCreateDeadLetterResources(autoCreateDeadLetterResources).setDeadLetterQueuePrefix(SimpleString.of((String)deadLetterQueuePrefix)).setDeadLetterQueueSuffix(SimpleString.of((String)deadLetterQueueSuffix)).setAutoCreateExpiryResources(autoCreateExpiryResources).setExpiryQueuePrefix(SimpleString.of((String)expiryQueuePrefix)).setExpiryQueueSuffix(SimpleString.of((String)expiryQueueSuffix)).setMinExpiryDelay(Long.valueOf(minExpiryDelay)).setMaxExpiryDelay(Long.valueOf(maxExpiryDelay)).setEnableMetrics(enableMetrics).setInitialQueueBufferSize(initialQueueBufferSize);
        serverControl.addAddressSettings(addressMatch, addressSettings.toJSON());
        addressSettings.setMaxSizeBytes(100L).setPageSizeBytes(1000);
        boolean ex = false;
        try {
            serverControl.addAddressSettings(addressMatch, addressSettings.toJSON());
        }
        catch (Exception expected) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"Exception expected");
        this.restartServer();
        serverControl = this.createManagementControl();
        String jsonString = serverControl.getAddressSettingsAsJSON(exactAddress);
        AddressSettingsInfo info = AddressSettingsInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((Object)DLA, (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)expiryAddress, (Object)info.getExpiryAddress());
        Assertions.assertEquals((long)expiryDelay, (long)info.getExpiryDelay());
        Assertions.assertEquals((long)minExpiryDelay, (long)info.getMinExpiryDelay());
        Assertions.assertEquals((long)maxExpiryDelay, (long)info.getMaxExpiryDelay());
        Assertions.assertEquals((Object)lastValueQueue, (Object)info.isDefaultLastValueQueue());
        Assertions.assertEquals((int)deliveryAttempts, (int)info.getMaxDeliveryAttempts());
        Assertions.assertEquals((long)maxSizeBytes, (long)info.getMaxSizeBytes());
        Assertions.assertEquals((int)pageMaxCacheSize, (int)info.getPageCacheMaxSize());
        Assertions.assertEquals((int)pageSizeBytes, (int)info.getPageSizeBytes());
        Assertions.assertEquals((long)redeliveryDelay, (long)info.getRedeliveryDelay());
        Assertions.assertEquals((double)redeliveryMultiplier, (double)info.getRedeliveryMultiplier(), (double)1.0E-6);
        Assertions.assertEquals((long)maxRedeliveryDelay, (long)info.getMaxRedeliveryDelay());
        Assertions.assertEquals((long)redistributionDelay, (long)info.getRedistributionDelay());
        Assertions.assertEquals((Object)sendToDLAOnNoRoute, (Object)info.isSendToDLAOnNoRoute());
        Assertions.assertEquals((Object)addressFullMessagePolicy, (Object)info.getAddressFullMessagePolicy());
        Assertions.assertEquals((long)slowConsumerThreshold, (long)info.getSlowConsumerThreshold());
        Assertions.assertEquals((long)slowConsumerCheckPeriod, (long)info.getSlowConsumerCheckPeriod());
        Assertions.assertEquals((Object)slowConsumerPolicy, (Object)info.getSlowConsumerPolicy());
        Assertions.assertEquals((Object)autoCreateQueues, (Object)info.isAutoCreateQueues());
        Assertions.assertEquals((Object)autoDeleteQueues, (Object)info.isAutoDeleteQueues());
        Assertions.assertEquals((Object)autoCreateAddresses, (Object)info.isAutoCreateAddresses());
        Assertions.assertEquals((Object)autoDeleteAddresses, (Object)info.isAutoDeleteAddresses());
        Assertions.assertEquals((Object)configDeleteQueues, (Object)info.getConfigDeleteQueues());
        Assertions.assertEquals((Object)configDeleteAddresses, (Object)info.getConfigDeleteAddresses());
        Assertions.assertEquals((long)maxSizeBytesRejectThreshold, (long)info.getMaxSizeBytesRejectThreshold());
        Assertions.assertEquals((Object)defaultLastValueKey, (Object)info.getDefaultLastValueKey());
        Assertions.assertEquals((Object)defaultNonDestructive, (Object)info.isDefaultNonDestructive());
        Assertions.assertEquals((Object)defaultExclusiveQueue, (Object)info.isDefaultExclusiveQueue());
        Assertions.assertEquals((Object)defaultGroupRebalance, (Object)info.isDefaultGroupRebalance());
        Assertions.assertEquals((int)defaultGroupBuckets, (int)info.getDefaultGroupBuckets());
        Assertions.assertEquals((Object)defaultGroupFirstKey, (Object)info.getDefaultGroupFirstKey());
        Assertions.assertEquals((int)defaultMaxConsumers, (int)info.getDefaultMaxConsumers());
        Assertions.assertEquals((Object)defaultPurgeOnNoConsumers, (Object)info.isDefaultPurgeOnNoConsumers());
        Assertions.assertEquals((int)defaultConsumersBeforeDispatch, (int)info.getDefaultConsumersBeforeDispatch());
        Assertions.assertEquals((long)defaultDelayBeforeDispatch, (long)info.getDefaultDelayBeforeDispatch());
        Assertions.assertEquals((Object)defaultQueueRoutingType, (Object)info.getDefaultQueueRoutingType());
        Assertions.assertEquals((Object)defaultAddressRoutingType, (Object)info.getDefaultAddressRoutingType());
        Assertions.assertEquals((int)defaultConsumerWindowSize, (int)info.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)defaultRingSize, (long)info.getDefaultRingSize());
        Assertions.assertEquals((Object)autoDeleteCreatedQueues, (Object)info.isAutoDeleteCreatedQueues());
        Assertions.assertEquals((long)autoDeleteQueuesDelay, (long)info.getAutoDeleteQueuesDelay());
        Assertions.assertEquals((long)autoDeleteQueuesMessageCount, (long)info.getAutoDeleteQueuesMessageCount());
        Assertions.assertEquals((long)autoDeleteAddressesDelay, (long)info.getAutoDeleteAddressesDelay());
        Assertions.assertEquals((double)redeliveryCollisionAvoidanceFactor, (double)info.getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        Assertions.assertEquals((long)retroactiveMessageCount, (long)info.getRetroactiveMessageCount());
        Assertions.assertEquals((Object)autoCreateDeadLetterResources, (Object)info.isAutoCreateDeadLetterResources());
        Assertions.assertEquals((Object)deadLetterQueuePrefix, (Object)info.getDeadLetterQueuePrefix());
        Assertions.assertEquals((Object)deadLetterQueueSuffix, (Object)info.getDeadLetterQueueSuffix());
        Assertions.assertEquals((Object)autoCreateExpiryResources, (Object)info.isAutoCreateExpiryResources());
        Assertions.assertEquals((Object)expiryQueuePrefix, (Object)info.getExpiryQueuePrefix());
        Assertions.assertEquals((Object)expiryQueueSuffix, (Object)info.getExpiryQueueSuffix());
        Assertions.assertEquals((Object)enableMetrics, (Object)info.isEnableMetrics());
        Assertions.assertEquals((int)initialQueueBufferSize, (int)info.getInitialQueueBufferSize());
        addressSettings.setMaxSizeBytes(-1L).setPageSizeBytes(1000);
        serverControl.addAddressSettings(addressMatch, addressSettings.toJSON());
        jsonString = serverControl.getAddressSettingsAsJSON(exactAddress);
        info = AddressSettingsInfo.fromJSON((String)jsonString);
        Assertions.assertEquals((Object)DLA, (Object)info.getDeadLetterAddress());
        Assertions.assertEquals((Object)expiryAddress, (Object)info.getExpiryAddress());
        Assertions.assertEquals((long)expiryDelay, (long)info.getExpiryDelay());
        Assertions.assertEquals((long)minExpiryDelay, (long)info.getMinExpiryDelay());
        Assertions.assertEquals((long)maxExpiryDelay, (long)info.getMaxExpiryDelay());
        Assertions.assertEquals((Object)lastValueQueue, (Object)info.isDefaultLastValueQueue());
        Assertions.assertEquals((int)deliveryAttempts, (int)info.getMaxDeliveryAttempts());
        Assertions.assertEquals((long)-1L, (long)info.getMaxSizeBytes());
        Assertions.assertEquals((int)pageMaxCacheSize, (int)info.getPageCacheMaxSize());
        Assertions.assertEquals((int)1000, (int)info.getPageSizeBytes());
        Assertions.assertEquals((long)redeliveryDelay, (long)info.getRedeliveryDelay());
        Assertions.assertEquals((double)redeliveryMultiplier, (double)info.getRedeliveryMultiplier(), (double)1.0E-6);
        Assertions.assertEquals((long)maxRedeliveryDelay, (long)info.getMaxRedeliveryDelay());
        Assertions.assertEquals((long)redistributionDelay, (long)info.getRedistributionDelay());
        Assertions.assertEquals((Object)sendToDLAOnNoRoute, (Object)info.isSendToDLAOnNoRoute());
        Assertions.assertEquals((Object)addressFullMessagePolicy, (Object)info.getAddressFullMessagePolicy());
        Assertions.assertEquals((long)slowConsumerThreshold, (long)info.getSlowConsumerThreshold());
        Assertions.assertEquals((long)slowConsumerCheckPeriod, (long)info.getSlowConsumerCheckPeriod());
        Assertions.assertEquals((Object)slowConsumerPolicy, (Object)info.getSlowConsumerPolicy());
        Assertions.assertEquals((Object)autoCreateQueues, (Object)info.isAutoCreateQueues());
        Assertions.assertEquals((Object)autoDeleteQueues, (Object)info.isAutoDeleteQueues());
        Assertions.assertEquals((Object)autoCreateAddresses, (Object)info.isAutoCreateAddresses());
        Assertions.assertEquals((Object)autoDeleteAddresses, (Object)info.isAutoDeleteAddresses());
        Assertions.assertEquals((Object)configDeleteQueues, (Object)info.getConfigDeleteQueues());
        Assertions.assertEquals((Object)configDeleteAddresses, (Object)info.getConfigDeleteAddresses());
        Assertions.assertEquals((long)maxSizeBytesRejectThreshold, (long)info.getMaxSizeBytesRejectThreshold());
        Assertions.assertEquals((Object)defaultLastValueKey, (Object)info.getDefaultLastValueKey());
        Assertions.assertEquals((Object)defaultNonDestructive, (Object)info.isDefaultNonDestructive());
        Assertions.assertEquals((Object)defaultExclusiveQueue, (Object)info.isDefaultExclusiveQueue());
        Assertions.assertEquals((Object)defaultGroupRebalance, (Object)info.isDefaultGroupRebalance());
        Assertions.assertEquals((int)defaultGroupBuckets, (int)info.getDefaultGroupBuckets());
        Assertions.assertEquals((Object)defaultGroupFirstKey, (Object)info.getDefaultGroupFirstKey());
        Assertions.assertEquals((int)defaultMaxConsumers, (int)info.getDefaultMaxConsumers());
        Assertions.assertEquals((Object)defaultPurgeOnNoConsumers, (Object)info.isDefaultPurgeOnNoConsumers());
        Assertions.assertEquals((int)defaultConsumersBeforeDispatch, (int)info.getDefaultConsumersBeforeDispatch());
        Assertions.assertEquals((long)defaultDelayBeforeDispatch, (long)info.getDefaultDelayBeforeDispatch());
        Assertions.assertEquals((Object)defaultQueueRoutingType, (Object)info.getDefaultQueueRoutingType());
        Assertions.assertEquals((Object)defaultAddressRoutingType, (Object)info.getDefaultAddressRoutingType());
        Assertions.assertEquals((int)defaultConsumerWindowSize, (int)info.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)defaultRingSize, (long)info.getDefaultRingSize());
        Assertions.assertEquals((Object)autoDeleteCreatedQueues, (Object)info.isAutoDeleteCreatedQueues());
        Assertions.assertEquals((long)autoDeleteQueuesDelay, (long)info.getAutoDeleteQueuesDelay());
        Assertions.assertEquals((long)autoDeleteQueuesMessageCount, (long)info.getAutoDeleteQueuesMessageCount());
        Assertions.assertEquals((long)autoDeleteAddressesDelay, (long)info.getAutoDeleteAddressesDelay());
        Assertions.assertEquals((double)redeliveryCollisionAvoidanceFactor, (double)info.getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        Assertions.assertEquals((long)retroactiveMessageCount, (long)info.getRetroactiveMessageCount());
        Assertions.assertEquals((Object)autoCreateDeadLetterResources, (Object)info.isAutoCreateDeadLetterResources());
        Assertions.assertEquals((Object)deadLetterQueuePrefix, (Object)info.getDeadLetterQueuePrefix());
        Assertions.assertEquals((Object)deadLetterQueueSuffix, (Object)info.getDeadLetterQueueSuffix());
        Assertions.assertEquals((Object)autoCreateExpiryResources, (Object)info.isAutoCreateExpiryResources());
        Assertions.assertEquals((Object)expiryQueuePrefix, (Object)info.getExpiryQueuePrefix());
        Assertions.assertEquals((Object)expiryQueueSuffix, (Object)info.getExpiryQueueSuffix());
        Assertions.assertEquals((Object)enableMetrics, (Object)info.isEnableMetrics());
        Assertions.assertEquals((int)initialQueueBufferSize, (int)info.getInitialQueueBufferSize());
        addressSettings.setMaxSizeBytes(-2L).setPageSizeBytes(1000);
        ex = false;
        try {
            serverControl.addAddressSettings(addressMatch, addressSettings.toJSON());
        }
        catch (Exception e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"Supposed to have an exception called");
    }

    @TestTemplate
    public void testRemoveAddressSettingsEffective() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String addr = "test";
        String root = "test.#";
        String DLA = "someDLA";
        String expiryAddress = "someExpiry";
        long expiryDelay = RandomUtil.randomPositiveLong();
        long minExpiryDelay = 10000L;
        long maxExpiryDelay = 20000L;
        boolean lastValueQueue = true;
        int deliveryAttempts = 1;
        long maxSizeBytes = 0xA00000L;
        int pageSizeBytes = 0x100000;
        int pageMaxCacheSize = 7;
        long redeliveryDelay = 4L;
        double redeliveryMultiplier = 1.0;
        long maxRedeliveryDelay = 1000L;
        long redistributionDelay = 5L;
        boolean sendToDLAOnNoRoute = true;
        String addressFullMessagePolicy = "PAGE";
        long slowConsumerThreshold = 5L;
        long slowConsumerCheckPeriod = 10L;
        String slowConsumerPolicy = SlowConsumerPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        boolean autoCreateJmsQueues = RandomUtil.randomBoolean();
        boolean autoDeleteJmsQueues = RandomUtil.randomBoolean();
        boolean autoCreateJmsTopics = RandomUtil.randomBoolean();
        boolean autoDeleteJmsTopics = RandomUtil.randomBoolean();
        boolean autoCreateQueues = RandomUtil.randomBoolean();
        boolean autoDeleteQueues = RandomUtil.randomBoolean();
        boolean autoCreateAddresses = RandomUtil.randomBoolean();
        boolean autoDeleteAddresses = RandomUtil.randomBoolean();
        String configDeleteQueues = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        String configDeleteAddresses = DeletionPolicy.getType((int)(RandomUtil.randomPositiveInt() % 2)).toString();
        long maxSizeBytesRejectThreshold = RandomUtil.randomPositiveLong();
        String defaultLastValueKey = RandomUtil.randomString();
        boolean defaultNonDestructive = RandomUtil.randomBoolean();
        boolean defaultExclusiveQueue = RandomUtil.randomBoolean();
        boolean defaultGroupRebalance = RandomUtil.randomBoolean();
        int defaultGroupBuckets = RandomUtil.randomPositiveInt();
        String defaultGroupFirstKey = RandomUtil.randomString();
        int defaultMaxConsumers = RandomUtil.randomPositiveInt();
        boolean defaultPurgeOnNoConsumers = RandomUtil.randomBoolean();
        int defaultConsumersBeforeDispatch = RandomUtil.randomPositiveInt();
        long defaultDelayBeforeDispatch = RandomUtil.randomPositiveLong();
        String defaultQueueRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        String defaultAddressRoutingType = RoutingType.getType((byte)((byte)(RandomUtil.randomPositiveInt() % 2))).toString();
        int defaultConsumerWindowSize = RandomUtil.randomPositiveInt();
        long defaultRingSize = RandomUtil.randomPositiveLong();
        boolean autoDeleteCreatedQueues = RandomUtil.randomBoolean();
        long autoDeleteQueuesDelay = RandomUtil.randomPositiveLong();
        long autoDeleteQueuesMessageCount = RandomUtil.randomPositiveLong();
        long autoDeleteAddressesDelay = RandomUtil.randomPositiveLong();
        double redeliveryCollisionAvoidanceFactor = RandomUtil.randomDouble();
        long retroactiveMessageCount = RandomUtil.randomPositiveLong();
        boolean autoCreateDeadLetterResources = RandomUtil.randomBoolean();
        String deadLetterQueuePrefix = RandomUtil.randomString();
        String deadLetterQueueSuffix = RandomUtil.randomString();
        boolean autoCreateExpiryResources = RandomUtil.randomBoolean();
        String expiryQueuePrefix = RandomUtil.randomString();
        String expiryQueueSuffix = RandomUtil.randomString();
        boolean enableMetrics = RandomUtil.randomBoolean();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(SimpleString.of((String)DLA)).setExpiryAddress(SimpleString.of((String)expiryAddress)).setExpiryDelay(Long.valueOf(expiryDelay)).setDefaultLastValueQueue(lastValueQueue).setMaxDeliveryAttempts(deliveryAttempts).setMaxSizeBytes(maxSizeBytes).setPageSizeBytes(pageSizeBytes).setPageCacheMaxSize(pageMaxCacheSize).setRedeliveryDelay(redeliveryDelay).setRedeliveryMultiplier(redeliveryMultiplier).setMaxRedeliveryDelay(maxRedeliveryDelay).setRedistributionDelay(redistributionDelay).setSendToDLAOnNoRoute(sendToDLAOnNoRoute).setAddressFullMessagePolicy(AddressFullMessagePolicy.valueOf((String)addressFullMessagePolicy)).setSlowConsumerThreshold(slowConsumerThreshold).setSlowConsumerCheckPeriod(slowConsumerCheckPeriod).setSlowConsumerPolicy(SlowConsumerPolicy.valueOf((String)slowConsumerPolicy)).setAutoCreateQueues(Boolean.valueOf(autoCreateQueues)).setAutoDeleteQueues(Boolean.valueOf(autoDeleteQueues)).setAutoCreateAddresses(Boolean.valueOf(autoCreateAddresses)).setAutoDeleteAddresses(Boolean.valueOf(autoDeleteAddresses)).setConfigDeleteQueues(DeletionPolicy.valueOf((String)configDeleteQueues)).setConfigDeleteAddresses(DeletionPolicy.valueOf((String)configDeleteAddresses)).setMaxSizeBytesRejectThreshold(maxSizeBytesRejectThreshold).setDefaultLastValueKey(SimpleString.of((String)defaultLastValueKey)).setDefaultNonDestructive(defaultNonDestructive).setDefaultExclusiveQueue(Boolean.valueOf(defaultExclusiveQueue)).setDefaultGroupRebalance(defaultGroupRebalance).setDefaultGroupBuckets(defaultGroupBuckets).setDefaultGroupFirstKey(SimpleString.of((String)defaultGroupFirstKey)).setDefaultMaxConsumers(Integer.valueOf(defaultMaxConsumers)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(defaultPurgeOnNoConsumers)).setDefaultConsumersBeforeDispatch(Integer.valueOf(defaultConsumersBeforeDispatch)).setDefaultDelayBeforeDispatch(Long.valueOf(defaultDelayBeforeDispatch)).setDefaultQueueRoutingType(RoutingType.valueOf((String)defaultQueueRoutingType)).setDefaultAddressRoutingType(RoutingType.valueOf((String)defaultAddressRoutingType)).setDefaultConsumerWindowSize(defaultConsumerWindowSize).setDefaultRingSize(defaultRingSize).setAutoDeleteCreatedQueues(Boolean.valueOf(autoDeleteCreatedQueues)).setAutoDeleteQueuesDelay(autoDeleteQueuesDelay).setAutoDeleteQueuesMessageCount(autoDeleteQueuesMessageCount).setAutoDeleteAddressesDelay(autoDeleteAddressesDelay).setRedeliveryCollisionAvoidanceFactor(redeliveryCollisionAvoidanceFactor).setRetroactiveMessageCount(retroactiveMessageCount).setAutoCreateDeadLetterResources(autoCreateDeadLetterResources).setDeadLetterQueuePrefix(SimpleString.of((String)deadLetterQueuePrefix)).setDeadLetterQueueSuffix(SimpleString.of((String)deadLetterQueueSuffix)).setAutoCreateExpiryResources(autoCreateExpiryResources).setExpiryQueuePrefix(SimpleString.of((String)expiryQueuePrefix)).setExpiryQueueSuffix(SimpleString.of((String)expiryQueueSuffix)).setMinExpiryDelay(Long.valueOf(minExpiryDelay)).setMaxExpiryDelay(Long.valueOf(maxExpiryDelay)).setEnableMetrics(enableMetrics);
        serverControl.addAddressSettings(root, addressSettings.toJSON());
        AddressSettingsInfo rootInfo = AddressSettingsInfo.fromJSON((String)serverControl.getAddressSettingsAsJSON(root));
        long addrMinExpiryDelay = rootInfo.getMinExpiryDelay() + 1L;
        long addrMaxExpiryDelay = rootInfo.getMaxExpiryDelay() - 1L;
        addressSettings.setMinExpiryDelay(Long.valueOf(addrMinExpiryDelay)).setMaxExpiryDelay(Long.valueOf(addrMaxExpiryDelay));
        serverControl.addAddressSettings(addr, addressSettings.toJSON());
        AddressSettingsInfo addrInfo = AddressSettingsInfo.fromJSON((String)serverControl.getAddressSettingsAsJSON(addr));
        Assertions.assertEquals((long)addrMinExpiryDelay, (long)addrInfo.getMinExpiryDelay(), (String)"settings for addr should carry update");
        Assertions.assertEquals((long)addrMaxExpiryDelay, (long)addrInfo.getMaxExpiryDelay(), (String)"settings for addr should carry update");
        serverControl.removeAddressSettings(addr);
        AddressSettingsInfo rereadAddrInfo = AddressSettingsInfo.fromJSON((String)serverControl.getAddressSettingsAsJSON(addr));
        Assertions.assertEquals((long)rootInfo.getMinExpiryDelay(), (long)rereadAddrInfo.getMinExpiryDelay(), (String)"settings for addr should have reverted to original value after removal");
        Assertions.assertEquals((long)rootInfo.getMaxExpiryDelay(), (long)rereadAddrInfo.getMaxExpiryDelay(), (String)"settings for addr should have reverted to original value after removal");
    }

    @TestTemplate
    public void testNullRouteNameOnDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), null, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
    }

    @TestTemplate
    public void testCreateAndDestroyDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String routingName = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), routingName, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        DivertControl divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        Assertions.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        Assertions.assertEquals((Object)address, (Object)divertControl.getAddress());
        Assertions.assertEquals((Object)forwardingAddress, (Object)divertControl.getForwardingAddress());
        Assertions.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        Assertions.assertTrue((boolean)divertControl.isExclusive());
        Assertions.assertNull((Object)divertControl.getFilter());
        Assertions.assertNull((Object)divertControl.getTransformerClassName());
        String[] divertNames = serverControl.getDivertNames();
        Assertions.assertEquals((int)1, (int)divertNames.length);
        Assertions.assertEquals((Object)name, (Object)divertNames[0]);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        String divertQueue = RandomUtil.randomString();
        String queue = RandomUtil.randomString();
        if (this.legacyCreateQueue) {
            session.createQueue(forwardingAddress, RoutingType.ANYCAST, divertQueue);
            session.createQueue(address, RoutingType.ANYCAST, queue);
        } else {
            session.createQueue(QueueConfiguration.of((String)divertQueue).setAddress(forwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(address);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientConsumer consumer = session.createConsumer(queue);
        ClientConsumer divertedConsumer = session.createConsumer(divertQueue);
        session.start();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        message = divertedConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        serverControl.destroyDivert(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Assertions.assertNull((Object)divertedConsumer.receiveImmediate());
        message = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        consumer.close();
        divertedConsumer.close();
        session.deleteQueue(queue);
        session.deleteQueue(divertQueue);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testCreateAndDestroyDivertServerRestart() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), RandomUtil.randomString(), address, RandomUtil.randomString(), true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)1, (int)serverControl.getDivertNames().length);
        serverControl.destroyDivert(name.toString());
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        this.server.stop();
        this.server.start();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
    }

    @TestTemplate
    public void testCreateAndUpdateDivert() throws Exception {
        String address = RandomUtil.randomString();
        String name = RandomUtil.randomString();
        String routingName = RandomUtil.randomString();
        String forwardingAddress = RandomUtil.randomString();
        String updatedForwardingAddress = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        Assertions.assertEquals((int)0, (int)serverControl.getDivertNames().length);
        serverControl.createDivert(name.toString(), routingName, address, forwardingAddress, true, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        DivertControl divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        Assertions.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        Assertions.assertEquals((Object)address, (Object)divertControl.getAddress());
        Assertions.assertEquals((Object)forwardingAddress, (Object)divertControl.getForwardingAddress());
        Assertions.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        Assertions.assertTrue((boolean)divertControl.isExclusive());
        Assertions.assertNull((Object)divertControl.getFilter());
        Assertions.assertNull((Object)divertControl.getTransformerClassName());
        String[] divertNames = serverControl.getDivertNames();
        Assertions.assertEquals((int)1, (int)divertNames.length);
        Assertions.assertEquals((Object)name, (Object)divertNames[0]);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        String updatedDivertQueue = RandomUtil.randomString();
        String divertQueue = RandomUtil.randomString();
        String queue = RandomUtil.randomString();
        if (this.legacyCreateQueue) {
            session.createQueue(updatedForwardingAddress, RoutingType.ANYCAST, updatedDivertQueue);
            session.createQueue(forwardingAddress, RoutingType.ANYCAST, divertQueue);
            session.createQueue(address, RoutingType.ANYCAST, queue);
        } else {
            session.createQueue(QueueConfiguration.of((String)updatedDivertQueue).setAddress(updatedForwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)divertQueue).setAddress(forwardingAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)queue).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(address);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientConsumer consumer = session.createConsumer(queue);
        ClientConsumer divertedConsumer = session.createConsumer(divertQueue);
        ClientConsumer updatedDivertedConsumer = session.createConsumer(updatedDivertQueue);
        session.start();
        Assertions.assertNull((Object)consumer.receiveImmediate());
        message = divertedConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        Assertions.assertNull((Object)updatedDivertedConsumer.receiveImmediate());
        serverControl.updateDivert(name.toString(), updatedForwardingAddress, null, null, null, ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());
        this.checkResource(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address));
        divertControl = ManagementControlHelper.createDivertControl(name.toString(), address, this.mbeanServer);
        Assertions.assertEquals((Object)name.toString(), (Object)divertControl.getUniqueName());
        Assertions.assertEquals((Object)address, (Object)divertControl.getAddress());
        Assertions.assertEquals((Object)updatedForwardingAddress, (Object)divertControl.getForwardingAddress());
        Assertions.assertEquals((Object)routingName, (Object)divertControl.getRoutingName());
        Assertions.assertTrue((boolean)divertControl.isExclusive());
        Assertions.assertNull((Object)divertControl.getFilter());
        Assertions.assertNull((Object)divertControl.getTransformerClassName());
        divertNames = serverControl.getDivertNames();
        Assertions.assertEquals((int)1, (int)divertNames.length);
        Assertions.assertEquals((Object)name, (Object)divertNames[0]);
        PersistedDivertConfiguration pdc = (PersistedDivertConfiguration)this.server.getStorageManager().recoverDivertConfigurations().get(0);
        Assertions.assertEquals((Object)pdc.getDivertConfiguration().getForwardingAddress(), (Object)updatedForwardingAddress);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Assertions.assertNull((Object)consumer.receiveImmediate());
        Assertions.assertNull((Object)divertedConsumer.receiveImmediate());
        message = updatedDivertedConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        consumer.close();
        divertedConsumer.close();
        updatedDivertedConsumer.close();
        session.deleteQueue(queue);
        session.deleteQueue(divertQueue);
        session.deleteQueue(updatedDivertQueue);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testCreateAndDestroyBridge() throws Exception {
        String name = RandomUtil.randomString();
        String sourceAddress = RandomUtil.randomString();
        String sourceQueue = RandomUtil.randomString();
        String targetAddress = RandomUtil.randomString();
        String targetQueue = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        Assertions.assertEquals((int)0, (int)serverControl.getBridgeNames().length);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(sourceAddress, RoutingType.ANYCAST, sourceQueue);
            session.createQueue(targetAddress, RoutingType.ANYCAST, targetQueue);
        } else {
            session.createQueue(QueueConfiguration.of((String)sourceQueue).setAddress(sourceAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)targetQueue).setAddress(targetAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        serverControl.createBridge(name, sourceQueue, targetAddress, null, null, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 1, 0, false, 1, -1, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, this.connectorConfig.getName(), false, false, null, null);
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        String[] bridgeNames = serverControl.getBridgeNames();
        Assertions.assertEquals((int)1, (int)bridgeNames.length);
        Assertions.assertEquals((Object)name, (Object)bridgeNames[0]);
        BridgeControl bridgeControl = ManagementControlHelper.createBridgeControl(name, this.mbeanServer);
        Assertions.assertEquals((Object)name, (Object)bridgeControl.getName());
        Assertions.assertTrue((boolean)bridgeControl.isStarted());
        ClientProducer producer = session.createProducer(sourceAddress);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.start();
        ClientConsumer targetConsumer = session.createConsumer(targetQueue);
        message = targetConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        ClientConsumer sourceConsumer = session.createConsumer(sourceQueue);
        Assertions.assertNull((Object)sourceConsumer.receiveImmediate());
        serverControl.destroyBridge(name);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        Assertions.assertEquals((int)0, (int)serverControl.getBridgeNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Assertions.assertNull((Object)targetConsumer.receiveImmediate());
        message = sourceConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        sourceConsumer.close();
        targetConsumer.close();
        session.deleteQueue(sourceQueue);
        session.deleteQueue(targetQueue);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testCreateAndDestroyBridgeFromJson() throws Exception {
        this.internalTestCreateAndDestroyBridgeFromJson(false);
    }

    @TestTemplate
    public void testCreateAndDestroyBridgeFromJsonDynamicConnector() throws Exception {
        this.internalTestCreateAndDestroyBridgeFromJson(true);
    }

    private void internalTestCreateAndDestroyBridgeFromJson(boolean dynamicConnector) throws Exception {
        String name = RandomUtil.randomString();
        String sourceAddress = RandomUtil.randomString();
        String sourceQueue = RandomUtil.randomString();
        String targetAddress = RandomUtil.randomString();
        String targetQueue = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        Assertions.assertEquals((int)0, (int)serverControl.getBridgeNames().length);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(sourceAddress, RoutingType.ANYCAST, sourceQueue);
            session.createQueue(targetAddress, RoutingType.ANYCAST, targetQueue);
        } else {
            session.createQueue(QueueConfiguration.of((String)sourceQueue).setAddress(sourceAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)targetQueue).setAddress(targetAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String connectorName = this.connectorConfig.getName();
        if (dynamicConnector) {
            connectorName = RandomUtil.randomString();
            serverControl.addConnector(connectorName, "vm://0");
        }
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration(name).setQueueName(sourceQueue).setForwardingAddress(targetAddress).setUseDuplicateDetection(false).setConfirmationWindowSize(1).setProducerWindowSize(-1).setStaticConnectors(Collections.singletonList(connectorName)).setHA(false).setUser(null).setPassword(null);
        serverControl.createBridge(bridgeConfiguration.toJSON());
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        String[] bridgeNames = serverControl.getBridgeNames();
        Assertions.assertEquals((int)1, (int)bridgeNames.length);
        Assertions.assertEquals((Object)name, (Object)bridgeNames[0]);
        BridgeControl bridgeControl = ManagementControlHelper.createBridgeControl(name, this.mbeanServer);
        Assertions.assertEquals((Object)name, (Object)bridgeControl.getName());
        Assertions.assertTrue((boolean)bridgeControl.isStarted());
        ClientProducer producer = session.createProducer(sourceAddress);
        ClientMessage message = session.createMessage(false);
        String text = RandomUtil.randomString();
        message.putStringProperty("prop", text);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.start();
        ClientConsumer targetConsumer = session.createConsumer(targetQueue);
        message = targetConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text, (Object)message.getStringProperty("prop"));
        ClientConsumer sourceConsumer = session.createConsumer(sourceQueue);
        Assertions.assertNull((Object)sourceConsumer.receiveImmediate());
        serverControl.destroyBridge(name);
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name));
        Assertions.assertEquals((int)0, (int)serverControl.getBridgeNames().length);
        message = session.createMessage(false);
        String text2 = RandomUtil.randomString();
        message.putStringProperty("prop", text2);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Assertions.assertNull((Object)targetConsumer.receiveImmediate());
        message = sourceConsumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)text2, (Object)message.getStringProperty("prop"));
        sourceConsumer.close();
        targetConsumer.close();
        session.deleteQueue(sourceQueue);
        session.deleteQueue(targetQueue);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testAddAndRemoveConnector() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String connectorName = RandomUtil.randomString();
        serverControl.addConnector(connectorName, "vm://0");
        Assertions.assertEquals((Object)connectorName, (Object)((TransportConfiguration)this.server.getConfiguration().getConnectorConfigurations().get(connectorName)).getName());
        serverControl.removeConnector(connectorName);
        Assertions.assertNull(this.server.getConfiguration().getConnectorConfigurations().get(connectorName));
    }

    @TestTemplate
    public void testListPreparedTransactionDetails() throws Exception {
        SimpleString atestq = SimpleString.of((String)"BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)atestq).setDurable(Boolean.valueOf(true)));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        m2.putStringProperty("m2", "m2");
        m3.putStringProperty("m3", "m3");
        m4.putStringProperty("m4", "m4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m1);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m2);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m3);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        ClientMessage m5 = this.createTextMessage(clientSession, "");
        ClientMessage m6 = this.createTextMessage(clientSession, "");
        ClientMessage m7 = this.createTextMessage(clientSession, "");
        ClientMessage m8 = this.createTextMessage(clientSession, "");
        m5.putStringProperty("m5", "m5");
        m6.putStringProperty("m6", "m6");
        m7.putStringProperty("m7", "m7");
        m8.putStringProperty("m8", "m8");
        XidImpl xid2 = this.newXID();
        clientSession.start((Xid)xid2, 0);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m5);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m6);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m7);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m8);
        clientSession.end((Xid)xid2, 0x4000000);
        ActiveMQServerControl serverControl = this.createManagementControl();
        JsonArray jsonArray = JsonUtil.readJsonArray((String)serverControl.listProducersInfoAsJSON());
        Assertions.assertEquals((int)(1 + this.extraProducers), (int)jsonArray.size());
        JsonObject first = (JsonObject)jsonArray.get(0);
        if (!first.getString(ProducerField.ADDRESS.getAlternativeName()).equalsIgnoreCase(atestq.toString())) {
            first = (JsonObject)jsonArray.get(1);
        }
        Assertions.assertEquals((int)8, (int)first.getInt("msgSent"));
        Assertions.assertTrue((first.getInt("msgSizeSent") > 0 ? (byte)1 : 0) != 0);
        clientSession.close();
        locator.close();
        String txDetails = serverControl.listPreparedTransactionDetailsAsJSON();
        Assertions.assertTrue((boolean)txDetails.matches(".*m1.*"));
        Assertions.assertTrue((boolean)txDetails.matches(".*m2.*"));
        Assertions.assertTrue((boolean)txDetails.matches(".*m3.*"));
        Assertions.assertTrue((boolean)txDetails.matches(".*m4.*"));
        Assertions.assertFalse((boolean)txDetails.matches(".*m5.*"));
        Assertions.assertFalse((boolean)txDetails.matches(".*m6.*"));
        Assertions.assertFalse((boolean)txDetails.matches(".*m7.*"));
        Assertions.assertFalse((boolean)txDetails.matches(".*m8.*"));
    }

    @TestTemplate
    public void testListPreparedTransactionDetailsOnConsumer() throws Exception {
        SimpleString atestq = SimpleString.of((String)"BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)atestq));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "valuem1");
        m2.putStringProperty("m2", "valuem2");
        m3.putStringProperty("m3", "valuem3");
        m4.putStringProperty("m4", "valuem4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m1);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m2);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m3);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.commit((Xid)xid, false);
        ClientConsumer consumer = clientSession.createConsumer(atestq);
        clientSession.start();
        xid = this.newXID();
        clientSession.start((Xid)xid, 0);
        m1 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m1);
        m1.acknowledge();
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        ActiveMQServerControl serverControl = this.createManagementControl();
        String jsonOutput = serverControl.listPreparedTransactionDetailsAsJSON();
        Assertions.assertTrue((jsonOutput.lastIndexOf("valuem1") > 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((jsonOutput.lastIndexOf("valuem2") < 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((jsonOutput.lastIndexOf("valuem3") < 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((jsonOutput.lastIndexOf("valuem4") < 0 ? (byte)1 : 0) != 0);
        clientSession.close();
        locator.close();
    }

    @TestTemplate
    public void testListPreparedTransactionDetailsAsHTML() throws Exception {
        SimpleString atestq = SimpleString.of((String)"BasicXaTestq");
        XidImpl xid = this.newXID();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(atestq, atestq, null, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)atestq));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        ClientMessage m2 = this.createTextMessage(clientSession, "");
        ClientMessage m3 = this.createTextMessage(clientSession, "");
        ClientMessage m4 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        m2.putStringProperty("m2", "m2");
        m3.putStringProperty("m3", "m3");
        m4.putStringProperty("m4", "m4");
        ClientProducer clientProducer = clientSession.createProducer(atestq);
        clientSession.start((Xid)xid, 0);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m1);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m2);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m3);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m4);
        clientSession.end((Xid)xid, 0x4000000);
        clientSession.prepare((Xid)xid);
        clientSession.close();
        locator.close();
        ActiveMQServerControl serverControl = this.createManagementControl();
        String html = serverControl.listPreparedTransactionDetailsAsHTML();
        Assertions.assertTrue((boolean)html.matches(".*m1.*"));
        Assertions.assertTrue((boolean)html.matches(".*m2.*"));
        Assertions.assertTrue((boolean)html.matches(".*m3.*"));
        Assertions.assertTrue((boolean)html.matches(".*m4.*"));
    }

    @TestTemplate
    public void testCommitPreparedTransactions() throws Exception {
        SimpleString recQueue = SimpleString.of((String)"BasicXaTestqRec");
        SimpleString sendQueue = SimpleString.of((String)"BasicXaTestqSend");
        byte[] globalTransactionId = UUIDGenerator.getInstance().generateStringUUID().getBytes();
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, globalTransactionId);
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, globalTransactionId);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession clientSession = csf.createSession(true, false, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(recQueue, recQueue, null, true);
            clientSession.createQueue(sendQueue, sendQueue, null, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)recQueue));
            clientSession.createQueue(QueueConfiguration.of((SimpleString)sendQueue));
        }
        ClientMessage m1 = this.createTextMessage(clientSession, "");
        m1.putStringProperty("m1", "m1");
        ClientProducer clientProducer = clientSession.createProducer(recQueue);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)m1);
        locator.close();
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer consumer = receiveClientSession.createConsumer(recQueue);
        ServerLocator sendLocator = this.createInVMNonHALocator();
        ClientSessionFactory sendCsf = this.createSessionFactory(sendLocator);
        ClientSession sendClientSession = sendCsf.createSession(true, false, false);
        ClientProducer producer = sendClientSession.createProducer(sendQueue);
        receiveClientSession.start((Xid)xid, 0);
        receiveClientSession.start();
        sendClientSession.start((Xid)xid2, 0);
        ClientMessage m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        producer.send((org.apache.activemq.artemis.api.core.Message)m);
        receiveClientSession.end((Xid)xid, 0x4000000);
        sendClientSession.end((Xid)xid2, 0x4000000);
        receiveClientSession.prepare((Xid)xid);
        sendClientSession.prepare((Xid)xid2);
        ActiveMQServerControl serverControl = this.createManagementControl();
        sendLocator.close();
        receiveLocator.close();
        boolean success = serverControl.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
        success = serverControl.commitPreparedTransaction(XidImpl.toBase64String((Xid)xid));
    }

    @TestTemplate
    public void testScaleDownWithConnector() throws Exception {
        this.scaleDown(control -> control.scaleDown("server2-connector"));
    }

    @TestTemplate
    public void testScaleDownWithOutConnector() throws Exception {
        this.scaleDown(control -> control.scaleDown(null));
    }

    @TestTemplate
    public void testForceFailover() throws Exception {
        block2: {
            ActiveMQServerControl serverControl = this.createManagementControl();
            try {
                serverControl.forceFailover();
            }
            catch (Exception e) {
                if (this.usingCore()) break block2;
                Assertions.fail((String)e.getMessage());
            }
        }
        Wait.waitFor(() -> !this.server.isStarted());
        Assertions.assertFalse((boolean)this.server.isStarted());
    }

    @TestTemplate
    public void testTotalMessageCount() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(QueueConfiguration.of((String)random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(true);
        producer1.send((org.apache.activemq.artemis.api.core.Message)message);
        producer2.send((org.apache.activemq.artemis.api.core.Message)message);
        session.commit();
        org.apache.activemq.artemis.core.server.Queue queue1 = this.server.locateQueue(SimpleString.of((String)random1));
        queue1.flushExecutor();
        org.apache.activemq.artemis.core.server.Queue queue2 = this.server.locateQueue(SimpleString.of((String)random1));
        queue2.flushExecutor();
        Assertions.assertEquals((long)2L, (long)serverControl.getTotalMessageCount());
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testTotalConnectionCount() throws Exception {
        int CONNECTION_COUNT = 100;
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        for (int i = 0; i < 100; ++i) {
            this.createSessionFactory(locator).close();
        }
        Assertions.assertEquals((long)(100 + (this.usingCore() ? 1 : 0)), (long)serverControl.getTotalConnectionCount());
        Assertions.assertEquals((int)(this.usingCore() ? 1 : 0), (int)serverControl.getConnectionCount());
        locator.close();
    }

    @TestTemplate
    public void testTotalMessagesAdded() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(QueueConfiguration.of((String)random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(false);
        producer1.send((org.apache.activemq.artemis.api.core.Message)message);
        producer2.send((org.apache.activemq.artemis.api.core.Message)message);
        session.commit();
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        session.start();
        Assertions.assertNotNull((Object)consumer1.receive().acknowledge());
        Assertions.assertNotNull((Object)consumer2.receive().acknowledge());
        session.commit();
        Assertions.assertEquals((long)2L, (long)serverControl.getTotalMessagesAdded());
        Assertions.assertEquals((long)0L, (long)serverControl.getTotalMessageCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testTotalMessagesAcknowledged() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(QueueConfiguration.of((String)random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer1 = session.createProducer(random1);
        ClientProducer producer2 = session.createProducer(random2);
        ClientMessage message = session.createMessage(false);
        producer1.send((org.apache.activemq.artemis.api.core.Message)message);
        producer2.send((org.apache.activemq.artemis.api.core.Message)message);
        session.commit();
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        session.start();
        Assertions.assertNotNull((Object)consumer1.receive().acknowledge());
        Assertions.assertNotNull((Object)consumer2.receive().acknowledge());
        session.commit();
        Assertions.assertEquals((long)2L, (long)serverControl.getTotalMessagesAcknowledged());
        Assertions.assertEquals((long)0L, (long)serverControl.getTotalMessageCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testTotalConsumerCount() throws Exception {
        String random1 = RandomUtil.randomString();
        String random2 = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        QueueControl queueControl1 = ManagementControlHelper.createQueueControl(SimpleString.of((String)random1), SimpleString.of((String)random1), RoutingType.ANYCAST, this.mbeanServer);
        QueueControl queueControl2 = ManagementControlHelper.createQueueControl(SimpleString.of((String)random2), SimpleString.of((String)random2), RoutingType.ANYCAST, this.mbeanServer);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        if (this.legacyCreateQueue) {
            session.createQueue(random1, RoutingType.ANYCAST, random1);
            session.createQueue(random2, RoutingType.ANYCAST, random2);
        } else {
            session.createQueue(QueueConfiguration.of((String)random1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            session.createQueue(QueueConfiguration.of((String)random2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer1 = session.createConsumer(random1);
        ClientConsumer consumer2 = session.createConsumer(random2);
        Assertions.assertEquals((long)(this.usingCore() ? 3L : 2L), (long)serverControl.getTotalConsumerCount());
        Assertions.assertEquals((int)1, (int)queueControl1.getConsumerCount());
        Assertions.assertEquals((int)1, (int)queueControl2.getConsumerCount());
        consumer1.close();
        consumer2.close();
        session.deleteQueue(random1);
        session.deleteQueue(random2);
        session.close();
        locator.close();
    }

    @TestTemplate
    public void testListConnectionsAsJSON() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        ArrayList<ClientSessionFactory> factories = new ArrayList<ClientSessionFactory>();
        ServerLocator locator = this.createInVMNonHALocator();
        factories.add(this.createSessionFactory(locator));
        factories.add(this.createSessionFactory(locator));
        this.addClientSession(((ClientSessionFactory)factories.get(1)).createSession());
        String jsonString = serverControl.listConnectionsAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)(this.usingCore() ? 3 : 2), (int)array.size());
        JsonObject[] sorted = new JsonObject[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            sorted[i] = array.getJsonObject(i);
        }
        JsonObject first = null;
        JsonObject second = null;
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.getJsonObject(i);
            if (obj.getString("connectionID").equals(((ClientSessionFactory)factories.get(0)).getConnection().getID().toString())) {
                first = obj;
            }
            if (!obj.getString("connectionID").equals(((ClientSessionFactory)factories.get(1)).getConnection().getID().toString())) continue;
            second = obj;
        }
        Assertions.assertNotNull(first);
        Assertions.assertNotNull(second);
        Assertions.assertTrue((first.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((first.getString("clientAddress").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber("sessionCount").longValue());
        Assertions.assertTrue((second.getString("connectionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((second.getString("clientAddress").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)1L, (long)second.getJsonNumber("sessionCount").longValue());
    }

    @TestTemplate
    public void testListConsumersAsJSON() throws Exception {
        JsonObject second;
        JsonObject first;
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        String filter = "x = 1";
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.addClientConsumer(session.createConsumer(queueName));
        Thread.sleep(100L);
        this.addClientConsumer(session.createConsumer(queueName, SimpleString.of((String)"x = 1"), true));
        String jsonString = serverControl.listConsumersAsJSON(factory.getConnection().getID().toString());
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)2, (int)array.size());
        if (array.getJsonObject(0).getJsonNumber("creationTime").longValue() < array.getJsonObject(1).getJsonNumber("creationTime").longValue()) {
            first = array.getJsonObject(0);
            second = array.getJsonObject(1);
        } else {
            first = array.getJsonObject(1);
            second = array.getJsonObject(0);
        }
        Assertions.assertNotNull((Object)first.getJsonNumber(ConsumerField.ID.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.CONNECTION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)factory.getConnection().getID().toString(), (Object)first.getString(ConsumerField.CONNECTION.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.SESSION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)first.getString(ConsumerField.SESSION.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.QUEUE.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)queueName.toString(), (Object)first.getString(ConsumerField.QUEUE.getAlternativeName()));
        Assertions.assertFalse((boolean)first.getBoolean(ConsumerField.BROWSE_ONLY.getName()));
        Assertions.assertTrue((first.getJsonNumber(ConsumerField.CREATION_TIME.getName()).longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getAlternativeName()).longValue());
        Assertions.assertNotNull((Object)second.getJsonNumber(ConsumerField.ID.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.CONNECTION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)factory.getConnection().getID().toString(), (Object)second.getString(ConsumerField.CONNECTION.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.SESSION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)second.getString(ConsumerField.SESSION.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.QUEUE.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)queueName.toString(), (Object)second.getString(ConsumerField.QUEUE.getAlternativeName()));
        Assertions.assertTrue((boolean)second.getBoolean(ConsumerField.BROWSE_ONLY.getName()));
        Assertions.assertTrue((second.getJsonNumber(ConsumerField.CREATION_TIME.getName()).longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertTrue((second.getString(ConsumerField.FILTER.getName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"x = 1", (Object)second.getString(ConsumerField.FILTER.getName()));
    }

    @TestTemplate
    public void testListAllConsumersAsJSON() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession());
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory factory2 = this.createSessionFactory(locator2);
        ClientSession session2 = this.addClientSession(factory2.createSession());
        serverControl.createAddress(queueName.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.addClientConsumer(session.createConsumer(queueName));
        Thread.sleep(200L);
        this.addClientConsumer(session2.createConsumer(queueName));
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)(this.usingCore() ? 3 : 2), (int)array.size());
        String key = "creationTime";
        JsonObject[] sorted = new JsonObject[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            sorted[i] = array.getJsonObject(i);
        }
        if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
            JsonObject o = sorted[1];
            sorted[1] = sorted[0];
            sorted[0] = o;
        }
        if (this.usingCore()) {
            if (sorted[1].getJsonNumber(key).longValue() > sorted[2].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[2];
                sorted[2] = sorted[1];
                sorted[1] = o;
            }
            if (sorted[0].getJsonNumber(key).longValue() > sorted[1].getJsonNumber(key).longValue()) {
                JsonObject o = sorted[1];
                sorted[1] = sorted[0];
                sorted[0] = o;
            }
        }
        JsonObject first = sorted[0];
        JsonObject second = sorted[1];
        Assertions.assertTrue((first.getJsonNumber(ConsumerField.CREATION_TIME.getName()).longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertNotNull((Object)first.getJsonNumber(ConsumerField.ID.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.CONNECTION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)factory.getConnection().getID().toString(), (Object)first.getString(ConsumerField.CONNECTION.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.SESSION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session).getName(), (Object)first.getString(ConsumerField.SESSION.getAlternativeName()));
        Assertions.assertTrue((first.getString(ConsumerField.QUEUE.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)queueName.toString(), (Object)first.getString(ConsumerField.QUEUE.getAlternativeName()));
        Assertions.assertFalse((boolean)first.getBoolean(ConsumerField.BROWSE_ONLY.getName()));
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.LAST_DELIVERED_TIME.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()).longValue());
        Assertions.assertTrue((second.getJsonNumber(ConsumerField.CREATION_TIME.getName()).longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertNotNull((Object)second.getJsonNumber(ConsumerField.ID.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.CONNECTION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)factory2.getConnection().getID().toString(), (Object)second.getString(ConsumerField.CONNECTION.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.SESSION.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString(ConsumerField.SESSION.getAlternativeName()));
        Assertions.assertTrue((second.getString(ConsumerField.QUEUE.getAlternativeName()).length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)queueName.toString(), (Object)second.getString(ConsumerField.QUEUE.getAlternativeName()));
        Assertions.assertFalse((boolean)second.getBoolean(ConsumerField.BROWSE_ONLY.getName()));
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.LAST_DELIVERED_TIME.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)second.getJsonNumber(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONTXCommit() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(true, false, 1);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        ClientProducer producer = session.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
        }
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        receive.acknowledge();
        session.commit();
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        int allSize = size;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            allSize += message.getEncodeSize();
            receive = consumer.receive();
        }
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)200L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)allSize, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONTXCommitAck() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(true, false, 1);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        ClientProducer producer = session.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
            receive.acknowledge();
        }
        Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)serverControl.listAllConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.commit();
        Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)serverControl.listAllConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONTXRollback() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(true, false, 1);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        ClientProducer producer = session.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
        }
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        receive.acknowledge();
        session.stop();
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.rollback();
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        int allSize = size * 2;
        session.start();
        for (int i = 0; i < 100; ++i) {
            receive = consumer.receive();
        }
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)200L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)allSize, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        receive.acknowledge();
        session.stop();
        session.rollback();
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)200L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)allSize, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)200L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONCancel() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(true, false, 1);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        ClientProducer producer = session.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
        }
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        receive.acknowledge();
        consumer.close();
        session.close();
        session = factory.createSession(true, false, 1);
        this.addClientSession(session);
        consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONNoTX() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(true, true, 1);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        ClientProducer producer = session.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
            receive.acknowledge();
        }
        Wait.assertEquals((int)0, () -> ((JsonValue)JsonUtil.readJsonArray((String)serverControl.listAllConsumersAsJSON()).get(0)).asJsonObject().getInt(ConsumerField.MESSAGES_IN_TRANSIT.getName()));
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONXACommit() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession sendSession = factory.createSession();
        this.addClientSession(sendSession);
        ClientSession session = factory.createSession(true, false, false);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        ClientProducer producer = sendSession.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = sendSession.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
            receive.acknowledge();
        }
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.commit((Xid)xid, false);
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListAllConsumersAsJSONXARollback() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession sendSession = factory.createSession();
        this.addClientSession(sendSession);
        ClientSession session = factory.createSession(true, false, false);
        this.addClientSession(session);
        serverControl.createAddress(queueName.toString(), RoutingType.ANYCAST.name());
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer = session.createConsumer(queueName, null, 100, -1, false);
        this.addClientConsumer(consumer);
        session.start();
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        ClientProducer producer = sendSession.createProducer(queueName);
        int size = 0;
        ClientMessage receive = null;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = sendSession.createMessage(true);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            size += message.getEncodeSize();
            receive = consumer.receive();
            receive.acknowledge();
        }
        String jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        JsonObject first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
        session.stop();
        session.rollback((Xid)xid);
        jsonString = serverControl.listAllConsumersAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        array = JsonUtil.readJsonArray((String)jsonString);
        first = (JsonObject)array.get(0);
        if (!first.getString(ConsumerField.QUEUE.getAlternativeName()).equalsIgnoreCase(queueName.toString())) {
            first = (JsonObject)array.get(1);
        }
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED.getName()).longValue());
        Assertions.assertEquals((long)size, (long)first.getJsonNumber(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()).longValue());
        Assertions.assertEquals((long)100L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()).longValue());
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName()).longValue());
    }

    @TestTemplate
    public void testListSessionsAsJSON() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session1 = this.addClientSession(factory.createSession());
        ClientSession session2 = this.addClientSession(factory.createSession("myUser", "myPass", false, false, false, false, 0));
        session2.createConsumer(queueName);
        String jsonString = serverControl.listSessionsAsJSON(factory.getConnection().getID().toString());
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)2, (int)array.size());
        JsonObject first = this.lookupSession(array, session1);
        JsonObject second = this.lookupSession(array, session2);
        Assertions.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session1).getName(), (Object)first.getString("sessionID"));
        Assertions.assertTrue((first.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"guest", (Object)first.getString("principal"));
        Assertions.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber("consumerCount").longValue());
        Assertions.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString("sessionID"));
        Assertions.assertTrue((second.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"myUser", (Object)second.getString("principal"));
        Assertions.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)1L, (long)second.getJsonNumber("consumerCount").longValue());
    }

    private JsonObject lookupSession(JsonArray jsonArray, ClientSession session) throws Exception {
        String name = ((ClientSessionImpl)session).getName();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject obj = jsonArray.getJsonObject(i);
            String sessionID = obj.getString("sessionID");
            Assertions.assertNotNull((Object)sessionID);
            if (!sessionID.equals(name)) continue;
            return obj;
        }
        Assertions.fail((String)("Sesison not found for session id " + name));
        return null;
    }

    @TestTemplate
    public void testListAllSessionsAsJSON() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory factory2 = this.createSessionFactory(locator2);
        ClientSession session1 = this.addClientSession(factory.createSession());
        Thread.sleep(5L);
        ClientSession session2 = this.addClientSession(factory2.createSession("myUser", "myPass", false, false, false, false, 0));
        session2.addMetaData("foo", "bar");
        session2.addMetaData("bar", "baz");
        session2.createConsumer(queueName);
        String jsonString = serverControl.listAllSessionsAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)(2 + (this.usingCore() ? 1 : 0)), (int)array.size());
        JsonObject first = this.lookupSession(array, session1);
        JsonObject second = this.lookupSession(array, session2);
        Assertions.assertTrue((first.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session1).getName(), (Object)first.getString("sessionID"));
        Assertions.assertTrue((first.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"guest", (Object)first.getString("principal"));
        Assertions.assertTrue((first.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)first.getJsonNumber("consumerCount").longValue());
        Assertions.assertTrue((second.getString("sessionID").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)((ClientSessionImpl)session2).getName(), (Object)second.getString("sessionID"));
        Assertions.assertTrue((second.getString("principal").length() > 0 ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)"myUser", (Object)second.getString("principal"));
        Assertions.assertTrue((second.getJsonNumber("creationTime").longValue() > 0L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)1L, (long)second.getJsonNumber("consumerCount").longValue());
        Assertions.assertEquals((Object)second.getJsonObject("metadata").getJsonString("foo").getString(), (Object)"bar");
        Assertions.assertEquals((Object)second.getJsonObject("metadata").getJsonString("bar").getString(), (Object)"baz");
    }

    @TestTemplate
    public void testListAllSessionsAsJSONWithJMS() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(queueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ActiveMQServerControl serverControl = this.createManagementControl();
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)"vm://0", (String)"cf");
        Connection con = cf.createConnection();
        String clientID = UUID.randomUUID().toString();
        con.setClientID(clientID);
        String jsonString = serverControl.listAllSessionsAsJSON();
        logger.debug(jsonString);
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)(1 + (this.usingCore() ? 1 : 0)), (int)array.size());
        JsonObject obj = this.lookupSession(array, ((ActiveMQConnection)con).getInitialSession());
        Assertions.assertEquals((Object)obj.getJsonObject("metadata").getJsonString("jms-client-id").getString(), (Object)clientID);
        Assertions.assertNotNull((Object)obj.getJsonObject("metadata").getJsonString("jms-session"));
    }

    @TestTemplate
    public void testListQueues() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"other_queue_three");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_queue");
        String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)2, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertTrue((boolean)array.getJsonObject(0).getString("name").contains("my_queue"));
        Assertions.assertTrue((boolean)array.getJsonObject(1).getString("name").contains("my_queue"));
        filterString = this.createJsonFilter("internalQueue", "NOT_CONTAINS", "true");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertTrue((3 <= array.size() ? (byte)1 : 0) != 0, (String)"number of queues returned from query");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("name"), (String)"name");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("id"), (String)"id");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("address"), (String)"address");
        Assertions.assertEquals((Object)"", (Object)array.getJsonObject(0).getString("filter"), (String)"filter");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("durable"), (String)"durable");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("paused"), (String)"paused");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("temporary"), (String)"temporary");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("purgeOnNoConsumers"), (String)"purgeOnNoConsumers");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("consumerCount"), (String)"consumerCount");
        Assertions.assertEquals((Object)"-1", (Object)array.getJsonObject(0).getString("maxConsumers"), (String)"maxConsumers");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("autoCreated"), (String)"autoCreated");
        Assertions.assertEquals((Object)(this.usingCore() ? "guest" : ""), (Object)array.getJsonObject(0).getString("user"), (String)"user");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("routingType"), (String)"routingType");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("messagesAdded"), (String)"messagesAdded");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("messageCount"), (String)"messageCount");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("messagesAcked"), (String)"messagesAcked");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("deliveringCount"), (String)"deliveringCount");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("messagesKilled"), (String)"messagesKilled");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("exclusive"), (String)"exclusive");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("lastValue"), (String)"lastValue");
        Assertions.assertEquals((Object)"0", (Object)array.getJsonObject(0).getString("scheduledCount"), (String)"scheduledCount");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("groupRebalance"), (String)"groupRebalance");
        Assertions.assertEquals((Object)"-1", (Object)array.getJsonObject(0).getString("groupBuckets"), (String)"groupBuckets");
        Assertions.assertEquals((Object)"", (Object)array.getJsonObject(0).getString("groupFirstKey"), (String)"groupFirstKey");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("autoDelete"), (String)"autoDelete");
    }

    @TestTemplate
    public void testListQueuesOrder() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_1");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_2");
        SimpleString queueName3 = SimpleString.of((String)"my_queue_3");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, SimpleString.of((String)"filter1"), null, true, false, false, Integer.valueOf(20), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setRoutingType(RoutingType.ANYCAST).setFilterString("filter1").setMaxConsumers(Integer.valueOf(20)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        Thread.sleep(500L);
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, SimpleString.of((String)"filter3"), null, true, false, true, Integer.valueOf(40), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setRoutingType(RoutingType.ANYCAST).setFilterString("filter3").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(40)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        Thread.sleep(500L);
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, SimpleString.of((String)"filter0"), null, true, false, false, Integer.valueOf(10), Boolean.valueOf(false), false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setRoutingType(RoutingType.ANYCAST).setFilterString("filter0").setMaxConsumers(Integer.valueOf(10)).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_queue");
        String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue1 default Order");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"queue2 default Order");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"queue3 default Order");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "id", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue3 ordered by id");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"queue2 ordered by id");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"queue1 ordered by id");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue3 ordered by address");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"queue2 ordered by address");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"queue1 ordered by address");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "autoCreated", "asc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(0).getString("autoCreated"), (String)"pos1 ordered by autocreate");
        Assertions.assertEquals((Object)"false", (Object)array.getJsonObject(1).getString("autoCreated"), (String)"pos2 ordered by autocreate");
        Assertions.assertEquals((Object)"true", (Object)array.getJsonObject(2).getString("autoCreated"), (String)"pos3 ordered by autocreate");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "filter", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue2 ordered by filter");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"queue1 ordered by filter");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"queue3 ordered by filter");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "maxConsumers", "asc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue3 ordered by filter");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"queue1 ordered by filter");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"queue2 ordered by filter");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 1, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue3 ordered by page");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 2, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue2 ordered by page");
        filterString = this.createJsonFilter("name", "CONTAINS", "my_queue", "address", "desc");
        queuesAsJsonString = serverControl.listQueues(filterString, 3, 1);
        queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
        array = (JsonArray)queuesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from query");
        Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"queue1 ordered by page");
    }

    @TestTemplate
    public void testListQueuesNumericFilter() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"one_consumer_queue_three");
        SimpleString queueName4 = SimpleString.of((String)"my_queue_four");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false, 10, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)).setMaxConsumers(Integer.valueOf(10)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName4, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName4, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName4).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            session.start();
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer1_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer2_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer3_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer1_q3 = session.createConsumer(queueName3);
            ClientProducer clientProducer = session.createProducer(queueName1);
            ClientMessage message = session.createMessage(false);
            for (int i = 0; i < 10; ++i) {
                clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            ClientMessage messageReceived = consumer1_q1.receive(100L);
            if (messageReceived == null) {
                Assertions.fail((String)"should have received a message");
            }
            messageReceived.acknowledge();
            session.commit();
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "CONTAINS", "0");
            String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "LESS_THAN", "1");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)2, (int)array.size(), (String)"number of queues returned from LESS_THAN query");
            Assertions.assertEquals((Object)queueName4.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "2");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from GREATER_THAN query");
            Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "EQUALS", "3");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from EQUALS query");
            Assertions.assertEquals((Object)queueName2.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("MESSAGE_COUNT", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from MESSAGE_COUNT query");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("MESSAGES_ADDED", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from MESSAGE_COUNT query");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("DELIVERING_COUNT", "GREATER_THAN", "5");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from DELIVERING_COUNT query");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("MESSAGES_ACKED", "GREATER_THAN", "0");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from MESSAGES_ACKED query");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("MAX_CONSUMERS", "GREATER_THAN", "9");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from MAX_CONSUMERS query");
            Assertions.assertEquals((Object)queueName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"correct queue returned from query");
            filterString = this.createJsonFilter("MESSAGES_KILLED", "GREATER_THAN", "0");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from MESSAGES_KILLED query");
        }
    }

    @TestTemplate
    public void testListQueuesNumericFilterInvalid() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"one_consumer_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"one_consumer_queue_three");
        SimpleString queueName4 = SimpleString.of((String)"my_queue_four");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(queueName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName3, RoutingType.ANYCAST, queueName3, null, false, false, 10, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)).setMaxConsumers(Integer.valueOf(10)));
        }
        this.server.addAddressInfo(new AddressInfo(queueName4, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(queueName4, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName4).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            session.start();
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "CONTAINS", "NOT_NUMBER");
            String queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            JsonArray array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "LESS_THAN", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from LESS_THAN query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from GREATER_THAN query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "EQUALS", "NOT_NUMBER");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from EQUALS query");
            filterString = this.createJsonFilter("name", "LESS_THAN", "my_queue");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from LESS_THAN on non numeric field");
            filterString = this.createJsonFilter("name", "GREATER_THAN", "my_queue");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from GREATER_THAN on non numeric field");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", " ");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from GREATER_THAN query");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "0.12");
            queuesAsJsonString = serverControl.listQueues(filterString, 1, 50);
            queuesAsJsonObject = JsonUtil.readJsonObject((String)queuesAsJsonString);
            array = (JsonArray)queuesAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of queues returned from GREATER_THAN query");
        }
    }

    @TestTemplate
    public void testListAddresses() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"other_queue_three");
        SimpleString queueName4 = SimpleString.of((String)"other_queue_four");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        SimpleString addressName2 = SimpleString.of((String)"my_address_two");
        SimpleString addressName3 = SimpleString.of((String)"other_address_three");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName2, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName3, null, false, false);
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName4).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my_address");
        String addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        JsonObject addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        JsonArray array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)2, (int)array.size(), (String)"number of addresses returned from query");
        Assertions.assertTrue((boolean)array.getJsonObject(0).getString("name").contains("my_address"), (String)"address name check");
        Assertions.assertTrue((boolean)array.getJsonObject(1).getString("name").contains("my_address"), (String)"address name check");
        filterString = this.createJsonFilter("name", "EQUALS", addressName1.toString());
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of addresses returned from query");
        Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"address name check");
        Assertions.assertNotEquals((Object)"", (Object)array.getJsonObject(0).getString("id"), (String)"id");
        Assertions.assertTrue((boolean)array.getJsonObject(0).getString("routingTypes").contains(RoutingType.ANYCAST.name()), (String)"routingTypes");
        Assertions.assertEquals((Object)"1", (Object)array.getJsonObject(0).getString("queueCount"), (String)"queueCount");
        filterString = this.createJsonFilter("", "", "");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertTrue((3 <= array.size() ? (byte)1 : 0) != 0, (String)"number of addresses returned from query");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 1);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of queues returned from query");
        filterString = this.createJsonFilter("QUEUE_COUNT", "GREATER_THAN", "1");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)1, (int)array.size(), (String)"number of addresses returned from query");
        Assertions.assertEquals((Object)addressName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"address name check");
        filterString = this.createJsonFilter("QUEUE_COUNT", "LESS_THAN", "0");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)0, (int)array.size(), (String)"number of addresses returned from query");
    }

    @TestTemplate
    public void testListAddressOrder() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"other_queue_three");
        SimpleString queueName4 = SimpleString.of((String)"other_queue_four");
        SimpleString addressName1 = SimpleString.of((String)"my_address_1");
        SimpleString addressName2 = SimpleString.of((String)"my_address_2");
        SimpleString addressName3 = SimpleString.of((String)"my_address_3");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(addressName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName3, null, false, false);
            this.server.createQueue(addressName3, RoutingType.ANYCAST, queueName4, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName4).setAddress(addressName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        String filterString = this.createJsonFilter("name", "CONTAINS", "my");
        String addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        JsonObject addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        JsonArray array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number addresses returned");
        Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"address1 default order");
        Assertions.assertEquals((Object)addressName2.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"address2 default order");
        Assertions.assertEquals((Object)addressName3.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"address3 default order");
        filterString = this.createJsonFilter("name", "CONTAINS", "my", "name", "desc");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number addresses returned");
        Assertions.assertEquals((Object)addressName3.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"address3 ordered by name");
        Assertions.assertEquals((Object)addressName2.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"address2 ordered by name");
        Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"address1 ordered by name");
        filterString = this.createJsonFilter("name", "CONTAINS", "my", "queueCount", "asc");
        addressesAsJsonString = serverControl.listAddresses(filterString, 1, 50);
        addressesAsJsonObject = JsonUtil.readJsonObject((String)addressesAsJsonString);
        array = (JsonArray)addressesAsJsonObject.get((Object)"data");
        Assertions.assertEquals((int)3, (int)array.size(), (String)"number addresses returned");
        Assertions.assertEquals((Object)addressName2.toString(), (Object)array.getJsonObject(0).getString("name"), (String)"address2 ordered by queue count");
        Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(1).getString("name"), (String)"address1 ordered by queue count");
        Assertions.assertEquals((Object)addressName3.toString(), (Object)array.getJsonObject(2).getString("name"), (String)"address3 ordered by queue count");
    }

    @TestTemplate
    public void testListConsumers() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString queueName2 = SimpleString.of((String)"my_queue_two");
        SimpleString queueName3 = SimpleString.of((String)"other_queue_three");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        SimpleString addressName2 = SimpleString.of((String)"my_address_two");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.addAddressInfo(new AddressInfo(addressName2, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName2, null, false, false);
            this.server.createQueue(addressName2, RoutingType.ANYCAST, queueName3, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName3).setAddress(addressName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            ClientConsumer consumer1_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer2_q1 = session.createConsumer(queueName1);
            ClientConsumer consumer1_q2 = session.createConsumer(queueName2);
            ClientConsumer consumer1_q3 = session.createConsumer(queueName3);
            String filterString = this.createJsonFilter("queue", "EQUALS", queueName1.toString());
            String consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            JsonObject consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            JsonArray array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)2, (int)array.size(), (String)"number of consumers returned from query");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString(ConsumerField.QUEUE.getName()), (String)"check consumer's queue");
            Assertions.assertEquals((Object)queueName1.toString(), (Object)array.getJsonObject(0).getString(ConsumerField.QUEUE.getName()), (String)"check consumer's queue");
            filterString = this.createJsonFilter(ConsumerField.QUEUE.getName(), "CONTAINS", "my_queue");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of consumers returned from query");
            filterString = this.createJsonFilter(ConsumerField.ADDRESS.getName(), "EQUALS", addressName1.toString());
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)2, (int)array.size(), (String)"number of consumers returned from query");
            Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(0).getString(ConsumerField.ADDRESS.getName()), (String)"check consumers address");
            Assertions.assertEquals((Object)addressName1.toString(), (Object)array.getJsonObject(1).getString(ConsumerField.ADDRESS.getName()), (String)"check consumers address");
            filterString = this.createJsonFilter("", "", "");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertTrue((4 <= array.size() ? (byte)1 : 0) != 0, (String)"at least 4 consumers returned from query");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 1);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of consumers returned from query");
            filterString = this.createJsonFilter(ConsumerField.QUEUE.getName(), "EQUALS", queueName3.toString());
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of consumers returned from query");
            JsonObject jsonConsumer = array.getJsonObject(0);
            Assertions.assertEquals((Object)queueName3.toString(), (Object)jsonConsumer.getString(ConsumerField.QUEUE.getName()), (String)"queue name in consumer");
            Assertions.assertEquals((Object)addressName2.toString(), (Object)jsonConsumer.getString(ConsumerField.ADDRESS.getName()), (String)"address name in consumer");
            Assertions.assertEquals((Object)"CORE", (Object)jsonConsumer.getString(ConsumerField.PROTOCOL.getName()), (String)"consumer protocol ");
            Assertions.assertEquals((Object)"anycast", (Object)jsonConsumer.getString(ConsumerField.QUEUE_TYPE.getName()), (String)"queue type");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.ID.getName()), (String)"id");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.SESSION.getName()), (String)"session");
            Assertions.assertEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.CLIENT_ID.getName()), (String)"clientID");
            Assertions.assertEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.USER.getName()), (String)"user");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.LOCAL_ADDRESS.getName()), (String)"localAddress");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.REMOTE_ADDRESS.getName()), (String)"remoteAddress");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.CREATION_TIME.getName()), (String)"creationTime");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.MESSAGES_IN_TRANSIT.getName()), (String)"messagesInTransit");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName()), (String)"messagesInTransitSize");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.MESSAGES_DELIVERED.getName()), (String)"messagesDelivered");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.MESSAGES_DELIVERED_SIZE.getName()), (String)"messagesDeliveredSize");
            Assertions.assertNotEquals((Object)"", (Object)jsonConsumer.getString(ConsumerField.MESSAGES_ACKNOWLEDGED.getName()), (String)"messagesAcknowledged");
            Assertions.assertEquals((int)0, (int)jsonConsumer.getInt(ConsumerField.LAST_DELIVERED_TIME.getName()), (String)"lastDeliveredTime");
            Assertions.assertEquals((int)0, (int)jsonConsumer.getInt(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName()), (String)"lastAcknowledgedTime");
        }
    }

    @TestTemplate
    public void testListConsumersOrder() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSessionImpl session1 = (ClientSessionImpl)csf.createSession();
            ClientSessionImpl session2 = (ClientSessionImpl)csf.createSession();
            ClientSessionImpl session3 = (ClientSessionImpl)csf.createSession();
            ClientConsumer consumer_s1 = session1.createConsumer(queueName1);
            Thread.sleep(500L);
            ClientConsumer consumer_s2 = session2.createConsumer(queueName1);
            Thread.sleep(500L);
            ClientConsumer consumer_s3 = session3.createConsumer(queueName1);
            String filterString = this.createJsonFilter(ConsumerField.QUEUE.getName(), "EQUALS", queueName1.toString());
            String consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            JsonObject consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            JsonArray array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of consumers returned from query");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(0).getString(ConsumerField.SESSION.getName()), (String)"Consumer1 default order");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(1).getString(ConsumerField.SESSION.getName()), (String)"Consumer2 default order");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(2).getString(ConsumerField.SESSION.getName()), (String)"Consumer3 default order");
            filterString = this.createJsonFilter(ConsumerField.QUEUE.getName(), "EQUALS", queueName1.toString(), "creationTime", "desc");
            consumersAsJsonString = serverControl.listConsumers(filterString, 1, 50);
            consumersAsJsonObject = JsonUtil.readJsonObject((String)consumersAsJsonString);
            array = (JsonArray)consumersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of consumers returned from query");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(0).getString(ConsumerField.SESSION.getName()), (String)"Consumer3 creation time");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(1).getString(ConsumerField.SESSION.getName()), (String)"Consumer2 creation time");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(2).getString(ConsumerField.SESSION.getName()), (String)"Consumer1 creation time");
        }
    }

    @TestTemplate
    public void testListSessions() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSessionImpl session1 = (ClientSessionImpl)csf.createSession();
            Thread.sleep(500L);
            ClientSessionImpl session2 = (ClientSessionImpl)csf.createSession();
            Thread.sleep(500L);
            ClientSessionImpl session3 = (ClientSessionImpl)csf.createSession();
            ClientConsumer consumer1_s1 = session1.createConsumer(queueName1);
            ClientConsumer consumer2_s1 = session1.createConsumer(queueName1);
            ClientConsumer consumer1_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer2_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer3_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer4_s2 = session2.createConsumer(queueName1);
            ClientConsumer consumer1_s3 = session3.createConsumer(queueName1);
            ClientConsumer consumer2_s3 = session3.createConsumer(queueName1);
            ClientConsumer consumer3_s3 = session3.createConsumer(queueName1);
            String filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1");
            String sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            JsonObject sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            JsonArray array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of sessions returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString("id"), (String)"id");
            Assertions.assertEquals((Object)"", (Object)jsonSession.getString("user"), (String)"user");
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString("creationTime"), (String)"creationTime");
            Assertions.assertEquals((int)2, (int)jsonSession.getInt("consumerCount"), (String)"consumerCount");
            Assertions.assertTrue((0 <= jsonSession.getInt("producerCount") ? (byte)1 : 0) != 0, (String)"producerCount");
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString("connectionID"), (String)"connectionID");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"), (String)"session1 location");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(1).getString("id"), (String)"session2 location");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(2).getString("id"), (String)"session3 location");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "consumerCount", "asc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assertions.assertTrue((3 == array.size() ? (byte)1 : 0) != 0, (String)"number of sessions returned from query");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"), (String)"session1 ordered by consumer");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(1).getString("id"), (String)"session3 ordered by consumer");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(2).getString("id"), (String)"session2 ordered by consumer");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "consumerCount", "asc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assertions.assertTrue((3 == array.size() ? (byte)1 : 0) != 0, (String)"number of sessions returned from query");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(0).getString("id"), (String)"session1 ordered by consumer");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(1).getString("id"), (String)"session3 ordered by consumer");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(2).getString("id"), (String)"session2 ordered by consumer");
            filterString = this.createJsonFilter("CONSUMER_COUNT", "GREATER_THAN", "1", "creationTime", "desc");
            sessionsAsJsonString = serverControl.listSessions(filterString, 1, 50);
            sessionsAsJsonObject = JsonUtil.readJsonObject((String)sessionsAsJsonString);
            array = (JsonArray)sessionsAsJsonObject.get((Object)"data");
            Assertions.assertTrue((3 == array.size() ? (byte)1 : 0) != 0, (String)"number of sessions returned from query");
            Assertions.assertEquals((Object)session3.getName(), (Object)array.getJsonObject(0).getString("id"), (String)"session3 ordered by creationTime");
            Assertions.assertEquals((Object)session2.getName(), (Object)array.getJsonObject(1).getString("id"), (String)"session2 ordered by creationTime");
            Assertions.assertEquals((Object)session1.getName(), (Object)array.getJsonObject(2).getString("id"), (String)"session1 ordered by creationTime");
        }
    }

    @TestTemplate
    public void testListSessionsJmsClientID() throws Exception {
        String clientId = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory cf = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("vm://0");
        try (Connection c = cf.createConnection();){
            c.setClientID(clientId);
            c.createSession();
            String filter = this.createJsonFilter(SessionField.CLIENT_ID.getName(), "EQUALS", clientId);
            String json = serverControl.listSessions(filter, 1, 50);
            System.out.println(json);
            JsonObject sessions = JsonUtil.readJsonObject((String)json);
            JsonArray array = (JsonArray)sessions.get((Object)"data");
            Assertions.assertEquals((int)2, (int)array.size(), (String)"number of sessions returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            Assertions.assertEquals((Object)clientId, (Object)jsonSession.getString(SessionField.CLIENT_ID.getName()), (String)"wrong client ID returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testListConnections() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        ClientSessionFactoryImpl csf = null;
        ClientSessionFactoryImpl csf2 = null;
        ClientSessionFactoryImpl csf3 = null;
        try (ServerLocator locator = this.createInVMNonHALocator();){
            csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            Thread.sleep(50L);
            csf2 = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            Thread.sleep(50L);
            csf3 = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            ClientSession session1_c1 = csf.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c1 = csf.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session1_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session3_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session4_c2 = csf2.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session1_c4 = csf3.createSession("myUser", "myPass", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session2_c4 = csf3.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            ClientSession session3_c4 = csf3.createSession("guest", "guest", false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize());
            String filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1");
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            System.err.println(connectionsAsJsonString);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of connections returned from query");
            JsonObject jsonConnection = array.getJsonObject(0);
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("connectionID"), (String)"connectionID");
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("remoteAddress"), (String)"remoteAddress");
            Assertions.assertEquals((Object)"guest", (Object)jsonConnection.getString("users"), (String)"users");
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("creationTime"), (String)"creationTime");
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("implementation"), (String)"implementation");
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("protocol"), (String)"protocol");
            Assertions.assertEquals((Object)"", (Object)jsonConnection.getString("clientID"), (String)"clientID");
            Assertions.assertNotEquals((Object)"", (Object)jsonConnection.getString("localAddress"), (String)"localAddress");
            Assertions.assertEquals((int)2, (int)jsonConnection.getInt("sessionCount"), (String)"sessionCount");
            Assertions.assertEquals((Object)csf.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"), (String)"connection1 default Order");
            Assertions.assertEquals((Object)csf2.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"), (String)"connection2 default Order");
            Assertions.assertEquals((Object)csf3.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"), (String)"connection3 session Order");
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "users", "asc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of connections returned from query");
            Assertions.assertEquals((Object)"guest", (Object)array.getJsonObject(0).getString("users"), (String)"connection1 users Order");
            Assertions.assertEquals((Object)"guest,myUser", (Object)array.getJsonObject(1).getString("users"), (String)"connection3 users Order");
            Assertions.assertEquals((Object)"myUser", (Object)array.getJsonObject(2).getString("users"), (String)"connection2 users Order");
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "users", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of connections returned from query");
            Assertions.assertEquals((Object)"myUser", (Object)array.getJsonObject(0).getString("users"), (String)"connection2 users Order");
            Assertions.assertEquals((Object)"guest,myUser", (Object)array.getJsonObject(1).getString("users"), (String)"connection3 users Order");
            Assertions.assertEquals((Object)"guest", (Object)array.getJsonObject(2).getString("users"), (String)"connection1 users Order");
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "sessionCount", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of connections returned from query");
            Assertions.assertEquals((Object)csf2.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"), (String)"connection2 session Order");
            Assertions.assertEquals((Object)csf3.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"), (String)"connection3 session Order");
            Assertions.assertEquals((Object)csf.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"), (String)"connection1 session Order");
            filterString = this.createJsonFilter("SESSION_COUNT", "GREATER_THAN", "1", "creationTime", "desc");
            connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)3, (int)array.size(), (String)"number of connections returned from query");
            Assertions.assertEquals((Object)csf3.getConnection().getID(), (Object)array.getJsonObject(0).getString("connectionID"), (String)"connection3 creationTime Order");
            Assertions.assertEquals((Object)csf2.getConnection().getID(), (Object)array.getJsonObject(1).getString("connectionID"), (String)"connection2 creationTime Order");
            Assertions.assertEquals((Object)csf.getConnection().getID(), (Object)array.getJsonObject(2).getString("connectionID"), (String)"connection1 creationTime Order");
        }
        finally {
            if (csf != null) {
                csf.close();
            }
            if (csf2 != null) {
                csf.close();
            }
            if (csf3 != null) {
                csf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testListConnectionsCoreClientID() throws Exception {
        String clientId = RandomUtil.randomString();
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ClientSessionFactoryImpl csf = null;
             ServerLocator locator = this.createInVMNonHALocator();){
            csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            csf.createSession(null, null, false, true, true, locator.isPreAcknowledge(), locator.getAckBatchSize(), clientId);
            String filterString = this.createJsonFilter(ConnectionField.CLIENT_ID.getName(), ActiveMQFilterPredicate.Operation.EQUALS.toString(), clientId);
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of connections returned from query");
            JsonObject jsonConnection = array.getJsonObject(0);
            Assertions.assertEquals((Object)clientId, (Object)jsonConnection.getString(ConnectionField.CLIENT_ID.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testListConnectionsCoreClientIDLegacy() throws Exception {
        String clientId = RandomUtil.randomString();
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ClientSessionFactoryImpl csf = null;
             ServerLocator locator = this.createInVMNonHALocator();){
            csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
            ClientSession session = csf.createSession();
            session.addUniqueMetaData("jms-session", "");
            session.addUniqueMetaData("jms-client-id", clientId);
            String filterString = this.createJsonFilter(ConnectionField.CLIENT_ID.getName(), ActiveMQFilterPredicate.Operation.EQUALS.toString(), clientId);
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of connections returned from query");
            JsonObject jsonConnection = array.getJsonObject(0);
            Assertions.assertEquals((Object)clientId, (Object)jsonConnection.getString(ConnectionField.CLIENT_ID.getName()));
        }
    }

    @TestTemplate
    public void testListConnectionsJmsClientID() throws Exception {
        String clientId = RandomUtil.randomString();
        ActiveMQServerControl serverControl = this.createManagementControl();
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory cf = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("vm://0");
        try (Connection c = cf.createConnection();){
            c.setClientID(clientId);
            String filterString = this.createJsonFilter(ConnectionField.CLIENT_ID.getName(), ActiveMQFilterPredicate.Operation.EQUALS.toString(), clientId);
            String connectionsAsJsonString = serverControl.listConnections(filterString, 1, 50);
            JsonObject connectionsAsJsonObject = JsonUtil.readJsonObject((String)connectionsAsJsonString);
            JsonArray array = (JsonArray)connectionsAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of connections returned from query");
            JsonObject jsonConnection = array.getJsonObject(0);
            Assertions.assertEquals((Object)clientId, (Object)jsonConnection.getString(ConnectionField.CLIENT_ID.getName()), (String)"wrong client ID returned");
        }
    }

    @TestTemplate
    public void testListProducers() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientSession session2 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            producer1.send((org.apache.activemq.artemis.api.core.Message)session1.createMessage(true));
            ClientProducer producer2 = session2.createProducer(addressName1);
            producer2.send((org.apache.activemq.artemis.api.core.Message)session2.createMessage(true));
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.CLIENT_ID.getName()), (String)ProducerField.CLIENT_ID.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)addressName1.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersLargeMessages() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientSession session2 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            producer1.send((org.apache.activemq.artemis.api.core.Message)session1.createMessage(true));
            ClientProducer producer2 = session2.createProducer(addressName1);
            producer2.send((org.apache.activemq.artemis.api.core.Message)session2.createMessage(true));
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.CLIENT_ID.getName()), (String)ProducerField.CLIENT_ID.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)addressName1.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersAsJSONAgainstServer() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            producer1.send((org.apache.activemq.artemis.api.core.Message)session1.createMessage(true));
            String producersAsJsonString = serverControl.listProducersInfoAsJSON();
            JsonArray array = JsonUtil.readJsonArray((String)producersAsJsonString);
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            if (!jsonSession.getString(ProducerField.ADDRESS.getAlternativeName()).equalsIgnoreCase(addressName1.toString())) {
                jsonSession = array.getJsonObject(1);
            }
            ServerProducer producer = (ServerProducer)this.server.getSessionByID(jsonSession.getString(ProducerField.SESSION.getAlternativeName())).getServerProducers().iterator().next();
            Assertions.assertEquals((Object)String.valueOf(producer.getID()), (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
            Assertions.assertEquals((Object)producer.getName(), (Object)jsonSession.getString(ProducerField.NAME.getName()), (String)ProducerField.NAME.getName());
            Assertions.assertEquals((Object)producer.getSessionID(), (Object)jsonSession.getString(ProducerField.SESSION.getAlternativeName()), (String)ProducerField.SESSION.getName());
            Assertions.assertEquals((Object)producer.getAddress(), (Object)jsonSession.getString(ProducerField.ADDRESS.getAlternativeName()), (String)ProducerField.ADDRESS.getName());
            Assertions.assertEquals((long)producer.getMessagesSent(), (long)jsonSession.getJsonNumber(ProducerField.MESSAGE_SENT.getName()).longValue(), (String)ProducerField.MESSAGE_SENT.getName());
            Assertions.assertEquals((long)producer.getMessagesSentSize(), (long)jsonSession.getJsonNumber(ProducerField.MESSAGE_SENT_SIZE.getName()).longValue(), (String)ProducerField.MESSAGE_SENT_SIZE.getName());
            Assertions.assertEquals((Object)String.valueOf(producer.getCreationTime()), (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
        }
    }

    private int getNumberOfProducers(ActiveMQServer server) {
        AtomicInteger producers = new AtomicInteger();
        server.getSessions().forEach(session -> producers.addAndGet(session.getProducerCount()));
        return producers.get();
    }

    @TestTemplate
    public void testListProducersAgainstServer() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            producer1.send((org.apache.activemq.artemis.api.core.Message)session1.createMessage(true));
            Wait.assertEquals((int)1, () -> this.getNumberOfProducers(this.server));
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            Wait.assertTrue(() -> this.server.getSessionByID(jsonSession.getString(ProducerField.SESSION.getName())) != null);
            ServerProducer producer = (ServerProducer)this.server.getSessionByID(jsonSession.getString(ProducerField.SESSION.getName())).getServerProducers().iterator().next();
            Assertions.assertEquals((Object)String.valueOf(producer.getID()), (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
            Assertions.assertEquals((Object)producer.getSessionID(), (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
            Assertions.assertEquals((Object)producer.getProtocol(), (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
            Assertions.assertEquals((Object)producer.getAddress(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
            Assertions.assertEquals((long)producer.getMessagesSent(), (long)jsonSession.getJsonNumber(ProducerField.MESSAGE_SENT.getName()).longValue(), (String)ProducerField.MESSAGE_SENT.getName());
            Assertions.assertEquals((long)producer.getMessagesSentSize(), (long)jsonSession.getJsonNumber(ProducerField.MESSAGE_SENT_SIZE.getName()).longValue(), (String)ProducerField.MESSAGE_SENT_SIZE.getName());
            Assertions.assertEquals((Object)String.valueOf(producer.getCreationTime()), (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
        }
    }

    @TestTemplate
    public void testListProducersJMSCore() throws Exception {
        this.testListProducersJMS((ConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)}), "CORE");
    }

    @TestTemplate
    public void testListProducersJMSAMQP() throws Exception {
        this.testListProducersJMS((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), "AMQP");
    }

    @TestTemplate
    public void testListProducersJMSOW() throws Exception {
        this.testListProducersJMS((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "CORE");
    }

    public void testListProducersJMS(ConnectionFactory connectionFactory, String protocol) throws Exception {
        String queueName = "my_queue_one";
        SimpleString ssQueueName = SimpleString.of((String)queueName);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(ssQueueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(ssQueueName, RoutingType.ANYCAST, ssQueueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession(false, 1);
            Session session2 = conn.createSession(false, 1);
            MessageProducer producer1 = session1.createProducer((Destination)session1.createQueue(queueName));
            producer1.send(session1.createMessage());
            MessageProducer producer2 = session2.createProducer((Destination)session2.createQueue(queueName));
            producer2.send(session2.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)queueName, (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersJMSLegacy() throws Exception {
        String queueName = "my_queue_one";
        SimpleString ssQueueName = SimpleString.of((String)queueName);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(ssQueueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(ssQueueName, RoutingType.ANYCAST, ssQueueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.getBrokerSessionPlugins().add(new ActiveMQServerSessionPlugin(){

            public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
                super.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes);
            }

            public void afterCreateSession(ServerSession session) throws ActiveMQException {
                try {
                    Field serverProducers = session.getClass().getDeclaredField("serverProducers");
                    serverProducers.setAccessible(true);
                    serverProducers.set(session, new ServerLegacyProducersImpl(session));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory connectionFactory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession();
            Session session2 = conn.createSession();
            MessageProducer producer1 = session1.createProducer((Destination)session1.createQueue(queueName));
            producer1.send(session1.createMessage());
            MessageProducer producer2 = session2.createProducer((Destination)session2.createQueue(queueName));
            producer2.send(session2.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)2, (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)queueName, (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
            session1.close();
            filterString = this.createJsonFilter("", "", "");
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of producers returned from query");
            session2.close();
            filterString = this.createJsonFilter("", "", "");
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of producers returned from query");
        }
    }

    @TestTemplate
    public void testListFqqnProducersJMSLegacy() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        SimpleString FQQNName = SimpleString.of((String)(addressName1 + "::" + queueName1));
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(FQQNName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(FQQNName, RoutingType.ANYCAST, FQQNName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)FQQNName).setAddress(FQQNName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.getBrokerSessionPlugins().add(new ActiveMQServerSessionPlugin(){

            public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
                super.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes);
            }

            public void afterCreateSession(ServerSession session) throws ActiveMQException {
                try {
                    Field serverProducers = session.getClass().getDeclaredField("serverProducers");
                    serverProducers.setAccessible(true);
                    serverProducers.set(session, new ServerLegacyProducersImpl(session));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory connectionFactory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession();
            MessageProducer producer1 = session1.createProducer((Destination)session1.createQueue(FQQNName.toString()));
            producer1.send(session1.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 200);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)1, (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)FQQNName.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListAnonProducersJMSLegacy() throws Exception {
        String queueName = "my_queue_one";
        SimpleString ssQueueName = SimpleString.of((String)queueName);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(ssQueueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(ssQueueName, RoutingType.ANYCAST, ssQueueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        this.server.getBrokerSessionPlugins().add(new ActiveMQServerSessionPlugin(){

            public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
                super.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes);
            }

            public void afterCreateSession(ServerSession session) throws ActiveMQException {
                try {
                    Field serverProducers = session.getClass().getDeclaredField("serverProducers");
                    serverProducers.setAccessible(true);
                    serverProducers.set(session, new ServerLegacyProducersImpl(session));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory connectionFactory = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession();
            MessageProducer producer1 = session1.createProducer(null);
            for (int i = 0; i < 110; ++i) {
                Queue queue = session1.createQueue(queueName + i);
                producer1.send((Destination)queue, session1.createMessage());
            }
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 200);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)100, (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
            session1.close();
            filterString = this.createJsonFilter("", "", "");
            producersAsJsonString = serverControl.listProducers(filterString, 1, 110);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)0, (int)array.size(), (String)"number of producers returned from query");
        }
    }

    @TestTemplate
    public void testListProducersJMSCoreMultipleProducers() throws Exception {
        this.testListProducersJMSMultipleProducers((ConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)}), "CORE");
    }

    @TestTemplate
    public void testListProducersJMSAMQPMultipleProducers() throws Exception {
        this.testListProducersJMSMultipleProducers((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), "AMQP");
    }

    @TestTemplate
    public void testListProducersJMSOpenWireMultipleProducers() throws Exception {
        this.testListProducersJMSMultipleProducers((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "OPENWIRE");
    }

    public void testListProducersJMSMultipleProducers(ConnectionFactory connectionFactory, String protocol) throws Exception {
        String queueName = "my_queue_one";
        SimpleString ssQueueName = SimpleString.of((String)queueName);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(ssQueueName, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(ssQueueName, RoutingType.ANYCAST, ssQueueName, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession(false, 1);
            MessageProducer producer1 = session1.createProducer((Destination)session1.createQueue(queueName));
            producer1.send(session1.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)queueName, (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            MessageProducer producer2 = session1.createProducer((Destination)session1.createQueue(queueName));
            producer2.send(session1.createMessage());
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            producer1.close();
            Wait.assertEquals((int)(1 + this.extraProducers), () -> ((JsonArray)JsonUtil.readJsonObject((String)serverControl.listProducers(filterString, 1, 50)).get((Object)"data")).size());
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersJMSAnonCore() throws Exception {
        this.testListProducersJMSAnon((ConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)}), "CORE");
    }

    @TestTemplate
    public void testListProducersJMSAnonAMQP() throws Exception {
        this.testListProducersJMSAnon((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), "AMQP");
    }

    @TestTemplate
    public void testListProducersJMSAnonOW() throws Exception {
        this.testListProducersJMSAnon((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "OPENWIRE");
    }

    public void testListProducersJMSAnon(ConnectionFactory connectionFactory, String protocol) throws Exception {
        String queueName1 = "my_queue_one";
        String queueName2 = "my_queue_two";
        String queueName3 = "my_queue_three";
        SimpleString ssQueueName1 = SimpleString.of((String)queueName1);
        SimpleString ssQueueName2 = SimpleString.of((String)queueName2);
        SimpleString ssQueueName3 = SimpleString.of((String)queueName3);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(ssQueueName1, RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(ssQueueName2, RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(ssQueueName3, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(ssQueueName1, RoutingType.ANYCAST, ssQueueName1, null, false, false);
            this.server.createQueue(ssQueueName2, RoutingType.ANYCAST, ssQueueName2, null, false, false);
            this.server.createQueue(ssQueueName3, RoutingType.ANYCAST, ssQueueName3, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((String)queueName1).setAddress(queueName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((String)queueName2).setAddress(queueName2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            this.server.createQueue(QueueConfiguration.of((String)queueName3).setAddress(queueName3).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (Connection conn = connectionFactory.createConnection();){
            Session session1 = conn.createSession(false, 1);
            Session session2 = conn.createSession(false, 1);
            Queue queue1 = session1.createQueue(queueName1);
            Queue queue2 = session1.createQueue(queueName2);
            Queue queue3 = session1.createQueue(queueName3);
            MessageProducer producer1 = session1.createProducer(null);
            producer1.send((Destination)queue1, session1.createMessage());
            producer1.send((Destination)queue2, session1.createMessage());
            producer1.send((Destination)queue3, session1.createMessage());
            MessageProducer producer2 = session2.createProducer(null);
            producer2.send((Destination)queue1, session2.createMessage());
            producer2.send((Destination)queue2, session2.createMessage());
            producer2.send((Destination)queue3, session2.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersJMSTopicCore() throws Exception {
        this.testListProducersJMSTopic((ConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)}), "CORE");
    }

    @TestTemplate
    public void testListProducersJMSTopicAMQP() throws Exception {
        this.testListProducersJMSTopic((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), "AMQP");
    }

    @TestTemplate
    public void testListProducersJMSTopicOW() throws Exception {
        this.testListProducersJMSTopic((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "OPENWIRE");
    }

    public void testListProducersJMSTopic(ConnectionFactory connectionFactory, String protocol) throws Exception {
        SimpleString topicName = SimpleString.of((String)"my-topic");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(topicName, RoutingType.MULTICAST));
        if (this.legacyCreateQueue) {
            return;
        }
        this.server.addAddressInfo(new AddressInfo(""));
        try (Connection conn = connectionFactory.createConnection();){
            conn.setClientID("clientID");
            Session session1 = conn.createSession(false, 1);
            Session session2 = conn.createSession(false, 1);
            Topic topic = session1.createTopic(topicName.toString());
            TopicSubscriber mysub1 = session1.createDurableSubscriber(topic, "mysub1");
            TopicSubscriber mysub2 = session2.createDurableSubscriber(topic, "mysub2");
            MessageProducer producer1 = session1.createProducer((Destination)topic);
            producer1.send(session1.createMessage());
            MessageProducer producer2 = session2.createProducer((Destination)session2.createTopic(topicName.toString()));
            producer2.send(session2.createMessage());
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)topicName.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            mysub1.close();
            mysub2.close();
            session1.unsubscribe("mysub1");
            session2.unsubscribe("mysub2");
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size());
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersFQQN() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        SimpleString FQQNName = SimpleString.of((String)(addressName1 + "::" + queueName1));
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientSession session2 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(FQQNName);
            producer1.send((org.apache.activemq.artemis.api.core.Message)session1.createMessage(true));
            ClientProducer producer2 = session2.createProducer(FQQNName);
            producer2.send((org.apache.activemq.artemis.api.core.Message)session2.createMessage(true));
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            boolean foundElement = false;
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonSession = array.getJsonObject(i);
                if (jsonSession.getString("address").equals("activemq.management")) continue;
                foundElement = true;
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
                Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getName());
                Assertions.assertEquals((Object)FQQNName.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
                Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            }
            session1.deleteQueue(queueName1);
            producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(2 + this.extraProducers), (int)array.size());
            Assertions.assertTrue((boolean)foundElement, (String)"Valid session not found");
        }
    }

    @TestTemplate
    public void testListProducersMessageCountsJMSCore() throws Exception {
        this.testListProducersMessageCountsJMS((ConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)}), "CORE");
    }

    @TestTemplate
    public void testListProducersMessageCountsAMQPJMS() throws Exception {
        this.testListProducersMessageCountsJMS((ConnectionFactory)new JmsConnectionFactory("amqp://localhost:61616"), "AMQP");
    }

    @TestTemplate
    public void testListProducersMessageCountsOWJMS() throws Exception {
        this.testListProducersMessageCountsJMS((ConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "OPENWIRE");
    }

    public void testListProducersMessageCountsJMS(ConnectionFactory connectionFactory, String protocol) throws Exception {
        String myQueue = "my_queue";
        SimpleString queueName1 = SimpleString.of((String)myQueue);
        SimpleString addressName1 = SimpleString.of((String)myQueue);
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        int numMessages = 10;
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(myQueue));
            for (int i = 0; i < numMessages; ++i) {
                Message message = session.createMessage();
                producer.send(message);
            }
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
            Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
            Assertions.assertEquals((Object)protocol, (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getAlternativeName());
            Assertions.assertEquals((Object)addressName1.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            Assertions.assertEquals((int)numMessages, (int)jsonSession.getInt(ProducerField.MESSAGE_SENT.getName()), (String)ProducerField.MESSAGE_SENT.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LAST_PRODUCED_MESSAGE_ID.getName()), (String)ProducerField.LAST_PRODUCED_MESSAGE_ID.getName());
        }
    }

    @TestTemplate
    public void testListProducersMessageCounts() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        int numMessages = 10;
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            int messagesSize = 0;
            for (int i = 0; i < numMessages; ++i) {
                ClientMessage message = session1.createMessage(true);
                producer1.send((org.apache.activemq.artemis.api.core.Message)message);
                messagesSize += message.getEncodeSize();
            }
            String filterString = this.createJsonFilter("", "", "");
            String producersAsJsonString = serverControl.listProducers(filterString, 1, 50);
            JsonObject producersAsJsonObject = JsonUtil.readJsonObject((String)producersAsJsonString);
            JsonArray array = (JsonArray)producersAsJsonObject.get((Object)"data");
            Assertions.assertEquals((int)(1 + this.extraProducers), (int)array.size(), (String)"number of producers returned from query");
            JsonObject jsonSession = array.getJsonObject(0);
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getName()), (String)ProducerField.SESSION.getName());
            Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.CLIENT_ID.getName()), (String)ProducerField.CLIENT_ID.getName());
            Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.USER.getName()), (String)ProducerField.USER.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.PROTOCOL.getName()), (String)ProducerField.PROTOCOL.getAlternativeName());
            Assertions.assertEquals((Object)addressName1.toString(), (Object)jsonSession.getString(ProducerField.ADDRESS.getName()), (String)ProducerField.ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.LOCAL_ADDRESS.getName()), (String)ProducerField.LOCAL_ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.REMOTE_ADDRESS.getName()), (String)ProducerField.REMOTE_ADDRESS.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            Assertions.assertEquals((int)numMessages, (int)jsonSession.getInt(ProducerField.MESSAGE_SENT.getName()), (String)ProducerField.MESSAGE_SENT.getName());
            Assertions.assertEquals((int)messagesSize, (int)jsonSession.getInt(ProducerField.MESSAGE_SENT_SIZE.getName()), (String)ProducerField.MESSAGE_SENT_SIZE.getName());
            Assertions.assertEquals((Object)"", (Object)jsonSession.getString(ProducerField.LAST_PRODUCED_MESSAGE_ID.getName()), (String)ProducerField.LAST_PRODUCED_MESSAGE_ID.getName());
        }
    }

    @TestTemplate
    public void testListProducersMessageCounts2() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"my_queue_one");
        SimpleString addressName1 = SimpleString.of((String)"my_address_one");
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(addressName1, RoutingType.ANYCAST, queueName1, null, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        }
        int numMessages = 10;
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);){
            ClientSession session1 = csf.createSession();
            ClientProducer producer1 = session1.createProducer(addressName1);
            int messagesSize = 0;
            for (int i = 0; i < numMessages; ++i) {
                ClientMessage message = session1.createMessage(true);
                producer1.send((org.apache.activemq.artemis.api.core.Message)message);
                messagesSize += message.getEncodeSize();
            }
            String producersAsJsonString = serverControl.listProducersInfoAsJSON();
            JsonArray jsonArray = JsonUtil.readJsonArray((String)producersAsJsonString);
            JsonObject jsonSession = jsonArray.getJsonObject(0);
            if (!jsonSession.getString(ProducerField.ADDRESS.getAlternativeName()).equalsIgnoreCase(addressName1.toString())) {
                jsonSession = jsonArray.getJsonObject(1);
            }
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.ID.getName()), (String)ProducerField.ID.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.NAME.getName()), (String)ProducerField.NAME.getName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.SESSION.getAlternativeName()), (String)ProducerField.SESSION.getAlternativeName());
            Assertions.assertNotEquals((Object)"", (Object)jsonSession.getString(ProducerField.CREATION_TIME.getName()), (String)ProducerField.CREATION_TIME.getName());
            Assertions.assertEquals((int)numMessages, (int)jsonSession.getInt(ProducerField.MESSAGE_SENT.getName()), (String)ProducerField.MESSAGE_SENT.getName());
            Assertions.assertEquals((int)messagesSize, (int)jsonSession.getInt(ProducerField.MESSAGE_SENT_SIZE.getName()), (String)ProducerField.MESSAGE_SENT_SIZE.getName());
            Assertions.assertEquals((Object)JsonValue.NULL, (Object)jsonSession.get((Object)ProducerField.LAST_PRODUCED_MESSAGE_ID.getName()), (String)ProducerField.LAST_PRODUCED_MESSAGE_ID.getName());
        }
    }

    @TestTemplate
    public void testMemoryUsagePercentage() throws Exception {
        int MESSAGE_SIZE = 100000;
        String name1 = "messageUsagePercentage.test.1";
        this.server.stop();
        this.server.getConfiguration().setGlobalMaxSize(-1L);
        this.server.start();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((long)0L, (long)serverControl.getAddressMemoryUsage(), (String)"Memory Usage before adding messages");
        Assertions.assertEquals((int)0, (int)serverControl.getAddressMemoryUsagePercentage(), (String)"MemoryUsagePercentage");
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            if (this.legacyCreateQueue) {
                session.createQueue(name1, RoutingType.ANYCAST, name1);
            } else {
                session.createQueue(QueueConfiguration.of((String)name1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            }
            org.apache.activemq.artemis.core.server.Queue serverQueue = this.server.locateQueue(SimpleString.of((String)name1));
            Assertions.assertFalse((boolean)serverQueue.isDurable());
            ClientProducer producer1 = session.createProducer(name1);
            this.sendMessagesWithPredefinedSize(30, session, producer1, 100000);
            Assertions.assertTrue((3000000L < serverControl.getAddressMemoryUsage() && serverControl.getAddressMemoryUsage() < 3100000L ? (byte)1 : 0) != 0, (String)"Memory Usage within range ");
            Assertions.assertEquals((int)0, (int)serverControl.getAddressMemoryUsagePercentage(), (String)"MemoryUsagePercentage");
        }
    }

    @TestTemplate
    public void testMemoryUsage() throws Exception {
        int MESSAGE_SIZE = 100000;
        String name1 = "messageUsage.test.1";
        String name2 = "messageUsage.test.2";
        this.server.stop();
        this.server.getConfiguration().setGlobalMaxSize(5000000L);
        this.server.start();
        ActiveMQServerControl serverControl = this.createManagementControl();
        Assertions.assertEquals((long)0L, (long)serverControl.getAddressMemoryUsage(), (String)"Memory Usage before adding messages");
        Assertions.assertEquals((int)0, (int)serverControl.getAddressMemoryUsagePercentage(), (String)"MemoryUsagePercentage");
        try (ServerLocator locator = this.createInVMNonHALocator();
             ClientSessionFactory csf = this.createSessionFactory(locator);
             ClientSession session = csf.createSession();){
            if (this.legacyCreateQueue) {
                session.createQueue(name1, RoutingType.ANYCAST, name1);
                session.createQueue(name2, RoutingType.ANYCAST, name2);
            } else {
                session.createQueue(QueueConfiguration.of((String)name1).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
                session.createQueue(QueueConfiguration.of((String)name2).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
            }
            org.apache.activemq.artemis.core.server.Queue serverQueue = this.server.locateQueue(SimpleString.of((String)name1));
            Assertions.assertFalse((boolean)serverQueue.isDurable());
            ClientProducer producer1 = session.createProducer(name1);
            ClientProducer producer2 = session.createProducer(name2);
            this.sendMessagesWithPredefinedSize(10, session, producer1, 100000);
            this.sendMessagesWithPredefinedSize(10, session, producer2, 100000);
            Assertions.assertTrue((2000000L < serverControl.getAddressMemoryUsage() && serverControl.getAddressMemoryUsage() < 0x200B20L ? (byte)1 : 0) != 0, (String)"Memory Usage within range ");
            Assertions.assertTrue((40 <= serverControl.getAddressMemoryUsagePercentage() && 42 >= serverControl.getAddressMemoryUsagePercentage() ? (byte)1 : 0) != 0, (String)"MemoryUsagePercentage");
        }
    }

    @TestTemplate
    public void testConnectorServiceManagement() throws Exception {
        ActiveMQServerControl managementControl = this.createManagementControl();
        managementControl.createConnectorService("myconn", FakeConnectorServiceFactory.class.getCanonicalName(), new HashMap());
        Assertions.assertEquals((int)1, (int)this.server.getConnectorsService().getConnectors().size());
        managementControl.createConnectorService("myconn2", FakeConnectorServiceFactory.class.getCanonicalName(), new HashMap());
        Assertions.assertEquals((int)2, (int)this.server.getConnectorsService().getConnectors().size());
        managementControl.destroyConnectorService("myconn");
        Assertions.assertEquals((int)1, (int)this.server.getConnectorsService().getConnectors().size());
        Assertions.assertEquals((Object)"myconn2", (Object)managementControl.getConnectorServices()[0]);
    }

    @TestTemplate
    public void testCloseCOREclient() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        ServerLocator receiveLocator = this.createInVMNonHALocator();
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer COREclient = receiveClientSession.createConsumer(name);
        ServerSession ss = (ServerSession)this.server.getSessions().iterator().next();
        ServerConsumer sc = (ServerConsumer)ss.getServerConsumers().iterator().next();
        Assertions.assertFalse((boolean)COREclient.isClosed());
        serverControl.closeConsumerWithID(((ClientSessionImpl)receiveClientSession).getName(), Long.toString(sc.sequentialID()));
        Wait.waitFor(() -> COREclient.isClosed());
        Assertions.assertTrue((boolean)COREclient.isClosed());
    }

    @TestTemplate
    public void testCloseJMSclient() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        Connection conn = cf.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)"ConsumerTestTopic");
        MessageConsumer JMSclient = session.createConsumer((Destination)topic, "test1");
        long clientID = -1L;
        String sessionID = ((ClientSessionImpl)((ActiveMQSession)session).getCoreSession()).getName();
        Set sessions = this.server.getSessions();
        for (ServerSession sess : sessions) {
            if (!sess.getName().equals(sessionID.toString())) continue;
            Set serverConsumers = sess.getServerConsumers();
            for (ServerConsumer serverConsumer : serverConsumers) {
                clientID = serverConsumer.sequentialID();
            }
        }
        Assertions.assertFalse((boolean)((ActiveMQMessageConsumer)JMSclient).isClosed());
        serverControl.closeConsumerWithID(sessionID, Long.toString(clientID));
        Wait.waitFor(() -> ((ActiveMQMessageConsumer)JMSclient).isClosed());
        Assertions.assertTrue((boolean)((ActiveMQMessageConsumer)JMSclient).isClosed());
    }

    @TestTemplate
    public void testForceCloseSession() throws Exception {
        this.testForceCloseSession(false, false);
    }

    @TestTemplate
    public void testForceCloseSessionWithError() throws Exception {
        this.testForceCloseSession(true, false);
    }

    @TestTemplate
    public void testForceCloseSessionWithPendingStoreOperation() throws Exception {
        this.testForceCloseSession(false, true);
    }

    private void testForceCloseSession(boolean error, boolean pendingStoreOperation) throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString name = RandomUtil.randomSimpleString();
        boolean durable = true;
        ActiveMQServerControl serverControl = this.createManagementControl();
        this.checkNoResource(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, RoutingType.ANYCAST));
        serverControl.createAddress(address.toString(), "ANYCAST");
        if (this.legacyCreateQueue) {
            serverControl.createQueue(address.toString(), "ANYCAST", name.toString(), null, durable, -1, false, false);
        } else {
            serverControl.createQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(durable)).setAutoCreateAddress(Boolean.valueOf(false)).toJSON());
        }
        ServerLocator receiveLocator = this.createInVMNonHALocator().setCallTimeout(500L);
        ClientSessionFactory receiveCsf = this.createSessionFactory(receiveLocator);
        ClientSession receiveClientSession = receiveCsf.createSession(true, false, false);
        ClientConsumer clientConsumer = receiveClientSession.createConsumer(name);
        Assertions.assertEquals((int)1, (int)this.server.getSessions().size());
        ServerSession serverSession = (ServerSession)this.server.getSessions().iterator().next();
        Assertions.assertEquals((Object)((ClientSessionImpl)receiveClientSession).getName(), (Object)serverSession.getName());
        if (error) {
            serverSession.getSessionContext().onError(0, "error");
        }
        if (pendingStoreOperation) {
            serverSession.getSessionContext().storeLineUp();
        }
        serverControl.closeSessionWithID(serverSession.getConnectionID().toString(), serverSession.getName(), true);
        Wait.assertTrue(() -> serverSession.getServerConsumers().size() == 0, (long)500L);
        Wait.assertTrue(() -> this.server.getSessions().size() == 0, (long)500L);
    }

    @TestTemplate
    public void testAddUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.addUser("x", "x", "x", true);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testRemoveUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.removeUser("x");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testListUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.listUser("x");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testResetUser() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.resetUser("x", "x", "x");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testReplayWithoutDate() throws Exception {
        this.testReplaySimple(false);
    }

    @TestTemplate
    public void testReplayWithDate() throws Exception {
        this.testReplaySimple(true);
    }

    private void testReplaySimple(boolean useDate) throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String queue = "testQueue" + RandomUtil.randomString();
        this.server.addAddressInfo(new AddressInfo(queue).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue).setRoutingType(RoutingType.ANYCAST).setAddress(queue));
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue jmsQueue = session.createQueue(queue);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            producer.send((Message)session.createTextMessage("before"));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            serverControl.replay(queue, queue, null);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            if (useDate) {
                int i;
                serverControl.replay("dontexist", "dontexist", null);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                Thread.sleep(1000L);
                String dateEnd = format.format(new Date());
                Thread.sleep(1000L);
                String dateStart = "19800101000000";
                for (i = 0; i < 100; ++i) {
                    producer.send((Message)session.createTextMessage("after receiving"));
                }
                for (i = 0; i < 100; ++i) {
                    Assertions.assertNotNull((Object)consumer.receive());
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                serverControl.replay(dateStart, dateEnd, queue, queue, null);
                for (i = 0; i < 2; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)"before", (Object)message.getText());
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
            } else {
                serverControl.replay(queue, queue, null);
                for (int i = 0; i < 2; ++i) {
                    Assertions.assertNotNull((Object)consumer.receive(5000L));
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
            }
        }
    }

    @TestTemplate
    public void testReplayFilter() throws Exception {
        ActiveMQServerControl serverControl = this.createManagementControl();
        String queue = "testQueue" + RandomUtil.randomString();
        this.server.addAddressInfo(new AddressInfo(queue).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue).setRoutingType(RoutingType.ANYCAST).setAddress(queue));
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue jmsQueue = session.createQueue(queue);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session.createTextMessage("message " + i);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                Assertions.assertNotNull((Object)consumer.receive(5000L));
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
            serverControl.replay(queue, queue, "i=5");
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)5, (int)message.getIntProperty("i"));
            Assertions.assertEquals((Object)"message 5", (Object)message.getText());
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }

    @TestTemplate
    public void testBrokerConnections() throws Exception {
        class Fake
        implements BrokerConnection {
            String name;
            boolean started = false;

            Fake(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getProtocol() {
                return "fake";
            }

            public void start() throws Exception {
                this.started = true;
            }

            public void stop() throws Exception {
                this.started = false;
            }

            public boolean isStarted() {
                return this.started;
            }

            public BrokerConnectConfiguration getConfiguration() {
                return null;
            }
        }
        Fake fake = new Fake("fake" + UUIDGenerator.getInstance().generateStringUUID());
        this.server.registerBrokerConnection((BrokerConnection)fake);
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            String result = serverControl.listBrokerConnections();
            Assertions.assertTrue((boolean)result.contains(fake.getName()));
            serverControl.startBrokerConnection(fake.getName());
            Assertions.assertTrue((boolean)fake.isStarted());
            serverControl.stopBrokerConnection(fake.getName());
            Assertions.assertFalse((boolean)fake.isStarted());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testManualStopStartEmbeddedWebServer() throws Exception {
        FakeWebServerComponent fake = new FakeWebServerComponent();
        this.server.addExternalComponent((ActiveMQComponent)fake, true);
        Assertions.assertTrue((boolean)fake.isStarted());
        ActiveMQServerControl serverControl = this.createManagementControl();
        serverControl.stopEmbeddedWebServer();
        Assertions.assertFalse((boolean)fake.isStarted());
        serverControl.startEmbeddedWebServer();
        Assertions.assertTrue((boolean)fake.isStarted());
    }

    @TestTemplate
    public void testRestartEmbeddedWebServer() throws Exception {
        FakeWebServerComponent fake = new FakeWebServerComponent();
        this.server.addExternalComponent((ActiveMQComponent)fake, true);
        Assertions.assertTrue((boolean)fake.isStarted());
        ActiveMQServerControl serverControl = this.createManagementControl();
        long time = System.currentTimeMillis();
        Assertions.assertTrue((time >= fake.getStartTime() ? (byte)1 : 0) != 0);
        Assertions.assertTrue((time > fake.getStopTime() ? (byte)1 : 0) != 0);
        Thread.sleep(5L);
        serverControl.restartEmbeddedWebServer();
        Assertions.assertTrue((boolean)serverControl.isEmbeddedWebServerStarted());
        Assertions.assertTrue((time < fake.getStartTime() ? (byte)1 : 0) != 0);
        Assertions.assertTrue((time < fake.getStopTime() ? (byte)1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testRestartEmbeddedWebServerTimeout() throws Exception {
        CountDownLatch startDelay = new CountDownLatch(1);
        FakeWebServerComponent fake = new FakeWebServerComponent(startDelay);
        this.server.addExternalComponent((ActiveMQComponent)fake, false);
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.restartEmbeddedWebServer(1L);
            Assertions.fail();
        }
        catch (ActiveMQTimeoutException activeMQTimeoutException) {
        }
        finally {
            startDelay.countDown();
        }
        Wait.waitFor(() -> fake.isStarted());
    }

    @TestTemplate
    public void testRestartEmbeddedWebServerException() throws Exception {
        String message = RandomUtil.randomString();
        ActiveMQIllegalStateException startException = new ActiveMQIllegalStateException(message);
        FakeWebServerComponent fake = new FakeWebServerComponent((Exception)((Object)startException));
        this.server.addExternalComponent((ActiveMQComponent)fake, false);
        ActiveMQServerControl serverControl = this.createManagementControl();
        try {
            serverControl.restartEmbeddedWebServer(1000L);
            Assertions.fail();
        }
        catch (ActiveMQException e) {
            Assertions.assertSame((Object)((Object)startException), (Object)e.getCause(), (String)"Unexpected cause");
        }
    }

    protected void scaleDown(ScaleDownHandler handler) throws Exception {
        SimpleString address = SimpleString.of((String)"testQueue");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverId", "2");
        Configuration config = this.createDefaultInVMConfig(2).clearAcceptorConfigurations().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName(), params)).setSecurityEnabled(false);
        ActiveMQServer server2 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, null, (boolean)true));
        this.conf.clearConnectorConfigurations().addConnectorConfiguration("server2-connector", new TransportConfiguration(INVM_CONNECTOR_FACTORY, params));
        server2.start();
        this.server.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            this.server.createQueue(address, RoutingType.ANYCAST, address, null, true, false, -1, false, false);
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        server2.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
        if (this.legacyCreateQueue) {
            server2.createQueue(address, RoutingType.ANYCAST, address, null, true, false, -1, false, false);
        } else {
            server2.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(false)));
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession();
        ClientProducer producer = session.createProducer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ActiveMQServerControl managementControl = this.createManagementControl();
        handler.scaleDown(managementControl);
        locator.close();
        locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY, params)}));
        csf = this.createSessionFactory(locator);
        session = csf.createSession();
        session.start();
        ClientConsumer consumer = session.createConsumer(address);
        for (int i = 0; i < 100; ++i) {
            ClientMessage m = consumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.connectorConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        this.conf = this.createDefaultNettyConfig().setJMXManagementEnabled(true).addConnectorConfiguration(this.connectorConfig.getName(), this.connectorConfig);
        this.conf.setSecurityEnabled(true);
        SecurityConfiguration securityConfiguration = new SecurityConfiguration();
        securityConfiguration.addUser("guest", "guest");
        securityConfiguration.addUser("myUser", "myPass");
        securityConfiguration.addUser("none", "none");
        securityConfiguration.addRole("guest", "guest");
        securityConfiguration.addRole("myUser", "guest");
        securityConfiguration.addRole("none", "none");
        securityConfiguration.setDefaultUser("guest");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), securityConfiguration);
        this.conf.setJournalRetentionDirectory(this.conf.getJournalDirectory() + "_ret");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.conf, (MBeanServer)this.mbeanServer, (ActiveMQSecurityManager)securityManager, (boolean)true));
        this.server.getConfiguration().setAddressQueueScanPeriod(100L);
        this.server.start();
        HashSet<Role> role = new HashSet<Role>();
        role.add(new Role("guest", true, true, true, true, true, true, true, true, true, true, false, false));
        role.add(new Role("none", false, false, false, false, false, false, false, false, false, false, false, false));
        this.server.getSecurityRepository().addMatch("#", role);
    }

    protected ActiveMQServerControl createManagementControl() throws Exception {
        return ManagementControlHelper.createActiveMQServerControl(this.mbeanServer);
    }

    private String createJsonFilter(String fieldName, String operationName, String value, String sortColumn, String sortOrder) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("field", fieldName);
        filterMap.put("operation", operationName);
        filterMap.put("value", value);
        filterMap.put("sortColumn", sortColumn);
        filterMap.put("sortOrder", sortOrder);
        JsonObject jsonFilterObject = JsonUtil.toJsonObject(filterMap);
        return jsonFilterObject.toString();
    }

    private void sendMessagesWithPredefinedSize(int numberOfMessages, ClientSession session, ClientProducer producer, int messageSize) throws Exception {
        int i;
        byte[] body = new byte[messageSize];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (i = 1; i <= messageSize; ++i) {
            bb.put(ActiveMQServerControlTest.getSamplebyte(i));
        }
        for (i = 0; i < numberOfMessages; ++i) {
            ClientMessage message = session.createMessage(true);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
    }

    private static class TestBrokerPlugin
    implements ActiveMQServerPlugin {
        private TestBrokerPlugin() {
        }

        public void registered(ActiveMQServer server) {
        }
    }

    static interface ScaleDownHandler {
        public void scaleDown(ActiveMQServerControl var1) throws Exception;
    }

    class FakeWebServerComponent
    implements ServiceComponent,
    WebServerComponentMarker {
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicLong startTime = new AtomicLong(0L);
        AtomicLong stopTime = new AtomicLong(0L);
        CountDownLatch startDelay;
        Exception startException;

        FakeWebServerComponent(CountDownLatch startDelay) {
            this.startDelay = startDelay;
        }

        FakeWebServerComponent(Exception startException) {
            this.startException = startException;
        }

        FakeWebServerComponent() {
        }

        public void start() throws Exception {
            if (this.started.get()) {
                return;
            }
            if (this.startDelay != null) {
                this.startDelay.await();
            }
            if (this.startException != null) {
                throw this.startException;
            }
            this.startTime.set(System.currentTimeMillis());
            this.started.set(true);
        }

        public void stop() throws Exception {
            this.stop(false);
        }

        public void stop(boolean shutdown) throws Exception {
            if (!shutdown) {
                throw new RuntimeException("shutdown flag must be true");
            }
            this.stopTime.set(System.currentTimeMillis());
            this.started.set(false);
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public long getStartTime() {
            return this.startTime.get();
        }

        public long getStopTime() {
            return this.stopTime.get();
        }
    }
}

