/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsTopicRedeliverTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSDurableTopicRedeliverTest
extends JmsTopicRedeliverTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.durable = true;
        super.setUp();
    }

    @Test
    public void testRedeliverNewSession() throws Exception {
        String text = "TEST: " + System.currentTimeMillis();
        TextMessage sendMessage = this.session.createTextMessage(text);
        this.producer.send(this.producerDestination, (Message)sendMessage);
        Message unackMessage = this.consumer.receive(1000L);
        Assertions.assertNotNull((Object)unackMessage);
        String unackId = unackMessage.getJMSMessageID();
        Assertions.assertEquals((Object)((TextMessage)unackMessage).getText(), (Object)text);
        Assertions.assertFalse((boolean)unackMessage.getJMSRedelivered());
        Assertions.assertEquals((int)unackMessage.getIntProperty("JMSXDeliveryCount"), (int)1);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer(this.getName());
        Message ackMessage = this.consumer.receive(1000L);
        Assertions.assertNotNull((Object)ackMessage);
        ackMessage.acknowledge();
        String ackId = ackMessage.getJMSMessageID();
        Assertions.assertEquals((Object)((TextMessage)ackMessage).getText(), (Object)text);
        Assertions.assertEquals((int)2, (int)ackMessage.getIntProperty("JMSXDeliveryCount"));
        Assertions.assertEquals((Object)unackId, (Object)ackId);
        this.consumeSession.close();
        this.consumer.close();
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumer = this.createConsumer(this.getName());
        Assertions.assertNull((Object)this.consumer.receive(1000L));
    }

    @Override
    protected String getName() {
        return "JMSDurableTopicRedeliverTest";
    }
}

