/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTransactionCleanupTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testPageTXCleanup() throws Throwable {
        int PAGE_MAX = 102400;
        int PAGE_SIZE = 10240;
        Configuration config = this.createDefaultConfig(true).setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap<String, AddressSettings>());
        server.start();
        Queue queue1 = server.createQueue(QueueConfiguration.of((String)"test1").setRoutingType(RoutingType.ANYCAST));
        Queue queue2 = server.createQueue(QueueConfiguration.of((String)"test2").setRoutingType(RoutingType.ANYCAST));
        queue1.getPagingStore().startPaging();
        queue2.getPagingStore().startPaging();
        ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        int NUMBER_OF_MESSAGES = 30;
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 1);
            for (int producerID = 1; producerID <= 2; ++producerID) {
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test" + producerID));
                for (int i = 0; i < 30; ++i) {
                    producer.send((Message)session.createTextMessage("hello " + i));
                    session.commit();
                }
            }
        }
        PagingStoreImpl store = (PagingStoreImpl)queue1.getPagingStore();
        File folder = store.getFolder();
        server.stop();
        for (String fileName : folder.list((dir, f) -> f.endsWith(".page"))) {
            File fileToRemove = new File(folder, fileName);
            fileToRemove.delete();
            logger.debug("removing file {}", (Object)fileToRemove);
        }
        HashMap<Integer, AtomicInteger> journalCount = this.countJournal(server.getConfiguration());
        Assertions.assertEquals((int)60, (int)journalCount.get(35).get());
        try (AssertionLoggerHandler handler = new AssertionLoggerHandler();){
            server.start();
            Wait.assertTrue(() -> handler.findText(new String[]{"AMQ224132"}));
        }
        server.getStorageManager().getMessageJournal().scheduleCompactAndBlock(60000);
        journalCount = this.countJournal(server.getConfiguration());
        Assertions.assertEquals((int)30, (int)journalCount.get(35).get());
        server.stop();
        server.start();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 1);
            connection.start();
            for (int producerID = 1; producerID <= 2; ++producerID) {
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("test" + producerID));
                for (int i = 0; i < (producerID == 1 ? 0 : 30); ++i) {
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message, (String)("message not received on producer + " + producerID + ", message " + i));
                    Assertions.assertEquals((Object)("hello " + i), (Object)message.getText(), (String)("could not find message " + i + " on producerID=" + producerID));
                    session.commit();
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                consumer.close();
            }
        }
    }
}

