/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithMessageIDTest
extends StompTestBase {
    @Override
    public boolean isEnableStompMessageId() {
        return true;
    }

    @TestTemplate
    public void testEnableMessageID() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithMessageIDTest.getQueuePrefix() + StompWithMessageIDTest.getQueueName());
        frame.setBody("Hello World 1");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithMessageIDTest.getQueuePrefix() + StompWithMessageIDTest.getQueueName());
        frame.setBody("Hello World 2");
        conn.sendFrame(frame);
        QueueBrowser browser = this.session.createBrowser(this.queue);
        Enumeration enu = browser.getEnumeration();
        while (enu.hasMoreElements()) {
            Message msg = (Message)enu.nextElement();
            String msgId = msg.getStringProperty("amqMessageId");
            Assertions.assertNotNull((Object)msgId);
            Assertions.assertTrue((msgId.indexOf("STOMP") == 0 ? (byte)1 : 0) != 0);
        }
        browser.close();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)message);
        conn.disconnect();
    }
}

