/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public class NetworkUtils {
    private static final int MAX_GROUP_LENGTH = 4;
    private static final int IPV6_LEN = 8;
    private static final boolean can_bind_to_mcast_addr = NetworkUtils.checkForLinux() || NetworkUtils.checkForSolaris() || NetworkUtils.checkForHp();

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return null;
        }
        String ipv6Address = address.startsWith("[") && address.endsWith("]") ? address.substring(0, address.lastIndexOf(93)).substring(1) : address;
        if (!NetworkUtils.mayBeIPv6Address(ipv6Address)) {
            return ipv6Address;
        }
        return "[" + NetworkUtils.canonize(ipv6Address) + "]";
    }

    public static String canonize(String ipv6Address) throws IllegalArgumentException {
        if (ipv6Address == null) {
            return null;
        }
        if (!NetworkUtils.mayBeIPv6Address(ipv6Address)) {
            return ipv6Address;
        }
        int ipv6AddressLength = ipv6Address.length();
        if (NetworkUtils.isIPv4AddressInIPv6(ipv6Address)) {
            int lastColonPos = ipv6Address.lastIndexOf(":");
            int lastColonsPos = ipv6Address.lastIndexOf("::");
            ipv6AddressLength = lastColonsPos >= 0 && lastColonPos == lastColonsPos + 1 ? lastColonPos + 1 : lastColonPos;
        } else if (ipv6Address.contains(":") && ipv6Address.contains("%")) {
            ipv6AddressLength = ipv6Address.lastIndexOf("%");
        }
        StringBuilder result = new StringBuilder();
        char[][] groups = new char[8][4];
        int groupCounter = 0;
        int charInGroupCounter = 0;
        int zeroGroupIndex = -1;
        int zeroGroupLength = 0;
        int maxZeroGroupIndex = -1;
        int maxZeroGroupLength = 0;
        boolean isZero = true;
        boolean groupStart = true;
        StringBuilder expanded = new StringBuilder(ipv6Address);
        int colonsPos = ipv6Address.indexOf("::");
        int length = ipv6AddressLength;
        int change = 0;
        if (colonsPos >= 0 && colonsPos < ipv6AddressLength - 2) {
            int i;
            int colonCounter = 0;
            for (i = 0; i < ipv6AddressLength; ++i) {
                if (ipv6Address.charAt(i) != ':') continue;
                ++colonCounter;
            }
            if (colonsPos == 0) {
                expanded.insert(0, "0");
                ++change;
            }
            for (i = 0; i < 8 - colonCounter; ++i) {
                expanded.insert(colonsPos + 1, "0:");
                change += 2;
            }
            if (colonsPos == ipv6AddressLength - 2) {
                expanded.setCharAt(colonsPos + change + 1, '0');
            } else {
                expanded.deleteCharAt(colonsPos + change + 1);
                --change;
            }
            length += change;
        }
        for (int charCounter = 0; charCounter < length; ++charCounter) {
            char c = expanded.charAt(charCounter);
            if (c >= 'A' && c <= 'F') {
                c = (char)(c + 32);
            }
            if (c != ':') {
                groups[groupCounter][charInGroupCounter] = c;
                if (!groupStart || c != '0') {
                    ++charInGroupCounter;
                    groupStart = false;
                }
                if (c != '0') {
                    isZero = false;
                }
            }
            if (c != ':' && charCounter != length - 1) continue;
            if (isZero) {
                ++zeroGroupLength;
                if (zeroGroupIndex == -1) {
                    zeroGroupIndex = groupCounter;
                }
            }
            if (!isZero || charCounter == length - 1) {
                if (zeroGroupLength > maxZeroGroupLength) {
                    maxZeroGroupLength = zeroGroupLength;
                    maxZeroGroupIndex = zeroGroupIndex;
                }
                zeroGroupLength = 0;
                zeroGroupIndex = -1;
            }
            ++groupCounter;
            charInGroupCounter = 0;
            isZero = true;
            groupStart = true;
        }
        int numberOfGroups = groupCounter;
        for (groupCounter = 0; groupCounter < numberOfGroups; ++groupCounter) {
            if (maxZeroGroupLength <= 1 || groupCounter < maxZeroGroupIndex || groupCounter >= maxZeroGroupIndex + maxZeroGroupLength) {
                for (int j = 0; j < 4; ++j) {
                    if (groups[groupCounter][j] == '\u0000') continue;
                    result.append(groups[groupCounter][j]);
                }
                if (groupCounter >= numberOfGroups - 1 || groupCounter == maxZeroGroupIndex - 1 && maxZeroGroupLength > 1) continue;
                result.append(':');
                continue;
            }
            if (groupCounter != maxZeroGroupIndex) continue;
            result.append("::");
        }
        int resultLength = result.length();
        if (result.charAt(resultLength - 1) == ':' && ipv6AddressLength < ipv6Address.length() && ipv6Address.charAt(ipv6AddressLength) == ':') {
            result.delete(resultLength - 1, resultLength);
        }
        for (int i = ipv6AddressLength; i < ipv6Address.length(); ++i) {
            result.append(ipv6Address.charAt(i));
        }
        return result.toString();
    }

    private static boolean mayBeIPv6Address(String input) {
        char c;
        if (input == null) {
            return false;
        }
        boolean result = false;
        int colonsCounter = 0;
        int length = input.length();
        for (int i = 0; i < length && (c = input.charAt(i)) != '.' && c != '%'; ++i) {
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == ':')) {
                return false;
            }
            if (c != ':') continue;
            ++colonsCounter;
        }
        if (colonsCounter >= 2) {
            result = true;
        }
        return result;
    }

    private static boolean isIPv4AddressInIPv6(String ipv6Address) {
        return ipv6Address.contains(":") && ipv6Address.contains(".");
    }

    public static String formatIPAddressForURI(InetAddress inet) {
        Assert.checkNotNullParam((String)"inet", (Object)inet);
        if (inet instanceof Inet4Address) {
            return inet.getHostAddress();
        }
        if (inet instanceof Inet6Address) {
            return "[" + NetworkUtils.formatAddress(inet) + "]";
        }
        return inet.getHostAddress();
    }

    public static String formatAddress(InetAddress inet) {
        Assert.checkNotNullParam((String)"inet", (Object)inet);
        if (inet instanceof Inet4Address) {
            return inet.getHostAddress();
        }
        if (inet instanceof Inet6Address) {
            byte[] byteRepresentation = inet.getAddress();
            int[] hexRepresentation = new int[8];
            for (int i = 0; i < hexRepresentation.length; ++i) {
                hexRepresentation[i] = (byteRepresentation[2 * i] & 0xFF) << 8 | byteRepresentation[2 * i + 1] & 0xFF;
            }
            NetworkUtils.compactLongestZeroSequence(hexRepresentation);
            return NetworkUtils.formatAddress6(hexRepresentation);
        }
        return inet.getHostAddress();
    }

    public static String formatAddress(InetSocketAddress inet) {
        Assert.checkNotNullParamWithNullPointerException((String)"inet", (Object)inet);
        StringBuilder result = new StringBuilder();
        if (inet.isUnresolved()) {
            result.append(inet.getHostName());
        } else {
            result.append(NetworkUtils.formatPossibleIpv6Address(NetworkUtils.formatAddress(inet.getAddress())));
        }
        result.append(":").append(inet.getPort());
        return result.toString();
    }

    private static String formatAddress6(int[] hexRepresentation) {
        Assert.checkNotNullParamWithNullPointerException((String)"hexRepresentation", (Object)hexRepresentation);
        if (hexRepresentation.length != 8) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean inCompressedSection = false;
        for (int i = 0; i < hexRepresentation.length; ++i) {
            if (hexRepresentation[i] == -1) {
                if (inCompressedSection) continue;
                inCompressedSection = true;
                if (i == 0) {
                    stringBuilder.append("::");
                    continue;
                }
                stringBuilder.append(':');
                continue;
            }
            inCompressedSection = false;
            stringBuilder.append(Integer.toHexString(hexRepresentation[i]));
            if (i + 1 >= hexRepresentation.length) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    public static boolean isBindingToMulticastAddressSupported() {
        return can_bind_to_mcast_addr;
    }

    private static void compactLongestZeroSequence(int[] hexRepresentatoin) {
        int bestRunStart = -1;
        int bestRunLen = -1;
        boolean inRun = false;
        int runStart = -1;
        for (int i = 0; i < hexRepresentatoin.length; ++i) {
            if (hexRepresentatoin[i] == 0) {
                if (inRun) continue;
                runStart = i;
                inRun = true;
                continue;
            }
            if (!inRun) continue;
            inRun = false;
            int runLen = i - runStart;
            if (bestRunLen < 0) {
                bestRunStart = runStart;
                bestRunLen = runLen;
                continue;
            }
            if (runLen <= bestRunLen) continue;
            bestRunStart = runStart;
            bestRunLen = runLen;
        }
        if (bestRunStart >= 0) {
            Arrays.fill(hexRepresentatoin, bestRunStart, bestRunStart + bestRunLen, -1);
        }
    }

    private static boolean checkForLinux() {
        return NetworkUtils.checkForPresence("os.name", "linux");
    }

    private static boolean checkForHp() {
        return NetworkUtils.checkForPresence("os.name", "hp");
    }

    private static boolean checkForSolaris() {
        return NetworkUtils.checkForPresence("os.name", "sun");
    }

    private static boolean checkForWindows() {
        return NetworkUtils.checkForPresence("os.name", "win");
    }

    public static boolean checkForMac() {
        return NetworkUtils.checkForPresence("os.name", "mac");
    }

    private static boolean checkForPresence(String key, String value) {
        String tmp = WildFlySecurityManager.getPropertyPrivileged((String)key, (String)value);
        try {
            return tmp != null && tmp.trim().toLowerCase(Locale.ENGLISH).startsWith(value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private NetworkUtils() {
    }
}

