/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.core.apiimpl.BasicMeteredOperationImpl;
import io.smallrye.faulttolerance.core.apiimpl.BuilderEagerDependencies;
import io.smallrye.faulttolerance.core.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.core.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.core.apiimpl.GuardCommon;
import io.smallrye.faulttolerance.core.apiimpl.LazyTypedGuard;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.async.SyncAsyncSplit;
import io.smallrye.faulttolerance.core.async.ThreadOffload;
import io.smallrye.faulttolerance.core.bulkhead.Bulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.ConstantInvoker;
import io.smallrye.faulttolerance.core.metrics.DelegatingMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.rate.limit.RateLimit;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.PredicateBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedResultDecision;
import io.smallrye.faulttolerance.core.util.ResultDecision;
import io.smallrye.faulttolerance.core.util.SetBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.lang.reflect.Type;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class TypedGuardImpl<V, T>
implements TypedGuard<T> {
    private final FaultToleranceStrategy<V> strategy;
    private final AsyncSupport<V, T> asyncSupport;
    private final EventHandlers eventHandlers;

    TypedGuardImpl(FaultToleranceStrategy<V> strategy, AsyncSupport<V, T> asyncSupport, EventHandlers eventHandlers) {
        this.strategy = strategy;
        this.asyncSupport = asyncSupport;
        this.eventHandlers = eventHandlers;
    }

    public T call(Callable<T> action) throws Exception {
        return this.guard(action);
    }

    public T get(Supplier<T> action) {
        try {
            return (T)this.guard(action::get);
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    private T guard(Callable<T> action) throws Exception {
        AsyncInvocation<V, T> asyncInvocation = GuardCommon.asyncInvocation(action, this.asyncSupport);
        return GuardCommon.guard(action, this.strategy, asyncInvocation, this.eventHandlers, null);
    }

    public T guard(Callable<T> action, AsyncInvocation<V, T> asyncInvocation, Consumer<FaultToleranceContext<?>> contextModifier) throws Exception {
        return GuardCommon.guard(action, this.strategy, asyncInvocation, this.eventHandlers, contextModifier);
    }

    public static class BuilderImpl<V, T>
    implements TypedGuard.Builder<T> {
        private final BuilderEagerDependencies eagerDependencies;
        private final Supplier<BuilderLazyDependencies> lazyDependencies;
        private final AsyncSupport<V, T> asyncSupport;
        private String description;
        private BulkheadBuilderImpl<V, T> bulkheadBuilder;
        private CircuitBreakerBuilderImpl<V, T> circuitBreakerBuilder;
        private FallbackBuilderImpl<V, T> fallbackBuilder;
        private RateLimitBuilderImpl<V, T> rateLimitBuilder;
        private RetryBuilderImpl<V, T> retryBuilder;
        private TimeoutBuilderImpl<V, T> timeoutBuilder;
        private boolean offloadToAnotherThread;
        private Executor offloadExecutor;

        public BuilderImpl(BuilderEagerDependencies eagerDependencies, Supplier<BuilderLazyDependencies> lazyDependencies, Type valueType) {
            this.eagerDependencies = eagerDependencies;
            this.lazyDependencies = lazyDependencies;
            this.asyncSupport = GuardCommon.asyncSupport(valueType);
            this.description = UUID.randomUUID().toString();
        }

        public TypedGuard.Builder<T> withDescription(String value) {
            this.description = Preconditions.checkNotNull(value, "Description must be set");
            return this;
        }

        public TypedGuard.Builder.BulkheadBuilder<T> withBulkhead() {
            return new BulkheadBuilderImpl(this);
        }

        public TypedGuard.Builder.CircuitBreakerBuilder<T> withCircuitBreaker() {
            return new CircuitBreakerBuilderImpl(this);
        }

        public TypedGuard.Builder.FallbackBuilder<T> withFallback() {
            return new FallbackBuilderImpl(this);
        }

        public TypedGuard.Builder.RateLimitBuilder<T> withRateLimit() {
            return new RateLimitBuilderImpl(this);
        }

        public TypedGuard.Builder.RetryBuilder<T> withRetry() {
            return new RetryBuilderImpl(this);
        }

        public TypedGuard.Builder.TimeoutBuilder<T> withTimeout() {
            return new TimeoutBuilderImpl(this);
        }

        public TypedGuard.Builder<T> withThreadOffload(boolean value) {
            this.offloadToAnotherThread = value;
            return this;
        }

        public TypedGuard.Builder<T> withThreadOffloadExecutor(Executor executor) {
            this.offloadExecutor = Preconditions.checkNotNull(executor, "Thread offload executor must be set");
            return this;
        }

        public TypedGuard<T> build() {
            this.eagerInitialization();
            return new LazyTypedGuard(() -> new TypedGuardImpl<V, T>(this.buildStrategy(this.lazyDependencies.get()), this.asyncSupport, this.buildEventHandlers()));
        }

        final void eagerInitialization() {
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                this.eagerDependencies.cbMaintenance().registerName(this.circuitBreakerBuilder.name);
            }
        }

        final EventHandlers buildEventHandlers() {
            Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler = null;
            if (this.circuitBreakerBuilder != null && this.circuitBreakerBuilder.name != null) {
                cbMaintenanceEventHandler = this.eagerDependencies.cbMaintenance().stateTransitionEventHandler(this.circuitBreakerBuilder.name);
            }
            return new EventHandlers(this.bulkheadBuilder != null ? this.bulkheadBuilder.onAccepted : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onRejected : null, this.bulkheadBuilder != null ? this.bulkheadBuilder.onFinished : null, cbMaintenanceEventHandler, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onStateChange : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onSuccess : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onFailure : null, this.circuitBreakerBuilder != null ? this.circuitBreakerBuilder.onPrevented : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onPermitted : null, this.rateLimitBuilder != null ? this.rateLimitBuilder.onRejected : null, this.retryBuilder != null ? this.retryBuilder.onRetry : null, this.retryBuilder != null ? this.retryBuilder.onSuccess : null, this.retryBuilder != null ? this.retryBuilder.onFailure : null, this.timeoutBuilder != null ? this.timeoutBuilder.onTimeout : null, this.timeoutBuilder != null ? this.timeoutBuilder.onFinished : null);
        }

        final FaultToleranceStrategy<V> buildStrategy(BuilderLazyDependencies lazyDependencies) {
            FaultToleranceStrategy result = Invocation.invocation();
            Executor executor = this.offloadExecutor != null ? this.offloadExecutor : lazyDependencies.asyncExecutor();
            result = new SyncAsyncSplit(new ThreadOffload(result, executor, this.offloadToAnotherThread), result);
            if (lazyDependencies.ftEnabled() && this.bulkheadBuilder != null) {
                result = new Bulkhead(result, this.description, this.bulkheadBuilder.limit, this.bulkheadBuilder.queueSize, this.bulkheadBuilder.syncQueueingEnabled);
            }
            if (lazyDependencies.ftEnabled() && this.timeoutBuilder != null) {
                result = new Timeout(result, this.description, this.timeoutBuilder.durationInMillis, lazyDependencies.timer());
            }
            if (lazyDependencies.ftEnabled() && this.rateLimitBuilder != null) {
                result = new RateLimit(result, this.description, this.rateLimitBuilder.maxInvocations, this.rateLimitBuilder.timeWindowInMillis, this.rateLimitBuilder.minSpacingInMillis, this.rateLimitBuilder.type, SystemStopwatch.INSTANCE);
            }
            if (lazyDependencies.ftEnabled() && this.circuitBreakerBuilder != null) {
                result = new CircuitBreaker(result, this.description, BuilderImpl.createExceptionDecision(this.circuitBreakerBuilder.skipOn, this.circuitBreakerBuilder.failOn, this.circuitBreakerBuilder.whenPredicate), this.circuitBreakerBuilder.delayInMillis, this.circuitBreakerBuilder.requestVolumeThreshold, this.circuitBreakerBuilder.failureRatio, this.circuitBreakerBuilder.successThreshold, SystemStopwatch.INSTANCE, lazyDependencies.timer());
                if (this.circuitBreakerBuilder.name != null) {
                    CircuitBreaker circuitBreaker = (CircuitBreaker)result;
                    this.eagerDependencies.cbMaintenance().register(this.circuitBreakerBuilder.name, circuitBreaker);
                }
            }
            if (lazyDependencies.ftEnabled() && this.retryBuilder != null) {
                Supplier<BackOff> backoff = BuilderImpl.prepareRetryBackoff(this.retryBuilder);
                result = new Retry(result, this.description, BuilderImpl.createResultDecision(this.retryBuilder.whenResultPredicate), BuilderImpl.createExceptionDecision(this.retryBuilder.abortOn, this.retryBuilder.retryOn, this.retryBuilder.whenExceptionPredicate), this.retryBuilder.maxRetries, this.retryBuilder.maxDurationInMillis, () -> new ThreadSleepDelay((BackOff)backoff.get()), () -> new TimerDelay((BackOff)backoff.get(), lazyDependencies.timer()), SystemStopwatch.INSTANCE, this.retryBuilder.beforeRetry != null ? ctx -> this.retryBuilder.beforeRetry.accept(ctx.failure) : null);
            }
            FallbackFunction fallbackFunction = FallbackFunction.ignore();
            ExceptionDecision exceptionDecision = ExceptionDecision.IGNORE;
            if (this.fallbackBuilder != null) {
                fallbackFunction = this.asyncSupport != null ? ctx -> {
                    try {
                        return this.asyncSupport.toFuture(ConstantInvoker.of(this.fallbackBuilder.handler.apply(ctx.failure)));
                    }
                    catch (Exception e) {
                        return Future.ofError(e);
                    }
                } : ctx -> Future.from(() -> this.fallbackBuilder.handler.apply(ctx.failure));
                exceptionDecision = BuilderImpl.createExceptionDecision(this.fallbackBuilder.skipOn, this.fallbackBuilder.applyOn, this.fallbackBuilder.whenPredicate);
            }
            result = new Fallback(result, this.description, fallbackFunction, exceptionDecision);
            MetricsProvider metricsProvider = lazyDependencies.metricsProvider();
            if (metricsProvider.isEnabled()) {
                MeteredOperation defaultOperation = this.buildMeteredOperation();
                result = new DelegatingMetricsCollector(result, metricsProvider, defaultOperation);
            }
            result = new SyncAsyncSplit(new RememberEventLoop(result, lazyDependencies.eventLoop(), this.offloadToAnotherThread), result);
            return result;
        }

        private MeteredOperation buildMeteredOperation() {
            return new BasicMeteredOperationImpl(this.description, this.asyncSupport != null, this.bulkheadBuilder != null, this.circuitBreakerBuilder != null, false, this.rateLimitBuilder != null, this.retryBuilder != null, this.timeoutBuilder != null);
        }

        private static ResultDecision createResultDecision(Predicate<Object> whenResultPredicate) {
            if (whenResultPredicate != null) {
                return new PredicateBasedResultDecision(whenResultPredicate.negate());
            }
            return ResultDecision.ALWAYS_EXPECTED;
        }

        static ExceptionDecision createExceptionDecision(Collection<Class<? extends Throwable>> consideredExpected, Collection<Class<? extends Throwable>> consideredFailure, Predicate<Throwable> whenExceptionPredicate) {
            if (whenExceptionPredicate != null) {
                return new PredicateBasedExceptionDecision(whenExceptionPredicate.negate());
            }
            return new SetBasedExceptionDecision(BuilderImpl.createSetOfThrowables(consideredFailure), BuilderImpl.createSetOfThrowables(consideredExpected), true);
        }

        private static SetOfThrowables createSetOfThrowables(Collection<Class<? extends Throwable>> throwableClasses) {
            return throwableClasses == null ? SetOfThrowables.EMPTY : SetOfThrowables.create(throwableClasses);
        }

        private static Supplier<BackOff> prepareRetryBackoff(RetryBuilderImpl<?, ?> retryBuilder) {
            Jitter jitter;
            long jitterMs = retryBuilder.jitterInMillis;
            Jitter jitter2 = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            if (retryBuilder.exponentialBackoffBuilder != null) {
                int factor = retryBuilder.exponentialBackoffBuilder.factor;
                long maxDelay = retryBuilder.exponentialBackoffBuilder.maxDelayInMillis;
                return () -> new ExponentialBackOff(retryBuilder.delayInMillis, factor, jitter, maxDelay);
            }
            if (retryBuilder.fibonacciBackoffBuilder != null) {
                long maxDelay = retryBuilder.fibonacciBackoffBuilder.maxDelayInMillis;
                return () -> new FibonacciBackOff(retryBuilder.delayInMillis, jitter, maxDelay);
            }
            if (retryBuilder.customBackoffBuilder != null) {
                Supplier<CustomBackoffStrategy> strategy = retryBuilder.customBackoffBuilder.strategy;
                return () -> {
                    CustomBackoffStrategy instance = (CustomBackoffStrategy)strategy.get();
                    instance.init(retryBuilder.delayInMillis);
                    return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
                };
            }
            return () -> new ConstantBackOff(retryBuilder.delayInMillis, jitter);
        }

        static class BulkheadBuilderImpl<V, T>
        implements TypedGuard.Builder.BulkheadBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private int limit = 10;
            private int queueSize = 10;
            private boolean syncQueueingEnabled;
            private Runnable onAccepted;
            private Runnable onRejected;
            private Runnable onFinished;

            BulkheadBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> limit(int value) {
                this.limit = Preconditions.check(value, value >= 1, "Limit must be >= 1");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> queueSize(int value) {
                this.queueSize = Preconditions.check(value, value >= 1, "Queue size must be >= 1");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> enableSynchronousQueueing() {
                this.syncQueueingEnabled = true;
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onAccepted(Runnable callback) {
                this.onAccepted = Preconditions.checkNotNull(callback, "Accepted callback must be set");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onRejected(Runnable callback) {
                this.onRejected = Preconditions.checkNotNull(callback, "Rejected callback must be set");
                return this;
            }

            public TypedGuard.Builder.BulkheadBuilder<T> onFinished(Runnable callback) {
                this.onFinished = Preconditions.checkNotNull(callback, "Finished callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                this.parent.bulkheadBuilder = this;
                return this.parent;
            }
        }

        static class CircuitBreakerBuilderImpl<V, T>
        implements TypedGuard.Builder.CircuitBreakerBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private Collection<Class<? extends Throwable>> failOn = Collections.singleton(Throwable.class);
            private Collection<Class<? extends Throwable>> skipOn = Collections.emptySet();
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenPredicate;
            private long delayInMillis = 5000L;
            private int requestVolumeThreshold = 20;
            private double failureRatio = 0.5;
            private int successThreshold = 1;
            private String name;
            private Consumer<CircuitBreakerState> onStateChange;
            private Runnable onSuccess;
            private Runnable onFailure;
            private Runnable onPrevented;

            CircuitBreakerBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> failOn(Collection<Class<? extends Throwable>> value) {
                this.failOn = Preconditions.checkNotNull(value, "Exceptions considered failure must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = Preconditions.checkNotNull(value, "Exceptions considered success must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> when(Predicate<Throwable> value) {
                this.whenPredicate = Preconditions.checkNotNull(value, "Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> delay(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Delay must be >= 0");
                Preconditions.checkNotNull(unit, "Delay unit must be set");
                this.delayInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> requestVolumeThreshold(int value) {
                this.requestVolumeThreshold = Preconditions.check(value, value >= 1, "Request volume threshold must be >= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> failureRatio(double value) {
                this.failureRatio = Preconditions.check(value, value >= 0.0 && value <= 1.0, "Failure ratio must be >= 0 and <= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> successThreshold(int value) {
                this.successThreshold = Preconditions.check(value, value >= 1, "Success threshold must be >= 1");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> name(String value) {
                this.name = Preconditions.checkNotNull(value, "Circuit breaker name must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onStateChange(Consumer<CircuitBreakerState> callback) {
                this.onStateChange = Preconditions.checkNotNull(callback, "On state change callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onSuccess(Runnable callback) {
                this.onSuccess = Preconditions.checkNotNull(callback, "On success callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onFailure(Runnable callback) {
                this.onFailure = Preconditions.checkNotNull(callback, "On failure callback must be set");
                return this;
            }

            public TypedGuard.Builder.CircuitBreakerBuilder<T> onPrevented(Runnable callback) {
                this.onPrevented = Preconditions.checkNotNull(callback, "On prevented callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                if (this.whenPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The when() method may not be combined with failOn() / skipOn()");
                }
                this.parent.circuitBreakerBuilder = this;
                return this.parent;
            }
        }

        static class FallbackBuilderImpl<V, T>
        implements TypedGuard.Builder.FallbackBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private Function<Throwable, T> handler;
            private Collection<Class<? extends Throwable>> applyOn = Collections.singleton(Throwable.class);
            private Collection<Class<? extends Throwable>> skipOn = Collections.emptySet();
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenPredicate;

            FallbackBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.FallbackBuilder<T> handler(Supplier<T> value) {
                Preconditions.checkNotNull(value, "Fallback handler must be set");
                this.handler = ignored -> value.get();
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> handler(Function<Throwable, T> value) {
                this.handler = Preconditions.checkNotNull(value, "Fallback handler must be set");
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> applyOn(Collection<Class<? extends Throwable>> value) {
                this.applyOn = Preconditions.checkNotNull(value, "Exceptions to apply fallback on must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = Preconditions.checkNotNull(value, "Exceptions to skip fallback on must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.FallbackBuilder<T> when(Predicate<Throwable> value) {
                this.whenPredicate = Preconditions.checkNotNull(value, "Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                Preconditions.checkNotNull(this.handler, "Fallback handler must be set");
                if (this.whenPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The when() method may not be combined with applyOn() / skipOn()");
                }
                this.parent.fallbackBuilder = this;
                return this.parent;
            }
        }

        static class RateLimitBuilderImpl<V, T>
        implements TypedGuard.Builder.RateLimitBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private int maxInvocations = 100;
            private long timeWindowInMillis = 1000L;
            private long minSpacingInMillis = 0L;
            private RateLimitType type = RateLimitType.FIXED;
            private Runnable onPermitted;
            private Runnable onRejected;

            RateLimitBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> limit(int value) {
                this.maxInvocations = Preconditions.check(value, value >= 1, "Rate limit must be >= 1");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> window(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 1L, "Time window length must be >= 1");
                Preconditions.checkNotNull(unit, "Time window length unit must be set");
                this.timeWindowInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> minSpacing(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Min spacing must be >= 0");
                Preconditions.checkNotNull(unit, "Min spacing unit must be set");
                this.minSpacingInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> type(RateLimitType value) {
                this.type = Preconditions.checkNotNull(value, "Time window type must be set");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> onPermitted(Runnable callback) {
                this.onPermitted = Preconditions.checkNotNull(callback, "Permitted callback must be set");
                return this;
            }

            public TypedGuard.Builder.RateLimitBuilder<T> onRejected(Runnable callback) {
                this.onRejected = Preconditions.checkNotNull(callback, "Rejected callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                this.parent.rateLimitBuilder = this;
                return this.parent;
            }
        }

        static class RetryBuilderImpl<V, T>
        implements TypedGuard.Builder.RetryBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private int maxRetries = 3;
            private long delayInMillis = 0L;
            private long maxDurationInMillis = 180000L;
            private long jitterInMillis = 200L;
            private Collection<Class<? extends Throwable>> retryOn = Collections.singleton(Exception.class);
            private Collection<Class<? extends Throwable>> abortOn = Collections.emptySet();
            private boolean setBasedExceptionDecisionDefined = false;
            private Predicate<Throwable> whenExceptionPredicate;
            private Predicate<Object> whenResultPredicate;
            private Consumer<Throwable> beforeRetry;
            private ExponentialBackoffBuilderImpl<V, T> exponentialBackoffBuilder;
            private FibonacciBackoffBuilderImpl<V, T> fibonacciBackoffBuilder;
            private CustomBackoffBuilderImpl<V, T> customBackoffBuilder;
            private Runnable onRetry;
            private Runnable onSuccess;
            private Runnable onFailure;

            RetryBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.RetryBuilder<T> maxRetries(int value) {
                this.maxRetries = Preconditions.check(value, value >= -1, "Max retries must be >= -1");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> delay(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Delay must be >= 0");
                Preconditions.checkNotNull(unit, "Delay unit must be set");
                this.delayInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> maxDuration(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Max duration must be >= 0");
                Preconditions.checkNotNull(unit, "Max duration unit must be set");
                this.maxDurationInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> jitter(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Jitter must be >= 0");
                Preconditions.checkNotNull(unit, "Jitter unit must be set");
                this.jitterInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> retryOn(Collection<Class<? extends Throwable>> value) {
                this.retryOn = Preconditions.checkNotNull(value, "Exceptions to retry on must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> abortOn(Collection<Class<? extends Throwable>> value) {
                this.abortOn = Preconditions.checkNotNull(value, "Exceptions to abort retrying on must be set");
                this.setBasedExceptionDecisionDefined = true;
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> whenResult(Predicate<Object> value) {
                this.whenResultPredicate = Preconditions.checkNotNull(value, "Result predicate must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> whenException(Predicate<Throwable> value) {
                this.whenExceptionPredicate = Preconditions.checkNotNull(value, "Exception predicate must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> beforeRetry(Runnable value) {
                Preconditions.checkNotNull(value, "Before retry handler must be set");
                this.beforeRetry = ignored -> value.run();
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> beforeRetry(Consumer<Throwable> value) {
                this.beforeRetry = Preconditions.checkNotNull(value, "Before retry handler must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> withExponentialBackoff() {
                return new ExponentialBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T> withFibonacciBackoff() {
                return new FibonacciBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> withCustomBackoff() {
                return new CustomBackoffBuilderImpl(this);
            }

            public TypedGuard.Builder.RetryBuilder<T> onRetry(Runnable callback) {
                this.onRetry = Preconditions.checkNotNull(callback, "Retry callback must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> onSuccess(Runnable callback) {
                this.onSuccess = Preconditions.checkNotNull(callback, "Success callback must be set");
                return this;
            }

            public TypedGuard.Builder.RetryBuilder<T> onFailure(Runnable callback) {
                this.onFailure = Preconditions.checkNotNull(callback, "Failure callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                if (this.whenExceptionPredicate != null && this.setBasedExceptionDecisionDefined) {
                    throw new IllegalStateException("The whenException() method may not be combined with retryOn()/abortOn()");
                }
                int backoffStrategies = 0;
                if (this.exponentialBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.fibonacciBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.customBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (backoffStrategies > 1) {
                    throw new IllegalStateException("Only one backoff strategy may be set for retry");
                }
                this.parent.retryBuilder = this;
                return this.parent;
            }

            static class ExponentialBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> {
                private final RetryBuilderImpl<V, T> parent;
                private int factor = 2;
                private long maxDelayInMillis = 60000L;

                ExponentialBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> factor(int value) {
                    this.factor = Preconditions.check(value, value >= 1, "Factor must be >= 1");
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder.ExponentialBackoffBuilder<T> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check(value, value >= 0L, "Max delay must be >= 0");
                    Preconditions.checkNotNull(unit, "Max delay unit must be set");
                    this.maxDelayInMillis = Durations.timeInMillis(value, unit);
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    this.parent.exponentialBackoffBuilder = this;
                    return this.parent;
                }
            }

            static class FibonacciBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T> {
                private final RetryBuilderImpl<V, T> parent;
                private long maxDelayInMillis = 60000L;

                FibonacciBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.FibonacciBackoffBuilder<T> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check(value, value >= 0L, "Max delay must be >= 0");
                    Preconditions.checkNotNull(unit, "Max delay unit must be set");
                    this.maxDelayInMillis = Durations.timeInMillis(value, unit);
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    this.parent.fibonacciBackoffBuilder = this;
                    return this.parent;
                }
            }

            static class CustomBackoffBuilderImpl<V, T>
            implements TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> {
                private final RetryBuilderImpl<V, T> parent;
                private Supplier<CustomBackoffStrategy> strategy;

                CustomBackoffBuilderImpl(RetryBuilderImpl<V, T> parent) {
                    this.parent = parent;
                }

                public TypedGuard.Builder.RetryBuilder.CustomBackoffBuilder<T> strategy(Supplier<CustomBackoffStrategy> value) {
                    this.strategy = Preconditions.checkNotNull(value, "Custom backoff strategy must be set");
                    return this;
                }

                public TypedGuard.Builder.RetryBuilder<T> done() {
                    Preconditions.checkNotNull(this.strategy, "Custom backoff strategy must be set");
                    this.parent.customBackoffBuilder = this;
                    return this.parent;
                }
            }
        }

        static class TimeoutBuilderImpl<V, T>
        implements TypedGuard.Builder.TimeoutBuilder<T> {
            private final BuilderImpl<V, T> parent;
            private long durationInMillis = 1000L;
            private Runnable onTimeout;
            private Runnable onFinished;

            TimeoutBuilderImpl(BuilderImpl<V, T> parent) {
                this.parent = parent;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> duration(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Timeout duration must be >= 0");
                Preconditions.checkNotNull(unit, "Timeout duration unit must be set");
                this.durationInMillis = Durations.timeInMillis(value, unit);
                return this;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> onTimeout(Runnable callback) {
                this.onTimeout = Preconditions.checkNotNull(callback, "Timeout callback must be set");
                return this;
            }

            public TypedGuard.Builder.TimeoutBuilder<T> onFinished(Runnable callback) {
                this.onFinished = Preconditions.checkNotNull(callback, "Finished callback must be set");
                return this;
            }

            public TypedGuard.Builder<T> done() {
                this.parent.timeoutBuilder = this;
                return this.parent;
            }
        }
    }
}

