/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class ThreadOffloadFallbackFunction<T>
implements FallbackFunction<T> {
    private final Function<FailureContext, Future<T>> delegate;
    private final Executor executor;

    public ThreadOffloadFallbackFunction(Function<FailureContext, Future<T>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = executor;
    }

    @Override
    public Future<T> apply(FailureContext ctx) {
        Completer result = Completer.create();
        this.executor.execute(() -> {
            try {
                this.delegate.apply(ctx).thenComplete(result);
            }
            catch (Exception e) {
                result.completeWithError(e);
            }
        });
        return result.future();
    }
}

