/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.logging;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.counter.exception.CounterConfigurationException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.infinispan.counter.logging.Log;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String missingCounterName$str() {
        return "ISPN029503: The counter name is missing.";
    }

    @Override
    public final CounterConfigurationException missingCounterName() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.missingCounterName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidStorageMode$str() {
        return "ISPN029504: Invalid storage mode. It must be non-null";
    }

    @Override
    public final CounterConfigurationException invalidStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidStorageMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPersistentStorageMode$str() {
        return "ISPN029505: Invalid storage mode. PERSISTENT is not allowed without global state enabled in cache container.";
    }

    @Override
    public final CounterConfigurationException invalidPersistentStorageMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidPersistentStorageMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNumOwners$str() {
        return "ISPN029506: Invalid number of owner. It must be higher than zero but it was %s";
    }

    @Override
    public final CounterConfigurationException invalidNumOwners(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidNumOwners$str(), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidReliabilityMode$str() {
        return "ISPN029507: Invalid reliability mode. It must be non-null";
    }

    @Override
    public final CounterConfigurationException invalidReliabilityMode() {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidReliabilityMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidInitialValueForBoundedCounter$str() {
        return "ISPN029508: Invalid initial value for counter. It must be between %s and %s (inclusive) but was %s";
    }

    @Override
    public final CounterConfigurationException invalidInitialValueForBoundedCounter(long lower, long upper, long value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidInitialValueForBoundedCounter$str(), lower, upper, value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidConcurrencyLevel$str() {
        return "ISPN029509: Invalid concurrency-level. It must be higher than zero but it was %s";
    }

    @Override
    public final CounterConfigurationException invalidConcurrencyLevel(int value) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidConcurrencyLevel$str(), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidCounterType$str() {
        return "ISPN029514: Invalid counter type. Expected=%s but got %s";
    }

    @Override
    public final CounterException invalidCounterType(String expected, String actual) {
        CounterException result = new CounterException(String.format(this.getLoggingLocale(), this.invalidCounterType$str(), expected, actual));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String undefinedCounter$str() {
        return "ISPN029516: Counter '%s' is not defined.";
    }

    @Override
    public final CounterNotFoundException undefinedCounter(String name) {
        CounterNotFoundException result = new CounterNotFoundException(String.format(this.getLoggingLocale(), this.undefinedCounter$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicatedCounterName$str() {
        return "ISPN029517: Duplicated counter name found. Counter '%s' already exists.";
    }

    @Override
    public final CounterConfigurationException duplicatedCounterName(String counter) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.duplicatedCounterName$str(), counter));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String metadataIsMissing$str() {
        return "ISPN029518: Metadata not found but counter exists. Counter=%s";
    }

    @Override
    public final IllegalStateException metadataIsMissing(ByteString counterName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.metadataIsMissing$str(), counterName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidScope$str() {
        return "ISPN029520: Invalid scope for tag <counter>. Expected CACHE_CONTAINER but was %s";
    }

    @Override
    public final CounterConfigurationException invalidScope(String scope) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidScope$str(), scope));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSameLowerAndUpperBound$str() {
        return "ISPN029524: Lower bound (%s) and upper bound (%s) can't be the same.";
    }

    @Override
    public final CounterConfigurationException invalidSameLowerAndUpperBound(long lower, long upper) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.invalidSameLowerAndUpperBound$str(), lower, upper));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRenamePersistentFile$str() {
        return "ISPN029525: Cannot rename file %s to %s";
    }

    @Override
    public final CounterConfigurationException cannotRenamePersistentFile(String absolutePath, File persistentFile, Throwable cause) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorPersistingCountersConfiguration$str() {
        return "ISPN029526: Error while persisting counter's configurations";
    }

    @Override
    public final CounterConfigurationException errorPersistingCountersConfiguration(Throwable cause) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.errorPersistingCountersConfiguration$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorReadingCountersConfiguration$str() {
        return "ISPN029527: Error while reading counter's configurations";
    }

    @Override
    public final CounterConfigurationException errorReadingCountersConfiguration(Throwable cause) {
        CounterConfigurationException result = new CounterConfigurationException(String.format(this.getLoggingLocale(), this.errorReadingCountersConfiguration$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String counterManagerNotStarted$str() {
        return "ISPN029528: CounterManager hasn't started yet or has been stopped.";
    }

    @Override
    public final CounterException counterManagerNotStarted() {
        CounterException result = new CounterException(String.format(this.getLoggingLocale(), this.counterManagerNotStarted$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String jmxRegistrationFailed$str() {
        return "ISPN029529: MBean registration failed";
    }

    @Override
    public final CounterException jmxRegistrationFailed(Throwable cause) {
        CounterException result = new CounterException(String.format(this.getLoggingLocale(), this.jmxRegistrationFailed$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

